/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicHeader;
import org.sahli.asciidoc.confluence.publisher.client.http.HttpRequestFactory;
import org.sahli.asciidoc.confluence.publisher.client.utils.AssertUtils;

class HttpRequestV2Factory
implements HttpRequestFactory {
    private static final Header APPLICATION_JSON_UTF8_HEADER = new BasicHeader("Content-Type", "application/json;charset=utf-8");
    private static final String API_V2_CONTEXT = "/api/v2";
    private static final String API_V1_CONTEXT = "/rest/api";
    private final String rootConfluenceUrl;
    private final String confluenceServerUrl;
    private final String confluenceApiV2Endpoint;
    private final String confluenceApiV1Endpoint;
    private final ObjectMapper objectMapper = new ObjectMapper();

    HttpRequestV2Factory(String rootConfluenceUrl) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)rootConfluenceUrl), "rootConfluenceUrl");
        this.rootConfluenceUrl = rootConfluenceUrl;
        this.confluenceServerUrl = HttpRequestV2Factory.confluenceServerUrl(this.rootConfluenceUrl);
        this.confluenceApiV2Endpoint = rootConfluenceUrl + API_V2_CONTEXT;
        this.confluenceApiV1Endpoint = rootConfluenceUrl + API_V1_CONTEXT;
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public HttpGet lookupSpaceIdRequest(String spaceKey) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)spaceKey), "spaceKey");
        HttpGet lookupSpaceIdRequest = new HttpGet(this.confluenceApiV2Endpoint + "/spaces?keys=" + HttpRequestV2Factory.urlEncode(spaceKey));
        lookupSpaceIdRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return lookupSpaceIdRequest;
    }

    @Override
    public HttpPost addPageUnderAncestorRequest(String spaceKey, String ancestorId, String title, String content, String versionMessage) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)spaceKey), "spaceKey");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)title), "title");
        ObjectNode pagePayload = this.objectMapper.createObjectNode();
        pagePayload.put("spaceId", spaceKey);
        pagePayload.put("status", "current");
        pagePayload.put("title", title);
        if (StringUtils.isNotBlank((CharSequence)ancestorId)) {
            pagePayload.put("parentId", ancestorId);
        }
        ObjectNode bodyNode = this.objectMapper.createObjectNode();
        bodyNode.put("representation", "storage");
        bodyNode.put("value", content);
        pagePayload.set("body", (JsonNode)bodyNode);
        if (versionMessage != null) {
            ObjectNode versionNode = this.objectMapper.createObjectNode();
            versionNode.put("message", versionMessage);
            pagePayload.set("version", (JsonNode)versionNode);
        }
        HttpPost pagePostRequest = new HttpPost(this.confluenceApiV2Endpoint + "/pages");
        pagePostRequest.setEntity((HttpEntity)this.httpEntityWithJsonPayload(pagePayload));
        pagePostRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return pagePostRequest;
    }

    @Override
    public HttpPut updatePageRequest(String contentId, String ancestorId, String title, String content, int newVersion, String versionMessage, boolean notifyWatchers) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)title), "title");
        ObjectNode pagePayload = this.objectMapper.createObjectNode();
        pagePayload.put("id", contentId);
        pagePayload.put("status", "current");
        pagePayload.put("title", title);
        if (StringUtils.isNotBlank((CharSequence)ancestorId)) {
            pagePayload.put("parentId", ancestorId);
        }
        ObjectNode bodyNode = this.objectMapper.createObjectNode();
        bodyNode.put("representation", "storage");
        bodyNode.put("value", content);
        pagePayload.set("body", (JsonNode)bodyNode);
        ObjectNode versionNode = this.objectMapper.createObjectNode();
        versionNode.put("number", newVersion);
        if (versionMessage != null) {
            versionNode.put("message", versionMessage);
        }
        if (!notifyWatchers) {
            pagePayload.put("minorEdit", true);
        }
        pagePayload.set("version", (JsonNode)versionNode);
        HttpPut updatePageRequest = new HttpPut(this.confluenceApiV2Endpoint + "/pages/" + contentId);
        updatePageRequest.setEntity((HttpEntity)this.httpEntityWithJsonPayload(pagePayload));
        updatePageRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return updatePageRequest;
    }

    @Override
    public HttpDelete deletePageRequest(String contentId) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        return new HttpDelete(this.confluenceApiV2Endpoint + "/pages/" + contentId);
    }

    @Override
    public HttpPost addAttachmentRequest(String contentId, String attachmentFileName, InputStream attachmentContent) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)attachmentFileName), "attachmentFileName");
        AssertUtils.assertMandatoryParameter(attachmentContent != null, "attachmentContent");
        HttpPost attachmentPostRequest = new HttpPost(this.confluenceApiV1Endpoint + "/content/" + contentId + "/child/attachment");
        attachmentPostRequest.addHeader((Header)new BasicHeader("X-Atlassian-Token", "no-check"));
        HttpEntity multipartEntity = HttpRequestV2Factory.multipartEntity(attachmentFileName, attachmentContent, false);
        attachmentPostRequest.setEntity(multipartEntity);
        return attachmentPostRequest;
    }

    @Override
    public HttpPost updateAttachmentContentRequest(String contentId, String attachmentId, InputStream attachmentContent, boolean notifyWatchers) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)attachmentId), "attachmentId");
        AssertUtils.assertMandatoryParameter(attachmentContent != null, "attachmentContent");
        HttpPost attachmentPostRequest = new HttpPost(this.confluenceApiV1Endpoint + "/content/" + contentId + "/child/attachment/" + attachmentId + "/data");
        attachmentPostRequest.addHeader((Header)new BasicHeader("X-Atlassian-Token", "no-check"));
        HttpEntity multipartEntity = HttpRequestV2Factory.multipartEntity(null, attachmentContent, notifyWatchers);
        attachmentPostRequest.setEntity(multipartEntity);
        return attachmentPostRequest;
    }

    @Override
    public HttpDelete deleteAttachmentRequest(String attachmentId) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)attachmentId), "attachmentId");
        return new HttpDelete(this.confluenceApiV2Endpoint + "/attachments/" + attachmentId);
    }

    @Override
    public HttpGet getPageByTitleRequest(String spaceId, String title) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)spaceId), "spaceId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)title), "title");
        return new HttpGet(this.confluenceApiV2Endpoint + "/spaces/" + spaceId + "/pages?title=" + HttpRequestV2Factory.urlEncode(title));
    }

    @Override
    public HttpGet getAttachmentByFileNameRequest(String contentId, String attachmentFileName, String expandOptions) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)attachmentFileName), "attachmentFileName");
        URIBuilder uriBuilder = HttpRequestV2Factory.createUriBuilder(this.confluenceApiV2Endpoint + "/pages/" + contentId + "/attachments");
        uriBuilder.addParameter("filename", attachmentFileName);
        uriBuilder.addParameter("limit", "1");
        try {
            return new HttpGet(uriBuilder.build().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URL", e);
        }
    }

    @Override
    public HttpGet getPageByIdRequest(String contentId, String expandOptions) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        return new HttpGet(this.confluenceApiV2Endpoint + "/pages/" + contentId + "?include-version=true");
    }

    @Override
    public HttpGet getChildPagesByIdRequest(String parentContentId, Integer limit, Integer start, String expandOptions) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)parentContentId), "parentContentId");
        return new HttpGet(this.confluenceApiV2Endpoint + "/pages/" + parentContentId + "/direct-children?limit=" + limit);
    }

    public HttpGet getNextChildPagesByIdRequest(String nextLink) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)nextLink), "nextLink");
        return new HttpGet(HttpRequestV2Factory.confluenceServerUrl(this.rootConfluenceUrl) + nextLink);
    }

    @Override
    public HttpGet getAttachmentsRequest(String contentId, Integer limit, Integer start, String expandOptions) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        return new HttpGet(this.confluenceApiV2Endpoint + "/pages/" + contentId + "/attachments?limit=" + limit);
    }

    public HttpGet getNextAttachmentsRequest(String nextLink) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)nextLink), "nextLink");
        return new HttpGet(this.confluenceServerUrl + nextLink);
    }

    @Override
    public HttpGet getAttachmentContentRequest(String relativeDownloadLink) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)relativeDownloadLink), "relativeDownloadLink");
        return new HttpGet(this.rootConfluenceUrl + relativeDownloadLink);
    }

    @Override
    public HttpGet getPropertyByKeyRequest(String contentId, String key) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)key), "key");
        return new HttpGet(this.confluenceApiV2Endpoint + "/pages/" + contentId + "/properties?key=" + HttpRequestV2Factory.urlEncode(key));
    }

    @Override
    public HttpDelete deletePropertyByKeyRequest(String contentId, String key) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)key), "key");
        return new HttpDelete(this.confluenceApiV2Endpoint + "/pages/" + contentId + "/properties/" + HttpRequestV2Factory.urlEncode(key));
    }

    public HttpGet lookupPropertyIdByKey(String contentId, String key) {
        return new HttpGet(this.confluenceApiV2Endpoint + "/pages/" + contentId + "/properties?key=" + HttpRequestV2Factory.urlEncode(key));
    }

    @Override
    public HttpPost setPropertyByKeyRequest(String contentId, String key, String value) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)key), "key");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)value), "value");
        ObjectNode propertyPayload = this.objectMapper.createObjectNode();
        propertyPayload.put("key", key);
        propertyPayload.put("value", value);
        HttpPost postRequest = new HttpPost(this.confluenceApiV2Endpoint + "/pages/" + contentId + "/properties");
        postRequest.setEntity((HttpEntity)this.httpEntityWithJsonPayload(propertyPayload));
        postRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return postRequest;
    }

    @Override
    public HttpGet getLabelsRequest(String contentId) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        return new HttpGet(this.confluenceApiV2Endpoint + "/pages/" + contentId + "/labels");
    }

    @Override
    public HttpPost addLabelsRequest(String contentId, List<String> labels) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(!labels.isEmpty(), "labels");
        ObjectNode[] labelNodes = (ObjectNode[])labels.stream().map(label -> {
            ObjectNode node = this.objectMapper.createObjectNode();
            node.put("name", label);
            return node;
        }).toArray(ObjectNode[]::new);
        HttpPost addLabelsRequest = new HttpPost(this.confluenceApiV1Endpoint + "/content/" + contentId + "/label");
        addLabelsRequest.setEntity((HttpEntity)this.httpEntityWithJsonPayload(labelNodes));
        addLabelsRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return addLabelsRequest;
    }

    @Override
    public HttpDelete deleteLabelRequest(String contentId, String label) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)label), "label");
        return new HttpDelete(this.confluenceApiV1Endpoint + "/content/" + contentId + "/label?name=" + HttpRequestV2Factory.urlEncode(label));
    }

    private static String confluenceServerUrl(String rootConfluenceUrl) {
        URIBuilder uriBuilder = HttpRequestV2Factory.createUriBuilder(rootConfluenceUrl);
        if (uriBuilder.getPort() != -1) {
            return uriBuilder.getScheme() + "://" + uriBuilder.getHost() + ":" + uriBuilder.getPort();
        }
        return uriBuilder.getScheme() + "://" + uriBuilder.getHost();
    }

    private static URIBuilder createUriBuilder(String path) {
        try {
            return new URIBuilder(path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse path as URI: " + path, e);
        }
    }

    private BasicHttpEntity httpEntityWithJsonPayload(Object payload) {
        String jsonPayload = this.toJsonString(payload);
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent((InputStream)new ByteArrayInputStream(jsonPayload.getBytes(StandardCharsets.UTF_8)));
        return entity;
    }

    private String toJsonString(Object objectToConvert) {
        try {
            return this.objectMapper.writeValueAsString(objectToConvert);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while converting object to JSON", e);
        }
    }

    private static HttpEntity multipartEntity(String attachmentFileName, InputStream attachmentContent, boolean notifyWatchers) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        InputStreamBody inputStreamBody = StringUtils.isNotBlank((CharSequence)attachmentFileName) ? new InputStreamBody(attachmentContent, ContentType.APPLICATION_OCTET_STREAM, attachmentFileName) : new InputStreamBody(attachmentContent, ContentType.APPLICATION_OCTET_STREAM);
        multipartEntityBuilder.addPart("file", (ContentBody)inputStreamBody);
        if (!notifyWatchers) {
            multipartEntityBuilder.addPart("minorEdit", (ContentBody)new StringBody("true", ContentType.DEFAULT_TEXT));
        }
        return multipartEntityBuilder.build();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not url-encode value '" + value + "'", e);
        }
    }
}

