/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.http;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.sahli.asciidoc.confluence.publisher.client.utils.InputStreamUtils;

public class RequestFailedException
extends RuntimeException {
    RequestFailedException(HttpRequest request, HttpResponse response) {
        super("" + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + " " + request.getRequestLine().getMethod() + " " + request.getRequestLine().getUri() + "\nrequest: '" + RequestFailedException.failedRequestContent(request) + "'\nresponse: '" + RequestFailedException.failedResponseContent(response) + "'");
    }

    private static String failedRequestContent(HttpRequest request) {
        return request instanceof HttpEntityEnclosingRequest ? RequestFailedException.entityAsString(((HttpEntityEnclosingRequest)request).getEntity()) : "";
    }

    private static String failedResponseContent(HttpResponse response) {
        return RequestFailedException.entityAsString(response.getEntity());
    }

    private static String entityAsString(HttpEntity entity) {
        try {
            InputStream content = entity.getContent();
            Charset encoding = entity.getContentEncoding() == null ? Charset.defaultCharset() : Charset.forName(entity.getContentEncoding().getValue());
            String contentString = InputStreamUtils.inputStreamAsString(content, encoding);
            return contentString;
        }
        catch (Exception ignored) {
            return "";
        }
    }
}

