/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.maven.plugin;

import java.io.File;
import java.nio.charset.Charset;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisher;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisherListener;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceRestClient;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocConfluenceConverter;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocPagesStructureProvider;
import org.sahli.asciidoc.confluence.publisher.converter.FolderBasedAsciidocPagesStructureProvider;
import org.sahli.asciidoc.confluence.publisher.converter.PageTitlePostProcessor;
import org.sahli.asciidoc.confluence.publisher.converter.PrefixAndSuffixPageTitlePostProcessor;

@Mojo(name="publish")
public class AsciidocConfluencePublisherMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/asciidoc-confluence-publisher", readonly=true)
    private File confluencePublisherBuildFolder;
    @Parameter
    private File asciidocRootFolder;
    @Parameter(defaultValue="UTF-8")
    private String sourceEncoding;
    @Parameter
    private String rootConfluenceUrl;
    @Parameter(required=true)
    private String spaceKey;
    @Parameter(required=true)
    private String ancestorId;
    @Parameter
    private String username;
    @Parameter
    private String password;
    @Parameter
    private String pageTitlePrefix;
    @Parameter
    private String pageTitleSuffix;

    public void execute() throws MojoExecutionException {
        try {
            PrefixAndSuffixPageTitlePostProcessor pageTitlePostProcessor = new PrefixAndSuffixPageTitlePostProcessor(this.pageTitlePrefix, this.pageTitleSuffix);
            FolderBasedAsciidocPagesStructureProvider asciidocPagesStructureProvider = new FolderBasedAsciidocPagesStructureProvider(this.asciidocRootFolder.toPath(), Charset.forName(this.sourceEncoding));
            AsciidocConfluenceConverter asciidocConfluenceConverter = new AsciidocConfluenceConverter(this.spaceKey, this.ancestorId);
            ConfluencePublisherMetadata confluencePublisherMetadata = asciidocConfluenceConverter.convert((AsciidocPagesStructureProvider)asciidocPagesStructureProvider, (PageTitlePostProcessor)pageTitlePostProcessor, this.confluencePublisherBuildFolder.toPath());
            ConfluenceRestClient confluenceRestClient = new ConfluenceRestClient(this.rootConfluenceUrl, this.username, this.password);
            LoggingConfluencePublisherListener confluencePublisherListener = new LoggingConfluencePublisherListener(this.getLog());
            ConfluencePublisher confluencePublisher = new ConfluencePublisher(confluencePublisherMetadata, (ConfluenceClient)confluenceRestClient, (ConfluencePublisherListener)confluencePublisherListener);
            confluencePublisher.publish();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Publishing to Confluence failed: " + e.getMessage()));
            throw new MojoExecutionException("Publishing to Confluence failed", e);
        }
    }

    private static class LoggingConfluencePublisherListener
    implements ConfluencePublisherListener {
        private Log log;

        LoggingConfluencePublisherListener(Log log) {
            this.log = log;
        }

        public void pageAdded(ConfluencePage addedPage) {
            this.log.info((CharSequence)("Added page '" + addedPage.getTitle() + "' (id " + addedPage.getContentId() + ")"));
        }

        public void pageUpdated(ConfluencePage existingPage, ConfluencePage updatedPage) {
            this.log.info((CharSequence)("Updated page '" + updatedPage.getTitle() + "' (id " + updatedPage.getContentId() + ", version " + existingPage.getVersion() + " -> " + updatedPage.getVersion() + ")"));
        }

        public void pageDeleted(ConfluencePage deletedPage) {
            this.log.info((CharSequence)("Deleted page '" + deletedPage.getTitle() + "' (id " + deletedPage.getContentId() + ")"));
        }

        public void publishCompleted() {
        }
    }
}

