/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.NativeLoader;
import sbt.internal.NativeLookup;
import sbt.util.Logger;

abstract class ManagedClassLoader
extends URLClassLoader
implements NativeLoader {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean printedWarning = new AtomicBoolean(false);
    private final AtomicReference<ZombieClassLoader> zombieLoader = new AtomicReference();
    private final boolean allowZombies;
    private final Logger logger;
    private final NativeLookup nativeLookup = new NativeLookup();

    ManagedClassLoader(URL[] uRLArray, ClassLoader classLoader, boolean bl, Logger logger) {
        super(uRLArray, classLoader);
        this.allowZombies = bl;
        this.logger = logger;
    }

    private ZombieClassLoader getZombieLoader(String string) {
        Object object;
        if (this.printedWarning.compareAndSet(false, true) && !this.allowZombies) {
            object = Thread.currentThread() + " loading " + string + " after test or run " + "has completed. This is a likely resource leak";
            this.logger.warn(() -> ManagedClassLoader.lambda$getZombieLoader$0((String)object));
        }
        if ((object = this.zombieLoader.get()) != null) {
            return object;
        }
        ZombieClassLoader zombieClassLoader = new ZombieClassLoader(this.getURLs());
        this.zombieLoader.set(zombieClassLoader);
        return zombieClassLoader;
    }

    @Override
    public URL findResource(String string) {
        return this.closed.get() ? this.getZombieLoader(string).findResource(string) : super.findResource(string);
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        return this.closed.get() ? this.getZombieLoader(string).lookupClass(string) : super.findClass(string);
    }

    @Override
    public void close() throws IOException {
        ZombieClassLoader zombieClassLoader = this.zombieLoader.getAndSet(null);
        if (zombieClassLoader != null) {
            zombieClassLoader.close();
        }
        if (this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    @Override
    public String findLibrary(String string) {
        return this.nativeLookup.findLibrary(string);
    }

    @Override
    public void setTempDir(File file) {
        this.nativeLookup.setTempDir(file);
    }

    private static /* synthetic */ String lambda$getZombieLoader$0(String string) {
        return string;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class ZombieClassLoader
    extends URLClassLoader {
        private final URL[] urls;

        ZombieClassLoader(URL[] uRLArray) {
            super(uRLArray, (ClassLoader)ManagedClassLoader.this);
            this.urls = uRLArray;
        }

        Class<?> lookupClass(String string) throws ClassNotFoundException {
            try {
                return this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder();
                for (URL uRL : this.urls) {
                    File file = new File(uRL.getPath());
                    if (!file.exists()) continue;
                    stringBuilder.append(file.toString()).append('\n');
                }
                String string2 = stringBuilder.toString();
                if (!string2.isEmpty()) {
                    String string3 = "Couldn't load class $name. The following urls on the classpath do not exist:\n" + (String)string2 + "This may be due to shutdown hooks added during an invocation of `run`.";
                    System.err.println(string3);
                }
                throw classNotFoundException;
            }
        }
    }
}

