/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.BottomClassLoader;
import sbt.internal.ClassLoadingLock;
import sbt.internal.ManagedClassLoader;
import sbt.util.Logger;

final class ReverseLookupClassLoader
extends ManagedClassLoader {
    private final AtomicReference<BottomClassLoader> directDescendant = new AtomicReference();
    private final AtomicBoolean dirty = new AtomicBoolean(false);
    private final ClassLoadingLock classLoadingLock = new ClassLoadingLock();
    private final AtomicReference<ResourceLoader> resourceLoader = new AtomicReference();
    private final ClassLoader parent;

    ReverseLookupClassLoader(URL[] uRLArray, ClassLoader classLoader, boolean bl, Logger logger) {
        super(uRLArray, classLoader, bl, logger);
        this.parent = classLoader;
    }

    boolean isDirty() {
        return this.dirty.get();
    }

    void setDescendant(BottomClassLoader bottomClassLoader) {
        this.directDescendant.set(bottomClassLoader);
    }

    @Override
    public URL findResource(String string) {
        ResourceLoader resourceLoader = this.resourceLoader.get();
        return resourceLoader == null ? null : resourceLoader.lookup(string);
    }

    void setup(File file, URL[] uRLArray) throws IOException {
        this.setTempDir(file);
        ResourceLoader resourceLoader = this.resourceLoader.getAndSet(new ResourceLoader(uRLArray));
        if (resourceLoader != null) {
            resourceLoader.close();
        }
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        return this.loadClass(string, bl, true);
    }

    Class<?> loadClass(String string, boolean bl, boolean bl2) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = this.parent.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = this.findClass(string, bl2);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private Class<?> findClass(String string, boolean bl) throws ClassNotFoundException {
        return this.classLoadingLock.withLock(string, () -> {
            try {
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz != null) {
                    return clazz;
                }
                return this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    BottomClassLoader bottomClassLoader = this.directDescendant.get();
                    if (bottomClassLoader == null) {
                        throw classNotFoundException;
                    }
                    Class<?> clazz = bottomClassLoader.findClass(string);
                    this.dirty.set(true);
                    return clazz;
                }
                throw classNotFoundException;
            }
        });
    }

    static {
        ReverseLookupClassLoader.registerAsParallelCapable();
    }

    private class ResourceLoader
    extends URLClassLoader {
        ResourceLoader(URL[] uRLArray) {
            super(uRLArray, ReverseLookupClassLoader.this.parent);
        }

        final URL lookup(String string) {
            return this.findResource(string);
        }
    }
}

