/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.server;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import sbt.StandardMain$;
import sbt.compiler.ForwardingReporter;
import sbt.internal.bsp.BuildTargetIdentifier;
import sbt.internal.bsp.Diagnostic;
import sbt.internal.bsp.Diagnostic$;
import sbt.internal.bsp.DiagnosticSeverity$;
import sbt.internal.bsp.Position$;
import sbt.internal.bsp.PublishDiagnosticsParams;
import sbt.internal.bsp.PublishDiagnosticsParams$;
import sbt.internal.bsp.Range;
import sbt.internal.bsp.Range$;
import sbt.internal.bsp.TextDocumentIdentifier$;
import sbt.internal.bsp.codec.JsonProtocol$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.Reporter;
import scala.reflect.internal.util.DefinedPosition;
import scala.reflect.internal.util.Position;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.reporters.FilteringReporter;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\u0006\f\u0001IA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\tA\u0001\u0011\t\u0011)A\u0005C!)Q\u0006\u0001C\u0001]!91\u0007\u0001b\u0001\n\u0013!\u0004B\u0002,\u0001A\u0003%Q\u0007C\u0003X\u0001\u0011\u0005\u0003\fC\u0003{\u0001\u0011\u00053\u0010C\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\u0010\u0001!I!!\u0005\u0003/\t+\u0018\u000e\u001c3TKJ4XM]#wC2\u0014V\r]8si\u0016\u0014(B\u0001\u0007\u000e\u0003\u0019\u0019XM\u001d<fe*\u0011abD\u0001\tS:$XM\u001d8bY*\t\u0001#A\u0002tER\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\u0011acD\u0001\tG>l\u0007/\u001b7fe&\u0011\u0001$\u0006\u0002\u0013\r>\u0014x/\u0019:eS:<'+\u001a9peR,'/A\u0006ck&dG\rV1sO\u0016$\bCA\u000e\u001f\u001b\u0005a\"BA\u000f\u000e\u0003\r\u00117\u000f]\u0005\u0003?q\u0011QCQ;jY\u0012$\u0016M]4fi&#WM\u001c;jM&,'/\u0001\u0005eK2,w-\u0019;f!\t\u00113&D\u0001$\u0015\t!S%A\u0005sKB|'\u000f^3sg*\u0011aeJ\u0001\u0004]N\u001c'B\u0001\u0015*\u0003\u0015!xn\u001c7t\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017$\u0005E1\u0015\u000e\u001c;fe&twMU3q_J$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\n$\u0007\u0005\u00021\u00015\t1\u0002C\u0003\u001a\u0007\u0001\u0007!\u0004C\u0003!\u0007\u0001\u0007\u0011%\u0001\bqe>\u0014G.Z7t\u0005f4\u0015\u000e\\3\u0016\u0003U\u0002BAN\u001e>\u000f6\tqG\u0003\u00029s\u00059Q.\u001e;bE2,'B\u0001\u001e*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003y]\u00121!T1q!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003gS2,'B\u0001\"D\u0003\rq\u0017n\u001c\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1uH\u0001\u0003QCRD\u0007c\u0001%Q':\u0011\u0011J\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019F\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0005=K\u0013a\u00029bG.\fw-Z\u0005\u0003#J\u0013aAV3di>\u0014(BA(*!\tYB+\u0003\u0002V9\tQA)[1h]>\u001cH/[2\u0002\u001fA\u0014xN\u00197f[N\u0014\u0015PR5mK\u0002\n\u0001\u0002Z8SKB|'\u000f\u001e\u000b\u00053vC'\u000f\u0005\u0002[76\t\u0011&\u0003\u0002]S\t!QK\\5u\u0011\u0015qf\u00011\u0001`\u0003\r\u0001xn\u001d\t\u0003A\u001al\u0011!\u0019\u0006\u0003E\u000e\fA!\u001e;jY*\u0011a\u0002\u001a\u0006\u0003K&\nqA]3gY\u0016\u001cG/\u0003\u0002hC\nA\u0001k\\:ji&|g\u000eC\u0003j\r\u0001\u0007!.A\u0002ng\u001e\u0004\"a[8\u000f\u00051l\u0007C\u0001&*\u0013\tq\u0017&\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018*\u0011\u0015\u0019h\u00011\u0001u\u0003!\u0019XM^3sSRL\bCA;w\u001b\u0005\u0001\u0011BA<y\u0005!\u0019VM^3sSRL\u0018BA=d\u0005!\u0011V\r]8si\u0016\u0014\u0018a\u00034j]\u0006d'+\u001a9peR$\"!\u0017?\t\u000bu<\u0001\u0019\u00016\u0002\u0015M|WO]2f\u001d\u0006lW-\u0001\u0007d_:4XM\u001d;U_\n\u001b\b\u000f\u0006\u0003\u0002\u0002\u00055\u0001#\u0002.\u0002\u0004\u0005\u001d\u0011bAA\u0003S\t1q\n\u001d;j_:\u00042AWA\u0005\u0013\r\tY!\u000b\u0002\u0005\u0019>tw\rC\u0003t\u0011\u0001\u0007A/\u0001\bd_:4XM\u001d;U_J\u000bgnZ3\u0015\t\u0005M\u00111\u0004\t\u00065\u0006\r\u0011Q\u0003\t\u00047\u0005]\u0011bAA\r9\t)!+\u00198hK\")a,\u0003a\u0001?\u0002")
public class BuildServerEvalReporter
extends ForwardingReporter {
    private final BuildTargetIdentifier buildTarget;
    private final Map<Path, Vector<Diagnostic>> problemsByFile;

    private Map<Path, Vector<Diagnostic>> problemsByFile() {
        return this.problemsByFile;
    }

    public void doReport(Position pos, String msg, Reporter.Severity severity) {
        (pos.source().file().exists() ? new Some((Object)Paths.get(pos.source().file().path(), new String[0])) : None$.MODULE$).foreach((Function1 & Serializable & scala.Serializable)filePath -> {
            BuildServerEvalReporter.$anonfun$doReport$1(this, pos, severity, msg, filePath);
            return BoxedUnit.UNIT;
        });
        super.doReport(pos, msg, severity);
    }

    public void finalReport(String sourceName) {
        Path filePath = Paths.get(sourceName, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            Vector diagnostics = (Vector)this.problemsByFile().getOrElse((Object)filePath, (Function0 & Serializable & scala.Serializable)() -> (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$));
            PublishDiagnosticsParams params = PublishDiagnosticsParams$.MODULE$.apply(TextDocumentIdentifier$.MODULE$.apply(filePath.toUri()), this.buildTarget, (Option)None$.MODULE$, diagnostics, true);
            StandardMain$.MODULE$.exchange().notifyEvent("build/publishDiagnostics", params, JsonProtocol$.MODULE$.PublishDiagnosticsParamsFormat());
            return;
        }
    }

    private Option<Object> convertToBsp(Reporter.Severity severity) {
        long l;
        Reporter.Severity severity2 = severity;
        if (Reporter.INFO$.MODULE$.equals(severity2)) {
            l = DiagnosticSeverity$.MODULE$.Information();
        } else if (Reporter.WARNING$.MODULE$.equals(severity2)) {
            l = DiagnosticSeverity$.MODULE$.Warning();
        } else if (Reporter.ERROR$.MODULE$.equals(severity2)) {
            l = DiagnosticSeverity$.MODULE$.Error();
        } else {
            throw new MatchError((Object)severity2);
        }
        long result = l;
        return new Some((Object)BoxesRunTime.boxToLong((long)result));
    }

    private Option<Range> convertToRange(Position pos) {
        Position position = pos;
        if (position instanceof DefinedPosition) {
            int startLine = pos.source().offsetToLine(pos.start());
            int startChar = pos.start() - pos.source().lineToOffset(startLine);
            int endLine = pos.source().offsetToLine(pos.end());
            int endChar = pos.end() - pos.source().lineToOffset(endLine);
            return new Some((Object)Range$.MODULE$.apply(Position$.MODULE$.apply((long)startLine, (long)startChar), Position$.MODULE$.apply((long)endLine, (long)endChar)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$doReport$2(BuildServerEvalReporter $this, Reporter.Severity severity$1, String msg$1, Path filePath$1, Range range) {
        Option<Object> bspSeverity = $this.convertToBsp(severity$1);
        Diagnostic diagnostic = Diagnostic$.MODULE$.apply(range, bspSeverity, (Option)None$.MODULE$, Option$.MODULE$.apply((Object)"sbt"), msg$1);
        $this.problemsByFile().update((Object)filePath$1, ((Vector)$this.problemsByFile().getOrElse((Object)filePath$1, (Function0 & Serializable & scala.Serializable)() -> (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$))).$colon$plus((Object)diagnostic, Vector$.MODULE$.canBuildFrom()));
        PublishDiagnosticsParams params = PublishDiagnosticsParams$.MODULE$.apply(TextDocumentIdentifier$.MODULE$.apply(filePath$1.toUri()), $this.buildTarget, (Option)None$.MODULE$, (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Diagnostic[]{diagnostic})), false);
        StandardMain$.MODULE$.exchange().notifyEvent("build/publishDiagnostics", params, JsonProtocol$.MODULE$.PublishDiagnosticsParamsFormat());
    }

    public static final /* synthetic */ void $anonfun$doReport$1(BuildServerEvalReporter $this, Position pos$1, Reporter.Severity severity$1, String msg$1, Path filePath) {
        $this.convertToRange(pos$1).foreach((Function1 & Serializable & scala.Serializable)range -> {
            BuildServerEvalReporter.$anonfun$doReport$2($this, severity$1, msg$1, filePath, range);
            return BoxedUnit.UNIT;
        });
    }

    public BuildServerEvalReporter(BuildTargetIdentifier buildTarget, FilteringReporter delegate) {
        this.buildTarget = buildTarget;
        super(delegate);
        this.problemsByFile = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

