/*
 * Decompiled with CFR 0.152.
 */
package sbt.nio;

import java.io.IOException;
import java.nio.file.Path;
import sbt.internal.inc.EmptyStamp$;
import sbt.internal.inc.Hash;
import sbt.internal.inc.LastModified;
import sbt.internal.inc.Stamp$;
import sbt.internal.inc.Stamper$;
import sbt.io.IO$;
import sbt.nio.FileStamp;
import sbt.nio.FileStamp$LastModified$;
import sbt.nio.FileStamper;
import sbt.nio.FileStamper$Hash$;
import sbt.nio.FileStamper$LastModified$;
import sbt.nio.file.FileAttributes;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.util.Either;
import xsbti.compile.analysis.Stamp;

public final class FileStamp$ {
    public static FileStamp$ MODULE$;

    static {
        new FileStamp$();
    }

    public FileStamp.Ops Ops(FileStamp fileStamp) {
        return new FileStamp.Ops(fileStamp);
    }

    public Option<FileStamp> apply(Path path, FileStamper fileStamper) {
        FileStamper fileStamper2 = fileStamper;
        if (FileStamper$Hash$.MODULE$.equals(fileStamper2)) {
            return this.hash(path);
        }
        if (FileStamper$LastModified$.MODULE$.equals(fileStamper2)) {
            return this.lastModified(path);
        }
        throw new MatchError((Object)fileStamper2);
    }

    public Option<FileStamp> apply(Stamp stamp) {
        Stamp stamp2 = stamp;
        if (stamp2 instanceof LastModified) {
            LastModified lastModified = (LastModified)stamp2;
            return new Some((Object)new FileStamp.LastModified(lastModified.value()));
        }
        if (stamp2 instanceof Hash) {
            Hash hash = (Hash)stamp2;
            return new Some((Object)this.fromZincStamp((Stamp)hash));
        }
        return None$.MODULE$;
    }

    public Option<FileStamp> apply(Path path, FileAttributes fileAttributes) {
        Object object;
        block5: {
            try {
                if (fileAttributes.isDirectory()) {
                    object = this.lastModified(path);
                    break block5;
                }
                String string = ((Object)path).toString();
                if (string.endsWith(".jar")) {
                    object = this.lastModified(path);
                    break block5;
                }
                if (string.endsWith(".class")) {
                    object = this.lastModified(path);
                    break block5;
                }
                object = this.hash(path);
            }
            catch (IOException e) {
                object = new Option<FileStamp.LastModified>((Object)new FileStamp.Error(e));
            }
        }
        return object;
    }

    public FileStamp.Hash hash(String string) {
        return new FileStamp.FileHashImpl(FileStamp$.liftedTree1$1(string));
    }

    public Option<FileStamp.Hash> hash(Path path) {
        Stamp stamp = (Stamp)Stamper$.MODULE$.forFarmHashP().apply((Object)path);
        if (EmptyStamp$.MODULE$.equals(stamp)) {
            return None$.MODULE$;
        }
        return new Some((Object)new FileStamp.FileHashImpl(stamp));
    }

    public FileStamp.Hash fromZincStamp(Stamp stamp) {
        return new FileStamp.FileHashImpl(stamp);
    }

    public Option<FileStamp.LastModified> lastModified(Path path) {
        long l = IO$.MODULE$.getModifiedTimeOrZero(path.toFile());
        if (0L == l) {
            return None$.MODULE$;
        }
        return new Some((Object)FileStamp$LastModified$.MODULE$.apply(l));
    }

    public Either<FileStamp, FileStamp> sbt$nio$FileStamp$$EitherOps(Either<FileStamp, FileStamp> e) {
        return e;
    }

    private static final /* synthetic */ Stamp liftedTree1$1(String string$1) {
        Stamp stamp;
        try {
            stamp = Stamp$.MODULE$.fromString(string$1);
        }
        catch (Throwable throwable) {
            stamp = EmptyStamp$.MODULE$;
        }
        return stamp;
    }

    private FileStamp$() {
        MODULE$ = this;
    }
}

