/*
 * Decompiled with CFR 0.152.
 */
package scalax.io;

import java.io.BufferedReader;
import java.io.Reader;
import java.text.ParseException;
import scala.BufferedIterator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Iterator;
import scala.List;
import scala.Option;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalax.io.Implicits$;

public class CsvIterator
implements Iterator,
ScalaObject {
    private int lineNo;
    private String nextLine;
    private final BufferedReader br;

    public CsvIterator(Reader csv) {
        Iterator.class.$init$((Iterator)this);
        this.br = Implicits$.MODULE$.readerExtras(csv).ensureBuffered();
        this.nextLine = "";
        this.lineNo = 0;
        this.getNext();
    }

    public String[] next() {
        ArrayBuffer fields = new ArrayBuffer();
        char[] chars = this.nextLine().toCharArray();
        int len = chars.length;
        int i = -1;
        block0: while (i < len) {
            boolean dropComment = i == -1 || chars[i] != this.sep();
            ++i;
            while (i < len && Character.isWhitespace(chars[i])) {
                ++i;
            }
            if (i < len && chars[i] == '\"') {
                StringBuilder field = new StringBuilder();
                ++i;
                boolean done = false;
                while (true) {
                    if (done) {
                        ++i;
                        while (!(i >= len || chars[i] == this.sep() || this.comments() && chars[i] == this.commentStart())) {
                            if (Character.isWhitespace(chars[i])) {
                                ++i;
                                continue;
                            }
                            throw new ParseException(new StringBuilder().append(this.lineNo()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)(i + 1))).append((Object)": Garbage after close quote").toString(), this.lineNo());
                        }
                        if (i < len && this.comments() && chars[i] == this.commentStart()) {
                            --i;
                        }
                        fields.$plus$eq((Object)field.toString());
                        continue block0;
                    }
                    int start = i;
                    while (i < len && chars[i] != '\"') {
                        ++i;
                    }
                    field.append(chars, start, i - start);
                    if (i == len) {
                        field.append('\n');
                        this.nextLine_$eq(this.br().readLine());
                        String string2 = this.nextLine();
                        if (string2 == null || string2.equals(null)) {
                            this.br().close();
                            throw new ParseException(new StringBuilder().append(this.lineNo()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)(i + 1))).append((Object)": Mismatched quotes").toString(), this.lineNo());
                        }
                        chars = this.nextLine().toCharArray();
                        len = chars.length;
                        this.lineNo_$eq(this.lineNo() + 1);
                        i = 0;
                        continue;
                    }
                    if (i + 1 < len && chars[i + 1] == '\"') {
                        field.append('\"');
                        i += 2;
                        continue;
                    }
                    done = true;
                }
            }
            if (this.comments() && i < len && chars[i] == this.commentStart()) {
                if (!dropComment) {
                    fields.$plus$eq((Object)"");
                }
                i = len;
                continue;
            }
            int start = i;
            while (!(i >= len || chars[i] == this.sep() || this.comments() && chars[i] == this.commentStart())) {
                ++i;
            }
            int end = i - 1;
            if (i < len && this.comments() && chars[i] == this.commentStart()) {
                --i;
            }
            while (end >= start && Character.isWhitespace(chars[end])) {
                --end;
            }
            fields.$plus$eq((Object)new String(chars, start, end - start + 1));
        }
        if (this.arity() != 0 && fields.length() != this.arity()) {
            throw new ParseException(new StringBuilder().append(this.lineNo()).append((Object)":1: Found ").append((Object)BoxesRunTime.boxToInteger((int)fields.length())).append((Object)" fields but was expecting ").append((Object)BoxesRunTime.boxToInteger((int)this.arity())).toString(), this.lineNo());
        }
        this.getNext();
        Object object = ScalaRunTime$.MODULE$.arrayValue(fields.toArray(), String.class);
        return (String[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, String.class) : object);
    }

    public boolean hasNext() {
        String string2 = this.nextLine();
        return string2 != null && !string2.equals(null);
    }

    private void getNext() {
        int len;
        int i;
        do {
            this.nextLine_$eq(this.br().readLine());
            this.lineNo_$eq(this.lineNo() + 1);
            String string2 = this.nextLine();
            if (string2 == null || string2.equals(null)) {
                this.br().close();
                break;
            }
            if (!this.comments()) break;
            len = this.nextLine().length();
            for (i = 0; i < len && Character.isWhitespace(this.nextLine().charAt(i)); ++i) {
            }
        } while (i == len || this.nextLine().charAt(i) == this.commentStart());
    }

    private void lineNo_$eq(int x$1) {
        this.lineNo = x$1;
    }

    private int lineNo() {
        return this.lineNo;
    }

    private void nextLine_$eq(String x$1) {
        this.nextLine = x$1;
    }

    private String nextLine() {
        return this.nextLine;
    }

    private BufferedReader br() {
        return this.br;
    }

    public char commentStart() {
        return '#';
    }

    public boolean comments() {
        return false;
    }

    public int arity() {
        return 0;
    }

    public char sep() {
        return ',';
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    public String toString() {
        return Iterator.class.toString((Iterator)this);
    }

    public StringBuilder addString(StringBuilder x$1, String x$2, String x$3, String x$4) {
        return Iterator.class.addString((Iterator)this, (StringBuilder)x$1, (String)x$2, (String)x$3, (String)x$4);
    }

    public String mkString(String x$1) {
        return Iterator.class.mkString((Iterator)this, (String)x$1);
    }

    public String mkString(String x$1, String x$2, String x$3) {
        return Iterator.class.mkString((Iterator)this, (String)x$1, (String)x$2, (String)x$3);
    }

    public List toList() {
        return Iterator.class.toList((Iterator)this);
    }

    public void copyToBuffer(Buffer x$1) {
        Iterator.class.copyToBuffer((Iterator)this, (Buffer)x$1);
    }

    public void readInto(BoxedArray x$1) {
        Iterator.class.readInto((Iterator)this, (BoxedArray)x$1);
    }

    public void readInto(BoxedArray x$1, int x$2) {
        Iterator.class.readInto((Iterator)this, (BoxedArray)x$1, (int)x$2);
    }

    public void readInto(BoxedArray x$1, int x$2, int x$3) {
        Iterator.class.readInto((Iterator)this, (BoxedArray)x$1, (int)x$2, (int)x$3);
    }

    public void copyToArray(BoxedArray x$1, int x$2) {
        Iterator.class.copyToArray((Iterator)this, (BoxedArray)x$1, (int)x$2);
    }

    public Tuple2 duplicate() {
        return Iterator.class.duplicate((Iterator)this);
    }

    public Object counted() {
        return Iterator.class.counted((Iterator)this);
    }

    public BufferedIterator buffered() {
        return Iterator.class.buffered((Iterator)this);
    }

    public Object reduceRight(Function2 x$1) {
        return Iterator.class.reduceRight((Iterator)this, (Function2)x$1);
    }

    public Object reduceLeft(Function2 x$1) {
        return Iterator.class.reduceLeft((Iterator)this, (Function2)x$1);
    }

    public Object $colon$bslash(Object x$1, Function2 x$2) {
        return Iterator.class.$colon$bslash((Iterator)this, (Object)x$1, (Function2)x$2);
    }

    public Object $div$colon(Object x$1, Function2 x$2) {
        return Iterator.class.$div$colon((Iterator)this, (Object)x$1, (Function2)x$2);
    }

    public Object foldRight(Object x$1, Function2 x$2) {
        return Iterator.class.foldRight((Iterator)this, (Object)x$1, (Function2)x$2);
    }

    public Object foldLeft(Object x$1, Function2 x$2) {
        return Iterator.class.foldLeft((Iterator)this, (Object)x$1, (Function2)x$2);
    }

    public Option find(Function1 x$1) {
        return Iterator.class.find((Iterator)this, (Function1)x$1);
    }

    public boolean contains(Object x$1) {
        return Iterator.class.contains((Iterator)this, (Object)x$1);
    }

    public boolean exists(Function1 x$1) {
        return Iterator.class.exists((Iterator)this, (Function1)x$1);
    }

    public boolean forall(Function1 x$1) {
        return Iterator.class.forall((Iterator)this, (Function1)x$1);
    }

    public void foreach(Function1 x$1) {
        Iterator.class.foreach((Iterator)this, (Function1)x$1);
    }

    public Object zipWithIndex() {
        return Iterator.class.zipWithIndex((Iterator)this);
    }

    public Object zip(Iterator x$1) {
        return Iterator.class.zip((Iterator)this, (Iterator)x$1);
    }

    public Iterator dropWhile(Function1 x$1) {
        return Iterator.class.dropWhile((Iterator)this, (Function1)x$1);
    }

    public Iterator takeWhile(Function1 x$1) {
        return Iterator.class.takeWhile((Iterator)this, (Function1)x$1);
    }

    public Iterator filter(Function1 x$1) {
        return Iterator.class.filter((Iterator)this, (Function1)x$1);
    }

    public Iterator flatMap(Function1 x$1) {
        return Iterator.class.flatMap((Iterator)this, (Function1)x$1);
    }

    public Object $plus$plus(Function0 x$1) {
        return Iterator.class.$plus$plus((Iterator)this, (Function0)x$1);
    }

    public Object append(Iterator x$1) {
        return Iterator.class.append((Iterator)this, (Iterator)x$1);
    }

    public Iterator map(Function1 x$1) {
        return Iterator.class.map((Iterator)this, (Function1)x$1);
    }

    public Iterator slice(int x$1, int x$2) {
        return Iterator.class.slice((Iterator)this, (int)x$1, (int)x$2);
    }

    public Iterator drop(int x$1) {
        return Iterator.class.drop((Iterator)this, (int)x$1);
    }

    public Object take(int x$1) {
        return Iterator.class.take((Iterator)this, (int)x$1);
    }
}

