/*
 * Decompiled with CFR 0.152.
 */
package scalax.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.StringBuilder;
import scala.runtime.BoxedObjectArray;
import scalax.io.FileExtras;
import scalax.io.FileHelp$;
import scalax.io.StreamHelp$;

public final class FileHelp$
implements ScalaObject {
    public static final FileHelp$ MODULE$;
    private final String lineSeparator;
    private final Pattern extensionPattern;

    static {
        new FileHelp$();
    }

    public FileHelp$() {
        MODULE$ = this;
        this.extensionPattern = Pattern.compile(".*\\.([A-Za-z0-9_+-]+)$");
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    public String lineSeparator() {
        return this.lineSeparator;
    }

    public File tmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public void move(File src, File dest) {
        block3: {
            block2: {
                dest.delete();
                if (src.renameTo(dest)) break block2;
                this.copy(src, dest);
                if (!src.delete()) break block3;
            }
            return;
        }
        throw new IOException(new StringBuilder().append((Object)"Delete after copy failed: ").append((Object)src).toString());
    }

    public void copy(File src, File dest$1) {
        new FileExtras(src).inChannel().foreach(new anonfun.copy.1(dest$1));
    }

    public Option extension(File file2) {
        String n = file2.getName();
        Matcher m = this.extensionPattern().matcher(n);
        return m.matches() ? new Some((Object)m.group(1)) : None$.MODULE$;
    }

    private Pattern extensionPattern() {
        return this.extensionPattern;
    }

    public void unzip(File zipfile, File outdir) {
        StreamHelp$.MODULE$.unzip(new FileInputStream(zipfile), outdir);
    }

    public boolean deleteRecursively(File file2) {
        if (file2.isDirectory()) {
            new BoxedObjectArray((Object[])file2.listFiles()).foreach((Function1)new anonfun.deleteRecursively.1());
        }
        return file2.delete();
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

