/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.dynamic;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import coursierapi.MavenRepository;
import coursierapi.Repository;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.scalafmt.dynamic.BuildInfo$;
import org.scalafmt.dynamic.ConsoleScalafmtReporter$;
import org.scalafmt.dynamic.ScalafmtDynamic$;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader$;
import org.scalafmt.dynamic.ScalafmtDynamicError;
import org.scalafmt.dynamic.ScalafmtReflect;
import org.scalafmt.dynamic.ScalafmtReflectConfig;
import org.scalafmt.dynamic.ScalafmtVersion;
import org.scalafmt.dynamic.exceptions.ReflectionException$;
import org.scalafmt.dynamic.exceptions.ScalafmtConfigException;
import org.scalafmt.dynamic.utils.ReentrantCache;
import org.scalafmt.dynamic.utils.ReentrantCache$;
import org.scalafmt.interfaces.Scalafmt;
import org.scalafmt.interfaces.ScalafmtReporter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005c\u0001\u0002 @\u0005\u001aC\u0001B\u0018\u0001\u0003\u0016\u0004%\ta\u0018\u0005\tG\u0002\u0011\t\u0012)A\u0005A\"AA\r\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005y\u0001\tE\t\u0015!\u0003g\u0011!I\bA!f\u0001\n\u0003Q\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011B>\t\u0011}\u0004!Q3A\u0005\u0002iD\u0011\"!\u0001\u0001\u0005#\u0005\u000b\u0011B>\t\u0015\u0005\r\u0001A!f\u0001\n\u0003\t)\u0001\u0003\u0006\u0002\u0018\u0001\u0011\t\u0012)A\u0005\u0003\u000fA!\"!\u0007\u0001\u0005+\u0007I\u0011AA\u000e\u0011)\ty\u000e\u0001B\tB\u0003%\u0011Q\u0004\u0005\n\u0003+\u0003!Q3A\u0005\u0002iD\u0011\"!9\u0001\u0005#\u0005\u000b\u0011B>\t\u0015\u0005e\u0005A!f\u0001\n\u0003\t\u0019\u000f\u0003\u0006\u0002j\u0002\u0011\t\u0012)A\u0005\u0003KDq!a\u0012\u0001\t\u0003\tY\u000fC\u0004\u0002H\u0001!\t!!@\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!\u0011\u0002\u0001\u0005B\t-\u0001b\u0002B\b\u0001\u0011\u0005#\u0011\u0003\u0005\b\u0005+\u0001A\u0011\tB\f\u0011\u001d\u0011Y\u0002\u0001C!\u0005;AqA!\t\u0001\t\u0003\u0011\u0019\u0003C\u0004\u0003(\u0001!\tE!\u000b\t\u000f\tU\u0002\u0001\"\u0003\u00038!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B'\u0001\u0011%!q\n\u0005\b\u0005+\u0002A\u0011\u0002B,\u0011\u001d\u0011i\u0006\u0001C\u0005\u0005?BqAa\u001a\u0001\t\u0013\u0011I\u0007C\u0004\u0003r\u0001!IAa\u001d\t\u000f\t%\u0005\u0001\"\u0003\u0003\f\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BQ\u0001\u0011%!1\u0015\u0005\b\u0005S\u0003A\u0011\tBV\u0011%\u0011)\fAA\u0001\n\u0003\u00119\fC\u0005\u0003J\u0002\t\n\u0011\"\u0001\u0003L\"I!\u0011\u001d\u0001\u0012\u0002\u0013\u0005!1\u001d\u0005\n\u0005O\u0004\u0011\u0013!C\u0001\u0005SD\u0011B!<\u0001#\u0003%\tA!;\t\u0013\t=\b!%A\u0005\u0002\tE\b\"\u0003B{\u0001E\u0005I\u0011\u0001B|\u0011%\u0011Y\u0010AI\u0001\n\u0003\u0011I\u000fC\u0005\u0003~\u0002\t\n\u0011\"\u0001\u0003\u0000\"I11\u0001\u0001\u0002\u0002\u0013\u00053Q\u0001\u0005\n\u0007\u0017\u0001\u0011\u0011!C\u0001\u0007\u001bA\u0011b!\u0006\u0001\u0003\u0003%\taa\u0006\t\u0013\ru\u0001!!A\u0005B\r}\u0001\"CB\u0017\u0001\u0005\u0005I\u0011AB\u0018\u0011%\u0019\u0019\u0004AA\u0001\n\u0003\u001a)\u0004C\u0005\u00048\u0001\t\t\u0011\"\u0011\u0004:!I11\b\u0001\u0002\u0002\u0013\u00053QH\u0004\b\u0003sy\u0004\u0012AA\u001e\r\u0019qt\b#\u0001\u0002@!9\u0011qI\u001c\u0005\u0002\u0005%SABA&o\u0001\ti%\u0002\u0004\u0002Z]\"\u00111\f\u0005\n\u0003k:\u0014\u0011!CA\u0003oB\u0011\"a28\u0003\u0003%\t)!3\t\u0013\u0005mw'!A\u0005\n\u0005u'aD*dC2\fg-\u001c;Es:\fW.[2\u000b\u0005\u0001\u000b\u0015a\u00023z]\u0006l\u0017n\u0019\u0006\u0003\u0005\u000e\u000b\u0001b]2bY\u00064W\u000e\u001e\u0006\u0002\t\u0006\u0019qN]4\u0004\u0001M)\u0001aR(V7B\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0005Y\u0006twMC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%AB(cU\u0016\u001cG\u000f\u0005\u0002Q'6\t\u0011K\u0003\u0002S\u0003\u0006Q\u0011N\u001c;fe\u001a\f7-Z:\n\u0005Q\u000b&\u0001C*dC2\fg-\u001c;\u0011\u0005YKV\"A,\u000b\u0003a\u000bQa]2bY\u0006L!AW,\u0003\u000fA\u0013x\u000eZ;diB\u0011a\u000bX\u0005\u0003;^\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f\u0001B]3q_J$XM]\u000b\u0002AB\u0011\u0001+Y\u0005\u0003EF\u0013\u0001cU2bY\u00064W\u000e\u001e*fa>\u0014H/\u001a:\u0002\u0013I,\u0007o\u001c:uKJ\u0004\u0013\u0001\u0004:fa>\u001c\u0018\u000e^8sS\u0016\u001cX#\u00014\u0011\u0007\u001d|'O\u0004\u0002i[:\u0011\u0011\u000e\\\u0007\u0002U*\u00111.R\u0001\u0007yI|w\u000e\u001e \n\u0003aK!A\\,\u0002\u000fA\f7m[1hK&\u0011\u0001/\u001d\u0002\u0005\u0019&\u001cHO\u0003\u0002o/B\u00111O^\u0007\u0002i*\tQ/A\u0006d_V\u00148/[3sCBL\u0017BA<u\u0005)\u0011V\r]8tSR|'/_\u0001\u000ee\u0016\u0004xn]5u_JLWm\u001d\u0011\u0002\u001dI,7\u000f]3diZ+'o]5p]V\t1\u0010\u0005\u0002Wy&\u0011Qp\u0016\u0002\b\u0005>|G.Z1o\u0003=\u0011Xm\u001d9fGR4VM]:j_:\u0004\u0013!\u0006:fgB,7\r^#yG2,H-\u001a$jYR,'o]\u0001\u0017e\u0016\u001c\b/Z2u\u000bb\u001cG.\u001e3f\r&dG/\u001a:tA\u0005qA-\u001a4bk2$h+\u001a:tS>tWCAA\u0004!\u0011\tI!!\u0005\u000f\t\u0005-\u0011Q\u0002\t\u0003S^K1!a\u0004X\u0003\u0019\u0001&/\u001a3fM&!\u00111CA\u000b\u0005\u0019\u0019FO]5oO*\u0019\u0011qB,\u0002\u001f\u0011,g-Y;miZ+'o]5p]\u0002\n1BZ8s[\u0006$8)Y2iKV\u0011\u0011Q\u0004\t\t\u0003?\t)#a\u0002\u0002*5\u0011\u0011\u0011\u0005\u0006\u0004\u0003Gy\u0014!B;uS2\u001c\u0018\u0002BA\u0014\u0003C\u0011aBU3f]R\u0014\u0018M\u001c;DC\u000eDW\rE\u0003\u0002,i\niID\u0002\u0002.YrA!a\f\u000289!\u0011\u0011GA\u001b\u001d\rI\u00171G\u0005\u0002\t&\u0011!iQ\u0005\u0003\u0001\u0006\u000bqbU2bY\u00064W\u000e\u001e#z]\u0006l\u0017n\u0019\t\u0004\u0003{9T\"A \u0014\t]\n\te\u0017\t\u0004-\u0006\r\u0013bAA#/\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtDCAA\u001e\u000511uN]7biJ+7/\u001e7u!\u001d9\u0017qJA*\u0003\u000fI1!!\u0015r\u0005\u0019)\u0015\u000e\u001e5feB!\u0011QHA+\u0013\r\t9f\u0010\u0002\u0015'\u000e\fG.\u00194ni\u0012Kh.Y7jG\u0016\u0013(o\u001c:\u0003\u0015\u0019{'/\\1u\u000bZ\fG.\u0006\u0003\u0002^\u0005\r\u0004cB4\u0002P\u0005M\u0013q\f\t\u0005\u0003C\n\u0019\u0007\u0004\u0001\u0005\u000f\u0005\u0015$H1\u0001\u0002h\t\tA+\u0005\u0003\u0002j\u0005=\u0004c\u0001,\u0002l%\u0019\u0011QN,\u0003\u000f9{G\u000f[5oOB\u0019a+!\u001d\n\u0007\u0005MtKA\u0002B]f\fQ!\u00199qYf$\"#!\u001f\u0002|\u0005u\u0014qPAA\u0003\u0007\u000b))a%\u0002\u0018B\u0019\u0011Q\b\u0001\t\u000by[\u0004\u0019\u00011\t\u000b\u0011\\\u0004\u0019\u00014\t\u000be\\\u0004\u0019A>\t\u000b}\\\u0004\u0019A>\t\u000f\u0005\r1\b1\u0001\u0002\b!9\u0011\u0011D\u001eA\u0002\u0005\u001d\u0005\u0003CA\u0010\u0003K\t9!!#\u0011\u000b\u0005-%(!$\u000e\u0003]\u0002B!!\u0010\u0002\u0010&\u0019\u0011\u0011S \u0003\u001fM\u001b\u0017\r\\1g[R\u0014VM\u001a7fGRDa!!&<\u0001\u0004Y\u0018\u0001D2bG\",7i\u001c8gS\u001e\u001c\bbBAMw\u0001\u0007\u00111T\u0001\rG>tg-[4t\u0007\u0006\u001c\u0007.\u001a\t\t\u0003?\t)#!(\u0002.B!\u0011qTAU\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016\u0001\u00024jY\u0016T1!a*L\u0003\rq\u0017n\\\u0005\u0005\u0003W\u000b\tK\u0001\u0003QCRD\u0007#BAFu\u0005=\u0006c\u0002,\u00022\u0006U\u00161X\u0005\u0004\u0003g;&A\u0002+va2,'\u0007\u0005\u0003\u0002>\u0005]\u0016bAA]\u007f\t)2kY1mC\u001alGOU3gY\u0016\u001cGoQ8oM&<\u0007\u0003BA_\u0003\u0007l!!a0\u000b\t\u0005\u0005\u0017\u0011U\u0001\nCR$(/\u001b2vi\u0016LA!!2\u0002@\nAa)\u001b7f)&lW-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005-\u0017q\u001b\t\u0006-\u00065\u0017\u0011[\u0005\u0004\u0003\u001f<&AB(qi&|g\u000e\u0005\bW\u0003'\u0004gm_>\u0002\b\u0005\u001d50a'\n\u0007\u0005UwK\u0001\u0004UkBdW\r\u000f\u0005\n\u00033d\u0014\u0011!a\u0001\u0003s\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003\u001d\u000bABZ8s[\u0006$8)Y2iK\u0002\nQbY1dQ\u0016\u001cuN\u001c4jON\u0004SCAAs!!\ty\"!\n\u0002\u001e\u0006\u001d\b#BA\u0016u\u0005=\u0016!D2p]\u001aLwm]\"bG\",\u0007\u0005\u0006\n\u0002z\u00055\u0018q^Ay\u0003g\f)0a>\u0002z\u0006m\b\"\u00020\u0012\u0001\u0004\u0001\u0007\"\u00023\u0012\u0001\u00041\u0007\"B=\u0012\u0001\u0004Y\b\"B@\u0012\u0001\u0004Y\bbBA\u0002#\u0001\u0007\u0011q\u0001\u0005\b\u00033\t\u0002\u0019AA\u000f\u0011\u0019\t)*\u0005a\u0001w\"9\u0011\u0011T\tA\u0002\u0005\u0015HCAA=\u0003\u0015\u0019G.Z1s)\t\u0011\u0019\u0001E\u0002W\u0005\u000bI1Aa\u0002X\u0005\u0011)f.\u001b;\u0002\u0019]LG\u000f\u001b*fa>\u0014H/\u001a:\u0015\t\u0005e$Q\u0002\u0005\u0006=R\u0001\r\u0001Y\u0001\u001ao&$\bNU3ta\u0016\u001cG\u000f\u0015:pU\u0016\u001cGOR5mi\u0016\u00148\u000f\u0006\u0003\u0002z\tM\u0001\"B@\u0016\u0001\u0004Y\u0018AE<ji\"\u0014Vm\u001d9fGR4VM]:j_:$B!!\u001f\u0003\u001a!)\u0011P\u0006a\u0001w\u0006\u0011r/\u001b;i\t\u00164\u0017-\u001e7u-\u0016\u00148/[8o)\u0011\tIHa\b\t\u000f\u0005\rq\u00031\u0001\u0002\b\u0005\tr/\u001b;i\u0007>tg-[4DC\u000eD\u0017N\\4\u0015\t\u0005e$Q\u0005\u0005\u0007\u0003+C\u0002\u0019A>\u0002\r\u0019|'/\\1u)!\t9Aa\u000b\u00030\tE\u0002b\u0002B\u00173\u0001\u0007\u0011QT\u0001\u0007G>tg-[4\t\u000f\u0005\r\u0016\u00041\u0001\u0002\u001e\"9!1G\rA\u0002\u0005\u001d\u0011\u0001B2pI\u0016\f1B]3q_J$XI\u001d:peR1!1\u0001B\u001d\u0005wAq!a)\u001b\u0001\u0004\ti\nC\u0004\u0003>i\u0001\r!a\u0015\u0002\u000b\u0015\u0014(o\u001c:\u0002\u001d\u0019|'/\\1u\t\u0016$\u0018-\u001b7fIRA!1\tB#\u0005\u0013\u0012Y\u0005E\u0002\u0002,eBqAa\u0012\u001c\u0001\u0004\ti*\u0001\u0006d_:4\u0017n\u001a)bi\"Dq!a)\u001c\u0001\u0004\ti\nC\u0004\u00034m\u0001\r!a\u0002\u0002\u001bI,7o\u001c7wK\u000e{gNZ5h)\u0011\u0011\tFa\u0015\u0011\u000f\u001d\fy%a\u0015\u00026\"9!q\t\u000fA\u0002\u0005u\u0015!\u0007:fg>dg/Z\"p]\u001aLwmV5uQN\u001b\u0017\r\\1g[R$BA!\u0017\u0003\\A)\u00111\u0006\u001e\u00026\"9!qI\u000fA\u0002\u0005u\u0015a\u00039beN,7i\u001c8gS\u001e$bA!\u0017\u0003b\t\r\u0004b\u0002B$=\u0001\u0007\u0011Q\u0014\u0005\b\u0005Kr\u0002\u0019AAG\u0003)1W\u000e\u001e*fM2,7\r^\u0001\u0011e\u0016\u001cx\u000e\u001c<f\r>\u0014X.\u0019;uKJ$b!!\u000b\u0003l\t5\u0004b\u0002B$?\u0001\u0007\u0011Q\u0014\u0005\b\u0005_z\u0002\u0019AA\u0004\u0003\u001d1XM]:j_:\f\u0001C]3t_24Xm\u00117bgN\u0004\u0016\r\u001e5\u0015\r\u0005%\"Q\u000fB<\u0011\u001d\u00119\u0005\ta\u0001\u0003;CqA!\u001f!\u0001\u0004\u0011Y(A\be_^tGn\\1e'V\u001c7-Z:t!\u0011\u0011iHa!\u000f\t\u00055\"qP\u0005\u0004\u0005\u0003{\u0014!G*dC2\fg-\u001c;Es:\fW.[2E_^tGn\\1eKJLAA!\"\u0003\b\nyAi\\<oY>\fGmU;dG\u0016\u001c8OC\u0002\u0003\u0002~\n\u0011\u0002\u001e:z\r>\u0014X.\u0019;\u0015\u0015\t\r#Q\u0012BH\u0005#\u0013)\nC\u0004\u0002$\u0006\u0002\r!!(\t\u000f\tM\u0012\u00051\u0001\u0002\b!9!1S\u0011A\u0002\u00055\u0015a\u0002:fM2,7\r\u001e\u0005\b\u0005[\t\u0003\u0019AA[\u00035I7/S4o_J,GMR5mKR)1Pa'\u0003 \"9!Q\u0014\u0012A\u0002\u0005\u001d\u0011\u0001\u00034jY\u0016t\u0017-\\3\t\u000f\t5\"\u00051\u0001\u00026\u0006Y!/Z1e-\u0016\u00148/[8o)\u0011\u0011)Ka*\u0011\u000bY\u000bi-a\u0002\t\u000f\t52\u00051\u0001\u0002\u001e\u0006)r/\u001b;i\u001b\u00064XM\u001c*fa>\u001c\u0018\u000e^8sS\u0016\u001cHcA(\u0003.\"1A\r\na\u0001\u0005_\u0003RA\u0016BY\u0003\u000fI1Aa-X\u0005)a$/\u001a9fCR,GMP\u0001\u0005G>\u0004\u0018\u0010\u0006\n\u0002z\te&1\u0018B_\u0005\u007f\u0013\tMa1\u0003F\n\u001d\u0007b\u00020&!\u0003\u0005\r\u0001\u0019\u0005\bI\u0016\u0002\n\u00111\u0001g\u0011\u001dIX\u0005%AA\u0002mDqa`\u0013\u0011\u0002\u0003\u00071\u0010C\u0005\u0002\u0004\u0015\u0002\n\u00111\u0001\u0002\b!I\u0011\u0011D\u0013\u0011\u0002\u0003\u0007\u0011Q\u0004\u0005\t\u0003++\u0003\u0013!a\u0001w\"I\u0011\u0011T\u0013\u0011\u0002\u0003\u0007\u0011Q]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iMK\u0002a\u0005\u001f\\#A!5\u0011\t\tM'Q\\\u0007\u0003\u0005+TAAa6\u0003Z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057<\u0016AC1o]>$\u0018\r^5p]&!!q\u001cBk\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)OK\u0002g\u0005\u001f\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003l*\u001a1Pa4\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001BzU\u0011\t9Aa4\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011 \u0016\u0005\u0003;\u0011y-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u00111\u0011\u0001\u0016\u0005\u0003K\u0014y-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007\u000f\u00012\u0001SB\u0005\u0013\r\t\u0019\"S\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0007\u001f\u00012AVB\t\u0013\r\u0019\u0019b\u0016\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003_\u001aI\u0002C\u0005\u0004\u001cA\n\t\u00111\u0001\u0004\u0010\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\t\u0011\r\r\r2\u0011FA8\u001b\t\u0019)CC\u0002\u0004(]\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019Yc!\n\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004w\u000eE\u0002\"CB\u000ee\u0005\u0005\t\u0019AA8\u0003!A\u0017m\u001d5D_\u0012,GCAB\b\u0003!!xn\u0015;sS:<GCAB\u0004\u0003\u0019)\u0017/^1mgR\u00191pa\u0010\t\u0013\rmQ'!AA\u0002\u0005=\u0004")
public final class ScalafmtDynamic
implements Scalafmt,
Product,
scala.Serializable {
    private final ScalafmtReporter reporter;
    private final List<Repository> repositories;
    private final boolean respectVersion;
    private final boolean respectExcludeFilters;
    private final String defaultVersion;
    private final ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache;
    private final boolean cacheConfigs;
    private final ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache;

    public static Option<Tuple8<ScalafmtReporter, List<Repository>, Object, Object, String, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>>, Object, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>>> unapply(ScalafmtDynamic scalafmtDynamic) {
        return ScalafmtDynamic$.MODULE$.unapply(scalafmtDynamic);
    }

    public static ScalafmtDynamic apply(ScalafmtReporter scalafmtReporter, List<Repository> list, boolean bl, boolean bl2, String string, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache, boolean bl3, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache2) {
        return ScalafmtDynamic$.MODULE$.apply(scalafmtReporter, list, bl, bl2, string, reentrantCache, bl3, reentrantCache2);
    }

    public ScalafmtReporter reporter() {
        return this.reporter;
    }

    public List<Repository> repositories() {
        return this.repositories;
    }

    public boolean respectVersion() {
        return this.respectVersion;
    }

    public boolean respectExcludeFilters() {
        return this.respectExcludeFilters;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache() {
        return this.formatCache;
    }

    public boolean cacheConfigs() {
        return this.cacheConfigs;
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache() {
        return this.configsCache;
    }

    public void clear() {
        this.formatCache().clear().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ScalafmtDynamic.$anonfun$clear$2(x$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ExecutionContext$.MODULE$.global());
            return BoxedUnit.UNIT;
        });
    }

    public ScalafmtDynamic withReporter(ScalafmtReporter reporter) {
        return this.copy(reporter, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public ScalafmtDynamic withRespectProjectFilters(boolean respectExcludeFilters) {
        boolean x$1 = respectExcludeFilters;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withRespectVersion(boolean respectVersion) {
        boolean x$1 = respectVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withDefaultVersion(String defaultVersion) {
        String x$1 = defaultVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withConfigCaching(boolean cacheConfigs) {
        boolean x$1 = cacheConfigs;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        String x$6 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$7 = this.copy$default$6();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    public String format(Path config, Path file, String code) {
        String string;
        Either<ScalafmtDynamicError, String> either = this.formatDetailed(config, file, code);
        if (either instanceof Right) {
            String codeFormatted;
            Right right = (Right)either;
            string = codeFormatted = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ScalafmtDynamicError error = (ScalafmtDynamicError)left.value();
            this.reportError(file, error);
            string = code;
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    private void reportError(Path file, ScalafmtDynamicError error) {
        ScalafmtDynamicError scalafmtDynamicError = error;
        if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigParseError) {
            ScalafmtDynamicError.ConfigParseError configParseError = (ScalafmtDynamicError.ConfigParseError)scalafmtDynamicError;
            Path configPath = configParseError.configPath();
            ScalafmtConfigException cause = configParseError.cause();
            this.reporter().error(configPath, cause.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigDoesNotExist) {
            ScalafmtDynamicError.ConfigDoesNotExist configDoesNotExist = (ScalafmtDynamicError.ConfigDoesNotExist)scalafmtDynamicError;
            Path configPath = configDoesNotExist.configPath();
            this.reporter().error(configPath, "file does not exist");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigMissingVersion) {
            ScalafmtDynamicError.ConfigMissingVersion configMissingVersion = (ScalafmtDynamicError.ConfigMissingVersion)scalafmtDynamicError;
            Path configPath = configMissingVersion.configPath();
            this.reporter().missingVersion(configPath, this.defaultVersion());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.CannotDownload) {
            ScalafmtDynamicError.CannotDownload cannotDownload = (ScalafmtDynamicError.CannotDownload)scalafmtDynamicError;
            Path configPath = cannotDownload.configPath();
            String version = cannotDownload.version();
            Option<Throwable> cause = cannotDownload.cause();
            String message = new StringBuilder(37).append("failed to resolve Scalafmt version '").append(version).append("'").toString();
            Option<Throwable> option = cause;
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable e = (Throwable)some.value();
                this.reporter().error(configPath, message, e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.reporter().error(configPath, message);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.CorruptedClassPath) {
            ScalafmtDynamicError.CorruptedClassPath corruptedClassPath = (ScalafmtDynamicError.CorruptedClassPath)scalafmtDynamicError;
            Path configPath = corruptedClassPath.configPath();
            String version = corruptedClassPath.version();
            Throwable cause = corruptedClassPath.cause();
            String message = new StringBuilder(40).append("scalafmt version ").append(version).append(" classpath is corrupted").toString();
            this.reporter().error(configPath, message, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.UnknownError) {
            ScalafmtDynamicError.UnknownError unknownError = (ScalafmtDynamicError.UnknownError)scalafmtDynamicError;
            Throwable cause = unknownError.cause();
            this.reporter().error(file, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)scalafmtDynamicError);
        }
    }

    public Either<ScalafmtDynamicError, String> formatDetailed(Path configPath, Path file, String code) {
        return this.resolveConfig(configPath).flatMap((Function1 & Serializable & scala.Serializable)config -> this.tryFormat(file, code, config.fmtReflect(), (ScalafmtReflectConfig)config).map((Function1 & Serializable & scala.Serializable)codeFormatted -> codeFormatted));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfig(Path configPath) {
        Left left;
        if (!Files.exists(configPath, new LinkOption[0])) {
            left = package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigDoesNotExist(configPath));
        } else if (this.cacheConfigs()) {
            FileTime currentTimestamp = Files.getLastModifiedTime(configPath, new LinkOption[0]);
            left = this.configsCache().getOrAddToCache(configPath, (Function1<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$1(currentTimestamp, x$4)), (Function0<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>)(Function0 & Serializable & scala.Serializable)() -> this.resolveConfigWithScalafmt(configPath).map((Function1 & Serializable & scala.Serializable)config -> {
                this.reporter().parsedConfig(configPath, config.version());
                return new Tuple2(config, (Object)currentTimestamp);
            })).map((Function1 & Serializable & scala.Serializable)x$7 -> (ScalafmtReflectConfig)x$7._1());
        } else {
            left = this.resolveConfigWithScalafmt(configPath);
        }
        return left;
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfigWithScalafmt(Path configPath) {
        return this.readVersion(configPath).toRight((Function0 & Serializable & scala.Serializable)() -> new ScalafmtDynamicError.ConfigMissingVersion(configPath)).flatMap((Function1 & Serializable & scala.Serializable)version -> this.resolveFormatter(configPath, (String)version).flatMap((Function1 & Serializable & scala.Serializable)fmtReflect -> this.parseConfig(configPath, (ScalafmtReflect)fmtReflect).map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> parseConfig(Path configPath, ScalafmtReflect fmtReflect) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fmtReflect.parseConfig(configPath)).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product;
            Throwable throwable = x0$1;
            if (throwable instanceof ScalafmtConfigException) {
                ScalafmtConfigException scalafmtConfigException = (ScalafmtConfigException)throwable;
                product = new ScalafmtDynamicError.ConfigParseError(configPath, scalafmtConfigException);
            } else {
                product = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return product;
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveFormatter(Path configPath, String version) {
        return this.formatCache().getOrAddToCache(version, this.formatCache().getOrAddToCache$default$2(), (Function0<Either<ScalafmtDynamicError, ScalafmtReflect>>)(Function0 & Serializable & scala.Serializable)() -> {
            OutputStreamWriter writer = this.reporter().downloadOutputStreamWriter();
            ScalafmtDynamicDownloader downloader = new ScalafmtDynamicDownloader(writer, this.repositories(), ScalafmtDynamicDownloader$.MODULE$.$lessinit$greater$default$3());
            return downloader.download(version).left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ScalafmtDynamicError.CannotDownload cannotDownload;
                ScalafmtDynamicDownloader.DownloadFailure downloadFailure = x0$1;
                if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadResolutionError) {
                    ScalafmtDynamicDownloader.DownloadResolutionError downloadResolutionError = (ScalafmtDynamicDownloader.DownloadResolutionError)downloadFailure;
                    String v = downloadResolutionError.version();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)None$.MODULE$);
                } else if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadUnknownError) {
                    ScalafmtDynamicDownloader.DownloadUnknownError downloadUnknownError = (ScalafmtDynamicDownloader.DownloadUnknownError)downloadFailure;
                    String v = downloadUnknownError.version();
                    Throwable cause = downloadUnknownError.cause();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)Option$.MODULE$.apply((Object)cause));
                } else if (downloadFailure instanceof ScalafmtDynamicDownloader.InvalidVersionError) {
                    ScalafmtDynamicDownloader.InvalidVersionError invalidVersionError = (ScalafmtDynamicDownloader.InvalidVersionError)downloadFailure;
                    String v = invalidVersionError.version();
                    ScalafmtVersion.InvalidVersionException cause = invalidVersionError.cause();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)Option$.MODULE$.apply((Object)cause));
                } else {
                    throw new MatchError((Object)downloadFailure);
                }
                return cannotDownload;
            }).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> this.resolveClassPath(configPath, (ScalafmtDynamicDownloader.DownloadSuccess)x$8));
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveClassPath(Path configPath, ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess) {
        ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess2 = downloadSuccess;
        if (downloadSuccess2 == null) {
            throw new MatchError((Object)downloadSuccess2);
        }
        String version = downloadSuccess2.version();
        Seq<URL> urls = downloadSuccess2.jarUrls();
        Tuple2 tuple2 = new Tuple2((Object)version, urls);
        Tuple2 tuple22 = tuple2;
        String version2 = (String)tuple22._1();
        Seq urls2 = (Seq)tuple22._2();
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader classloader = new URLClassLoader((URL[])urls2.toArray(ClassTag$.MODULE$.apply(URL.class)), null);
            return new ScalafmtReflect(classloader, version2, this.respectVersion());
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product;
            Throwable throwable = x0$1;
            if (throwable instanceof ReflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException = (ReflectiveOperationException)throwable;
                product = new ScalafmtDynamicError.CorruptedClassPath(configPath, version2, (Seq<URL>)urls2, reflectiveOperationException);
            } else {
                product = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return product;
        });
    }

    private Either<ScalafmtDynamicError, String> tryFormat(Path file, String code, ScalafmtReflect reflect, ScalafmtReflectConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            ScalafmtReflectConfig configWithDialect;
            String filename = ((Object)file).toString();
            ScalafmtReflectConfig scalafmtReflectConfig = configWithDialect = filename.endsWith(".sbt") || filename.endsWith(".sc") ? config.withSbtDialect() : config;
            if (this.isIgnoredFile(filename, configWithDialect)) {
                this.reporter().excluded(file);
                string = code;
            } else {
                string = reflect.format(code, configWithDialect, (Option<Path>)new Some((Object)file));
            }
            return string;
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScalafmtDynamicError.UnknownError unknownError;
            Throwable throwable = x0$1;
            Option<Throwable> option = ReflectionException$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                unknownError = new ScalafmtDynamicError.UnknownError(e);
            } else {
                unknownError = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return unknownError;
        });
    }

    private boolean isIgnoredFile(String filename, ScalafmtReflectConfig config) {
        return this.respectExcludeFilters() && !config.isIncludedInProject(filename);
    }

    private Option<String> readVersion(Path config) {
        Some some;
        try {
            some = new Some((Object)ConfigFactory.parseFile((File)config.toFile()).getString("version"));
        }
        catch (Throwable throwable) {
            Some some2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ConfigException.Missing && !this.respectVersion()) {
                some2 = new Some((Object)this.defaultVersion());
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    some2 = None$.MODULE$;
                } else {
                    throw throwable;
                }
            }
            some = some2;
        }
        return some;
    }

    public Scalafmt withMavenRepositories(Seq<String> repositories) {
        List x$12 = ((TraversableOnce)repositories.map((Function1 & Serializable & scala.Serializable)x$1 -> MavenRepository.of((String)x$1), Seq$.MODULE$.canBuildFrom())).toList();
        ScalafmtReporter x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, (List<Repository>)x$12, x$3, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic copy(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        return new ScalafmtDynamic(reporter, repositories, respectVersion, respectExcludeFilters, defaultVersion, formatCache, cacheConfigs, configsCache);
    }

    public ScalafmtReporter copy$default$1() {
        return this.reporter();
    }

    public List<Repository> copy$default$2() {
        return this.repositories();
    }

    public boolean copy$default$3() {
        return this.respectVersion();
    }

    public boolean copy$default$4() {
        return this.respectExcludeFilters();
    }

    public String copy$default$5() {
        return this.defaultVersion();
    }

    public ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> copy$default$6() {
        return this.formatCache();
    }

    public boolean copy$default$7() {
        return this.cacheConfigs();
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> copy$default$8() {
        return this.configsCache();
    }

    public String productPrefix() {
        return "ScalafmtDynamic";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.reporter();
                break;
            }
            case 1: {
                object = this.repositories();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectVersion());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectExcludeFilters());
                break;
            }
            case 4: {
                object = this.defaultVersion();
                break;
            }
            case 5: {
                object = this.formatCache();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this.cacheConfigs());
                break;
            }
            case 7: {
                object = this.configsCache();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ScalafmtDynamic;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reporter()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.repositories()));
        n = Statics.mix((int)n, (int)(this.respectVersion() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.respectExcludeFilters() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.defaultVersion()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.formatCache()));
        n = Statics.mix((int)n, (int)(this.cacheConfigs() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.configsCache()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ScalafmtDynamic)) return false;
        boolean bl = true;
        if (!bl) return false;
        ScalafmtDynamic scalafmtDynamic = (ScalafmtDynamic)x$1;
        ScalafmtReporter scalafmtReporter = this.reporter();
        ScalafmtReporter scalafmtReporter2 = scalafmtDynamic.reporter();
        if (scalafmtReporter == null) {
            if (scalafmtReporter2 != null) {
                return false;
            }
        } else if (!scalafmtReporter.equals(scalafmtReporter2)) return false;
        List<Repository> list = this.repositories();
        List<Repository> list2 = scalafmtDynamic.repositories();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (this.respectVersion() != scalafmtDynamic.respectVersion()) return false;
        if (this.respectExcludeFilters() != scalafmtDynamic.respectExcludeFilters()) return false;
        String string = this.defaultVersion();
        String string2 = scalafmtDynamic.defaultVersion();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache = this.formatCache();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache2 = scalafmtDynamic.formatCache();
        if (reentrantCache == null) {
            if (reentrantCache2 != null) {
                return false;
            }
        } else if (!reentrantCache.equals(reentrantCache2)) return false;
        if (this.cacheConfigs() != scalafmtDynamic.cacheConfigs()) return false;
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache3 = this.configsCache();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache4 = scalafmtDynamic.configsCache();
        if (reentrantCache3 == null) {
            if (reentrantCache4 == null) return true;
            return false;
        } else {
            if (!reentrantCache3.equals(reentrantCache4)) return false;
            return true;
        }
    }

    public Scalafmt withMavenRepositories(String[] repositories) {
        return this.withMavenRepositories((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])repositories));
    }

    public static final /* synthetic */ void $anonfun$clear$3(ScalafmtReflect x$3) {
        x$3.classLoader().close();
    }

    public static final /* synthetic */ void $anonfun$clear$2(Either x$2) {
        x$2.right().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ScalafmtDynamic.$anonfun$clear$3(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$2(ScalafmtDynamicError x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$3(FileTime currentTimestamp$1, Tuple2 x$6) {
        return ((FileTime)x$6._2()).compareTo(currentTimestamp$1) != 0;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$1(FileTime currentTimestamp$1, Either x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4.fold((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$2(x$5)), (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$3(currentTimestamp$1, x$6))));
    }

    public ScalafmtDynamic(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        this.reporter = reporter;
        this.repositories = repositories;
        this.respectVersion = respectVersion;
        this.respectExcludeFilters = respectExcludeFilters;
        this.defaultVersion = defaultVersion;
        this.formatCache = formatCache;
        this.cacheConfigs = cacheConfigs;
        this.configsCache = configsCache;
        Product.$init$((Product)this);
    }

    public ScalafmtDynamic() {
        this(ConsoleScalafmtReporter$.MODULE$, (List<Repository>)Nil$.MODULE$, true, true, BuildInfo$.MODULE$.stable(), ReentrantCache$.MODULE$.apply(), true, ReentrantCache$.MODULE$.apply());
    }
}

