/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.tokenizers;

import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Chars$ {
    public static final Chars$ MODULE$ = new Chars$();
    private static final char[] char2uescapeArray = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final Set<Object> otherLetters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'$', '_'}));
    private static final Set<Object> letterGroups = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{2, 1, 5, 3, 10}));

    public final char LF() {
        return '\n';
    }

    public final char FF() {
        return '\f';
    }

    public final char CR() {
        return '\r';
    }

    public final char SU() {
        return '\u001a';
    }

    public int digit2int(char ch, int base) {
        int num;
        int n = ch <= '9' ? ch - 48 : ('a' <= ch && ch <= 'z' ? ch - 97 + 10 : (num = 'A' <= ch && ch <= 'Z' ? ch - 65 + 10 : -1));
        if (0 <= num && num < base) {
            return num;
        }
        return -1;
    }

    public String char2uescape(char c) {
        Chars$.char2uescapeArray[2] = Chars$.hexChar$1(c >> 12);
        Chars$.char2uescapeArray[3] = Chars$.hexChar$1((c >> 8) % 16);
        Chars$.char2uescapeArray[4] = Chars$.hexChar$1((c >> 4) % 16);
        Chars$.char2uescapeArray[5] = Chars$.hexChar$1(c % 16);
        return new String(char2uescapeArray);
    }

    public boolean isLineBreakChar(char c) {
        char c2 = c;
        switch (c2) {
            case '\n': 
            case '\f': 
            case '\r': 
            case '\u001a': {
                return true;
            }
        }
        return false;
    }

    public boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r';
    }

    public boolean isVarPart(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    public boolean isIdentifierStart(char c) {
        return c == '_' || this.isIdentifierPart(c);
    }

    public boolean isIdentifierPart(char c) {
        return c == '$' || Character.isUnicodeIdentifierPart(c);
    }

    public boolean isUnicodeIdentifierPart(char c) {
        return c != '\u001a' && Character.isUnicodeIdentifierPart(c);
    }

    public boolean isSpecial(char c) {
        int chtp = Character.getType(c);
        return chtp == 25 || chtp == 28;
    }

    private final Set<Object> otherLetters() {
        return otherLetters;
    }

    private final Set<Object> letterGroups() {
        return letterGroups;
    }

    public boolean isScalaLetter(char ch) {
        return this.letterGroups().apply((Object)BoxesRunTime.boxToByte((byte)((byte)Character.getType(ch)))) || this.otherLetters().apply((Object)BoxesRunTime.boxToCharacter((char)ch));
    }

    public boolean isOperatorPart(char c) {
        char c2 = c;
        switch (c2) {
            case '!': 
            case '#': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return this.isSpecial(c2);
    }

    public final boolean isSpace(char ch) {
        char c = ch;
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNameChar(char ch) {
        boolean bl;
        if (this.isNameStart(ch)) return true;
        byte by = (byte)Character.getType(ch);
        switch (by) {
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            default: {
                bl = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(".-:"), ch);
                break;
            }
        }
        if (!bl) return false;
        return true;
    }

    public boolean isNameStart(char ch) {
        byte by = (byte)Character.getType(ch);
        switch (by) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: {
                return true;
            }
        }
        return ch == '_';
    }

    private static final char hexChar$1(int ch) {
        return (char)((ch < 10 ? 48 : 55) + ch);
    }

    private Chars$() {
    }
}

