/*
 * Decompiled with CFR 0.152.
 */
package org.scalatestplus.junit;

import java.lang.annotation.Annotation;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.scalatest.Reporter;
import org.scalatest.events.Event;
import org.scalatest.events.RunAborted;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestPending;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;
import org.scalatestplus.junit.Resources$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%4Qa\u0002\u0005\u0001\u00119A\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006M\u0001!\ta\n\u0005\u0006W\u0001!I\u0001\f\u0005\u0006\u0011\u0002!I!\u0013\u0005\u0006\u0019\u0002!\t%\u0014\u0005\u00063\u0002!\tA\u0017\u0002\u0014%Vtgj\u001c;jM&,'OU3q_J$XM\u001d\u0006\u0003\u0013)\tQA[;oSRT!a\u0003\u0007\u0002\u001bM\u001c\u0017\r\\1uKN$\b\u000f\\;t\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t1\u0012$D\u0001\u0018\u0015\tAB\"A\u0005tG\u0006d\u0017\r^3ti&\u0011!d\u0006\u0002\t%\u0016\u0004xN\u001d;fe\u0006Y!/\u001e8O_RLg-[3s\u0007\u0001\u0001\"A\b\u0013\u000e\u0003}Q!\u0001I\u0011\u0002\u00199|G/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\t\u001a\u0013A\u0002:v]:,'O\u0003\u0002\n\u0019%\u0011Qe\b\u0002\f%Vtgj\u001c;jM&,'/\u0001\u0004=S:LGO\u0010\u000b\u0003Q)\u0002\"!\u000b\u0001\u000e\u0003!AQa\u0007\u0002A\u0002u\t1\u0003^3ti\u0012+7o\u0019:jaRLwN\u001c(b[\u0016$B!L\u001bB\rB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005Y\u0006twMC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#AB*ue&tw\rC\u00037\u0007\u0001\u0007q'A\u0005tk&$XMT1nKB\u0011\u0001h\u0010\b\u0003su\u0002\"AO\t\u000e\u0003mR!\u0001\u0010\u000f\u0002\rq\u0012xn\u001c;?\u0013\tq\u0014#\u0001\u0004Qe\u0016$WMZ\u0005\u0003i\u0001S!AP\t\t\u000b\t\u001b\u0001\u0019A\"\u0002\u001dM,\u0018\u000e^3DY\u0006\u001c8OT1nKB\u0019\u0001\u0003R\u001c\n\u0005\u0015\u000b\"AB(qi&|g\u000eC\u0003H\u0007\u0001\u0007q'\u0001\u0005uKN$h*Y7f\u0003Q\u0019X/\u001b;f\t\u0016\u001c8M]5qi&|gNT1nKR\u0019qGS&\t\u000bY\"\u0001\u0019A\u001c\t\u000b\t#\u0001\u0019A\"\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00059\u000b\u0006C\u0001\tP\u0013\t\u0001\u0016C\u0001\u0003V]&$\b\"\u0002*\u0006\u0001\u0004\u0019\u0016!B3wK:$\bC\u0001+X\u001b\u0005)&B\u0001,\u0018\u0003\u0019)g/\u001a8ug&\u0011\u0001,\u0016\u0002\u0006\u000bZ,g\u000e^\u0001![\u0016\u001c8/Y4f\u001fJ$\u0006N]8xC\ndWm\u001d#fi\u0006LG.T3tg\u0006<W\rF\u000287vCQ\u0001\u0018\u0004A\u0002]\nq!\\3tg\u0006<W\rC\u0003_\r\u0001\u0007q,A\u0005uQJ|w/\u00192mKB\u0019\u0001\u0003\u00121\u0011\u0005\u00054gB\u00012e\u001d\tQ4-C\u0001\u0013\u0013\t)\u0017#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dD'!\u0003+ie><\u0018M\u00197f\u0015\t)\u0017\u0003")
public class RunNotifierReporter
implements Reporter {
    private final RunNotifier runNotifier;

    private String testDescriptionName(String suiteName, Option<String> suiteClassName, String testName) {
        String string;
        Option<String> option = suiteClassName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String suiteClassName2 = (String)some.value();
            string = new StringBuilder(2).append(testName).append("(").append(suiteClassName2).append(")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(2).append(testName).append("(").append(suiteName).append(")").toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private String suiteDescriptionName(String suiteName, Option<String> suiteClassName) {
        String string;
        Option<String> option = suiteClassName;
        if (option instanceof Some) {
            String suiteClassName2;
            Some some = (Some)option;
            string = suiteClassName2 = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = suiteName;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    @Override
    public void apply(Event event) {
        Event event2 = event;
        if (event2 instanceof TestStarting) {
            TestStarting testStarting = (TestStarting)event2;
            String suiteName = testStarting.suiteName();
            Option<String> suiteClassName = testStarting.suiteClassName();
            String testName = testStarting.testName();
            this.runNotifier.fireTestStarted(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestFailed) {
            Throwable throwable;
            TestFailed testFailed = (TestFailed)event2;
            String suiteName = testFailed.suiteName();
            Option<String> suiteClassName = testFailed.suiteClassName();
            String testName = testFailed.testName();
            Option<Throwable> throwable2 = testFailed.throwable();
            Option<Throwable> option = throwable2;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.value();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            Description description = Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestSucceeded) {
            TestSucceeded testSucceeded = (TestSucceeded)event2;
            String suiteName = testSucceeded.suiteName();
            Option<String> suiteClassName = testSucceeded.suiteClassName();
            String testName = testSucceeded.testName();
            this.runNotifier.fireTestFinished(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestIgnored) {
            TestIgnored testIgnored = (TestIgnored)event2;
            String suiteName = testIgnored.suiteName();
            Option<String> suiteClassName = testIgnored.suiteClassName();
            String testName = testIgnored.testName();
            this.runNotifier.fireTestIgnored(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestPending) {
            TestPending testPending = (TestPending)event2;
            String suiteName = testPending.suiteName();
            Option<String> suiteClassName = testPending.suiteClassName();
            String testName = testPending.testName();
            this.runNotifier.fireTestIgnored(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof SuiteAborted) {
            Throwable throwable;
            SuiteAborted suiteAborted = (SuiteAborted)event2;
            String suiteName = suiteAborted.suiteName();
            Option<String> suiteClassName = suiteAborted.suiteClassName();
            Option<Throwable> throwable3 = suiteAborted.throwable();
            Option<Throwable> option = throwable3;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.value();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            Description description = Description.createSuiteDescription((String)this.suiteDescriptionName(suiteName, suiteClassName), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof RunAborted) {
            Throwable throwable;
            RunAborted runAborted = (RunAborted)event2;
            String message = runAborted.message();
            Option<Throwable> throwable4 = runAborted.throwable();
            Option<Throwable> option = throwable4;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.value();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            String possiblyEmptyMessage = this.messageOrThrowablesDetailMessage(message, throwable4);
            Description description = Description.createSuiteDescription((String)new StringBuilder(1).append(Resources$.MODULE$.runAborted()).append(" ").append(possiblyEmptyMessage).toString(), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public String messageOrThrowablesDetailMessage(String message, Option<Throwable> throwable) {
        String string;
        String trimmedMessage = message.trim();
        if (!trimmedMessage.isEmpty()) {
            string = trimmedMessage;
        } else {
            String string2;
            Option<Throwable> option = throwable;
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable t = (Throwable)some.value();
                string2 = t.getMessage().trim();
            } else if (None$.MODULE$.equals(option)) {
                string2 = "";
            } else {
                throw new MatchError(option);
            }
            string = string2;
        }
        return string;
    }

    public RunNotifierReporter(RunNotifier runNotifier) {
        this.runNotifier = runNotifier;
    }
}

