/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.rest.hal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seedstack.seed.rest.hal.Link;

public class HalRepresentation {
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final Map<String, Object> links = new HashMap<String, Object>();
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final Map<String, Object> embedded = new HashMap<String, Object>();

    public HalRepresentation self(String href) {
        this.addLink("self", new Link(href));
        return this;
    }

    public HalRepresentation self(Link link) {
        this.addLink("self", link);
        return this;
    }

    public HalRepresentation link(String rel, String href) {
        this.addLink(rel, new Link(href));
        return this;
    }

    public HalRepresentation link(String rel, Link link) {
        this.addLink(rel, link);
        return this;
    }

    public Object getLink(String rel) {
        return this.links.get(rel);
    }

    public Map<String, Object> getLinks() {
        return this.links;
    }

    private void addLink(String rel, Link link) {
        Object obj = this.links.get(rel);
        if (obj == null) {
            this.links.put(rel, link);
        } else if (obj instanceof List) {
            List linksForRel = (List)obj;
            linksForRel.add(link);
            this.links.put(rel, linksForRel);
        } else if (obj instanceof Link) {
            Link linkCopy = (Link)obj;
            ArrayList<Link> linksForRel = new ArrayList<Link>();
            linksForRel.add(linkCopy);
            linksForRel.add(link);
            this.links.put(rel, linksForRel);
        }
    }

    public HalRepresentation embedded(String rel, Object embedded) {
        this.embedded.put(rel, embedded);
        return this;
    }

    public Map<String, Object> getEmbedded() {
        return this.embedded;
    }
}

