/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.rest.hal;

import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Link {
    private String href;
    private boolean templated = false;
    private String type;
    private String deprecation;
    private String name;
    private URI profile;
    private String title;
    private String hrefLang;
    private Map<String, Object> hrefVars = new HashMap<String, Object>();

    Link() {
    }

    public Link(String href) {
        this.href = href;
    }

    public Link(Link link) {
        this.href = link.href;
        this.templated = link.templated;
        this.type = link.type;
        this.deprecation = link.deprecation;
        this.name = link.name;
        this.profile = link.profile;
        this.title = link.title;
        this.hrefLang = link.hrefLang;
        this.hrefVars = new HashMap<String, Object>(link.hrefVars);
    }

    public Link templated() {
        this.templated = true;
        return this;
    }

    public Link deprecate(String deprecation) {
        this.deprecation = deprecation;
        return this;
    }

    public Link type(String type) {
        this.type = type;
        return this;
    }

    public Link name(String name) {
        this.name = name;
        return this;
    }

    public Link profile(URI profile) {
        this.profile = profile;
        return this;
    }

    public Link title(String title) {
        this.title = title;
        return this;
    }

    public Link hrefLang(String hrefLang) {
        this.hrefLang = hrefLang;
        return this;
    }

    public String getHref() {
        return this.isTemplated() ? this.href : this.expand();
    }

    public Link set(String variableName, Object value) {
        this.hrefVars.put(variableName, value.toString());
        return this;
    }

    @Deprecated
    public String expand() {
        return this.href == null ? null : UriTemplate.fromTemplate((String)this.href).expand(this.hrefVars);
    }

    public boolean isTemplated() {
        return this.templated;
    }

    public String getType() {
        return this.type;
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public String getName() {
        return this.name;
    }

    public URI getProfile() {
        return this.profile;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHrefLang() {
        return this.hrefLang;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        if (this.templated != link.templated) {
            return false;
        }
        if (this.href != null ? !this.href.equals(link.href) : link.href != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(link.type) : link.type != null) {
            return false;
        }
        if (this.deprecation != null ? !this.deprecation.equals(link.deprecation) : link.deprecation != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(link.name) : link.name != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(link.profile) : link.profile != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(link.title) : link.title != null) {
            return false;
        }
        if (this.hrefLang != null ? !this.hrefLang.equals(link.hrefLang) : link.hrefLang != null) {
            return false;
        }
        return this.hrefVars.equals(link.hrefVars);
    }

    public int hashCode() {
        int result = this.href != null ? this.href.hashCode() : 0;
        result = 31 * result + (this.templated ? 1 : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.deprecation != null ? this.deprecation.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.hrefLang != null ? this.hrefLang.hashCode() : 0);
        result = 31 * result + this.hrefVars.hashCode();
        return result;
    }
}

