/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.handler.internal.ArgumentConverter;
import org.openqa.selenium.remote.server.handler.internal.ResultConverter;

public class ExecuteAsyncScript
extends WebDriverHandler<Object> {
    private volatile String script;
    private final List<Object> args = new ArrayList<Object>();

    public ExecuteAsyncScript(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        this.script = (String)allParameters.get("script");
        List params = (List)allParameters.get("args");
        params.stream().map(new ArgumentConverter(this.getKnownElements())).forEach(this.args::add);
    }

    @Override
    public Object call() throws Exception {
        Object value = this.args.size() > 0 ? ((JavascriptExecutor)this.getDriver()).executeAsyncScript(this.script, this.args.toArray()) : ((JavascriptExecutor)this.getDriver()).executeAsyncScript(this.script, new Object[0]);
        return new ResultConverter(this.getKnownElements()).apply(value);
    }

    public String toString() {
        return String.format("[execute async script: %s, %s]", this.script, this.args);
    }
}

