/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticdesktop.nepomuk.nrl.inference.Rule;
import org.semanticdesktop.nepomuk.openrdf.InfSail;
import org.semanticdesktop.nepomuk.openrdf.SemanticViewSpecification;

public class NrlExample {
    private static final String MYONT = "@prefix foaf: <http://xmlns.com/foaf/0.1/>. \n@prefix : <http://example.org/ont#>.\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>.\n:Nepomuker a rdfs:Class ; rdfs:label \"a nepomuker\" ; rdfs:subClassOf foaf:Person. ";
    private static final String MYINST = "@prefix foaf: <http://xmlns.com/foaf/0.1/>. \n@prefix : <http://example.org/inst#>.\n@prefix ont: <http://example.org/ont#>.\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>.\n:Claudia a ont:Nepomuker ; rdfs:label \"Claudia\". \n:Dirk a ont:Nepomuker ; rdfs:label \"Dirk\" ; foaf:knows :Claudia . ";
    private static final String MY_RULES = "@prefix foaf: <http://xmlns.com/foaf/0.1/> .\n\n(?a foaf:knows ?b) -> (?b foaf:knows ?a) . ";
    private Sail base;
    private InfSail infsail;
    private Repository repo;
    private RepositoryConnection con;
    private Resource claudia = new URIImpl("http://example.org/inst#Claudia");
    private Resource dirk = new URIImpl("http://example.org/inst#Dirk");

    public void setupStore() throws SailException, RepositoryException {
        this.base = new MemoryStore();
        this.infsail = InfSail.createInfSail(this.base, InfSail.UnionStyle.REWRITE);
        this.repo = new SailRepository((Sail)this.infsail);
        this.repo.initialize();
        this.con = this.repo.getConnection();
        this.con.setAutoCommit(true);
    }

    public void doStuff() throws RDFParseException, RepositoryException, MalformedURLException, IOException, SailException {
        this.setupStore();
        URIImpl foaf_named_graph = new URIImpl("http://example.org/Ontology1");
        this.con.add(new URL("http://xmlns.com/foaf/spec/index.rdf").openStream(), "http://xmlns.com/foaf/0.1/", RDFFormat.RDFXML, new Resource[]{foaf_named_graph});
        URIImpl ontology_named_graph = new URIImpl("http://example.org/Ontology2");
        this.con.add((Reader)new StringReader(MYONT), "http://example.org", RDFFormat.N3, new Resource[]{ontology_named_graph});
        URIImpl instances_named_graph = new URIImpl("http://example.org/Instances");
        this.con.add((Reader)new StringReader(MYINST), "http://example.org", RDFFormat.N3, new Resource[]{instances_named_graph});
        URIImpl kb_named_graph = new URIImpl("http://example.org/KB");
        this.infsail.importGraph((Resource)kb_named_graph, new Resource[]{ontology_named_graph, foaf_named_graph, instances_named_graph});
        URIImpl inf_named_graph = new URIImpl("http://example.org/infGraph");
        this.infsail.createSemanticView((URI)kb_named_graph, (URI)inf_named_graph, SemanticViewSpecification.getNRL());
        System.out.println("Is Claudia a person in the KB? :" + this.con.hasStatement(this.claudia, RDF.TYPE, (Value)FOAF.Person, false, new Resource[]{kb_named_graph}));
        System.out.println("Is Claudia a person in the InfGraph? :" + this.con.hasStatement(this.claudia, RDF.TYPE, (Value)FOAF.Person, false, new Resource[]{inf_named_graph}));
        List<Rule> rules = Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new StringReader(MY_RULES))));
        URIImpl view_named_graph = new URIImpl("http://example.org/MyView");
        this.infsail.createSemanticView((URI)kb_named_graph, (URI)view_named_graph, new SemanticViewSpecification("MyView", rules, (URI)new URIImpl("http://example.org/something")));
        System.out.println("Does Claudia know Dirk in the KB? :" + this.con.hasStatement(this.claudia, FOAF.knows, (Value)this.dirk, false, new Resource[]{kb_named_graph}));
        System.out.println("Does Claudia know Dirk in the InfGraph? :" + this.con.hasStatement(this.claudia, FOAF.knows, (Value)this.dirk, false, new Resource[]{inf_named_graph}));
        System.out.println("Does Claudia know Dirk in the View? :" + this.con.hasStatement(this.claudia, FOAF.knows, (Value)this.dirk, false, new Resource[]{view_named_graph}));
        this.infsail.debug();
        this.con.close();
    }

    public static void main(String[] args) throws Exception {
        new NrlExample().doStuff();
    }
}

