/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticdesktop.nepomuk.nrl.inference.Rule;
import org.semanticdesktop.nepomuk.openrdf.InfSail;
import org.semanticdesktop.nepomuk.openrdf.SemanticViewSpecification;
import org.semanticdesktop.nepomuk.openrdf.UnionMemoryStore;

public class SpeedTest {
    URI basegraph = new URIImpl("http://example.org/base");
    URI infgraph = new URIImpl("http://example.org/inf");
    private List<Rule> rules;
    private MemoryStore base;
    private InfSail infsail;
    private SailRepository repo;
    private SailRepositoryConnection con;

    private void setup(String rulesFile) throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/org/semanticdesktop/nepomuk/nrl/" + rulesFile);
        List<Rule> rules = Rule.parseRules(Rule.rulesParserFromReader(new BufferedReader(new InputStreamReader(is))));
        this.infsail.createSemanticView(this.basegraph, this.infgraph, new SemanticViewSpecification("testrules", rules, (URI)new URIImpl("urn:test:rules")));
    }

    public long test() throws Exception {
        this.base = new UnionMemoryStore();
        this.infsail = new InfSail((Sail)this.base);
        this.repo = new SailRepository((Sail)this.infsail);
        this.repo.initialize();
        this.con = this.repo.getConnection();
        this.con.setAutoCommit(false);
        this.con.add((InputStream)new FileInputStream(new File("data/foaf.rdfs")), "", RDFFormat.RDFXML, new Resource[]{this.basegraph});
        this.con.commit();
        long start = System.currentTimeMillis();
        this.setup("rdfs.rules");
        System.err.println(this.con.size(new Resource[]{this.basegraph}));
        System.err.println(this.con.size(new Resource[]{this.infgraph}));
        long t = System.currentTimeMillis() - start;
        System.err.println(String.format("Took %.3f seconds.", (double)t / 1000.0));
        this.infsail.debug();
        this.con.close();
        this.repo.shutDown();
        return t;
    }

    public static void main(String[] args) throws Exception {
        long res = 0L;
        float IT = 10.0f;
        int i = 0;
        while ((float)i < IT) {
            res += new SpeedTest().test();
            ++i;
        }
        System.err.println(String.format("Average: %.3f", (double)((float)res / IT) / 1000.0));
    }
}

