/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference;

import info.aduna.iteration.CloseableIteration;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailException;
import org.semanticdesktop.nepomuk.nrl.inference.BindingEnvironment;
import org.semanticdesktop.nepomuk.nrl.inference.BindingStack;
import org.semanticdesktop.nepomuk.nrl.inference.Rule;
import org.semanticdesktop.nepomuk.nrl.inference.RuleContext;
import org.semanticdesktop.nepomuk.openrdf.InfSailConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BFRuleContext
implements RuleContext {
    protected BindingStack env;
    protected Rule rule;
    protected URI updateGraph;
    protected List<Statement> pending;
    protected List<Statement> deletesPending = new ArrayList<Statement>();
    private URI infGraph;
    private URI baseGraph;
    private InfSailConnection connection;
    protected static Logger logger = Logger.getLogger(BFRuleContext.class.getName());

    public BFRuleContext(InfSailConnection connection, URI base, URI update, URI infgraph) {
        this.connection = connection;
        this.baseGraph = base;
        this.updateGraph = update;
        this.infGraph = infgraph;
        this.env = new BindingStack();
        this.pending = new ArrayList<Statement>();
    }

    public void close() {
    }

    public URI getBaseGraph() {
        return this.baseGraph;
    }

    public URI getInfGraph() {
        return this.infGraph;
    }

    @Override
    public BindingEnvironment getEnv() {
        return this.env;
    }

    @Override
    public URI getUpdateGraph() {
        return this.updateGraph;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    @Override
    public void add(Statement t) {
        this.pending.add(t);
    }

    public int flushPending() throws SailException {
        int added = 0;
        this.connection.addBase(this.infGraph, this.pending);
        this.connection.baseCommit();
        this.pending.clear();
        return added += this.pending.size();
    }

    @Override
    public boolean contains(Statement t) throws SailException {
        return this.contains((Value)t.getSubject(), (Value)t.getPredicate(), t.getObject());
    }

    @Override
    public boolean contains(Value s, Value p, Value o) throws SailException {
        CloseableIteration it = this.connection.getStatements((Resource)s, (URI)p, o, false, new Resource[]{this.baseGraph, this.updateGraph});
        try {
            boolean bl = it.hasNext();
            return bl;
        }
        finally {
            it.close();
        }
    }

    public void resetEnv() {
        this.env.reset();
    }

    @Override
    public void remove(Statement t) {
        throw new RuntimeException("Remove not implemented!");
    }

    public CloseableIteration<? extends Statement, SailException> findAllStatements(Value subj, Value pred, Value obj) throws SailException {
        return this.connection.getStatements((Resource)subj, (URI)pred, obj, false, new Resource[]{this.baseGraph, this.updateGraph});
    }

    public CloseableIteration<? extends Statement, SailException> findBaseStatements(Value subj, Value pred, Value obj) throws SailException {
        return this.connection.getStatements((Resource)subj, (URI)pred, obj, false, new Resource[]{this.baseGraph});
    }

    public CloseableIteration<? extends Statement, SailException> findUpdateStatements(Value subj, Value pred, Value obj) throws SailException {
        return this.connection.getStatements((Resource)subj, (URI)pred, obj, false, new Resource[]{this.updateGraph});
    }

    public boolean inUpdateGraph(Statement t) throws SailException {
        boolean res = false;
        CloseableIteration i = this.connection.getStatements(t.getSubject(), t.getPredicate(), t.getObject(), false, new Resource[]{this.updateGraph});
        if (i.hasNext()) {
            res = true;
        }
        i.close();
        return res;
    }
}

