/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference;

import java.util.ArrayList;
import java.util.Arrays;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.semanticdesktop.nepomuk.nrl.inference.BindingEnvironment;
import org.semanticdesktop.nepomuk.nrl.inference.Reasoner;
import org.semanticdesktop.nepomuk.nrl.inference.model.Functor;
import org.semanticdesktop.nepomuk.nrl.inference.model.TriplePattern;
import org.semanticdesktop.nepomuk.nrl.inference.model.Variable;

public class BindingStack
implements BindingEnvironment {
    protected Value[] environment;
    protected ArrayList<Value[]> trail = new ArrayList();
    protected int index = 0;
    protected int highWater = 0;
    protected static final int MAX_VAR = 10;

    public BindingStack() {
        this.trail.add(new Value[10]);
        this.environment = this.trail.get(0);
        this.highWater = 0;
        this.index = 0;
    }

    public void push() {
        if (this.index == this.highWater) {
            this.trail.add(new Value[10]);
            ++this.highWater;
        }
        Value[] newenv = this.trail.get(++this.index);
        System.arraycopy(this.environment, 0, newenv, 0, 10);
        this.environment = newenv;
    }

    public void unwind() throws IndexOutOfBoundsException {
        if (this.index <= 0) {
            throw new IndexOutOfBoundsException("Underflow of BindingEnvironment");
        }
        this.environment = this.trail.get(--this.index);
    }

    public void commit() throws IndexOutOfBoundsException {
        if (this.index > 0) {
            Value[] newenv = this.trail.get(this.index - 1);
            this.trail.set(this.index - 1, this.environment);
            this.trail.set(this.index, newenv);
            --this.index;
        } else {
            throw new IndexOutOfBoundsException("Underflow of BindingEnvironment");
        }
    }

    public void reset() {
        this.index = 0;
        this.environment = this.trail.get(0);
        Arrays.fill(this.environment, null);
    }

    public Value[] getEnvironment() {
        return this.environment;
    }

    public Value getBinding(Value node) {
        if (node instanceof Variable) {
            Value r = this.environment[((Variable)node).getIndex()];
            if (r == null) {
                return null;
            }
            return r;
        }
        if (Functor.isFunctor(node)) {
            Functor functor = (Functor)node;
            if (functor.isGround()) {
                return node;
            }
            Value[] args = functor.getArgs();
            ArrayList<Value> boundargs = new ArrayList<Value>(args.length);
            int i = 0;
            while (i < args.length) {
                Value binding = this.getBinding(args[i]);
                if (binding == null) {
                    return null;
                }
                boundargs.add(binding);
                ++i;
            }
            Functor newf = new Functor(functor.getName(), boundargs);
            return Functor.makeFunctorValue(newf);
        }
        return node;
    }

    public boolean bind(int i, Value value) {
        Value node = this.environment[i];
        if (node == null) {
            this.environment[i] = value;
            return true;
        }
        return Reasoner.sameValueAs(node, value);
    }

    public boolean bind(Value var, Value value) {
        if (var instanceof Variable) {
            return this.bind(((Variable)var).getIndex(), value);
        }
        return Reasoner.sameValueAs(var, value);
    }

    public void bindNoCheck(Variable var, Value value) {
        this.environment[var.getIndex()] = value;
    }

    public Statement instantiate(TriplePattern pattern) {
        Value o;
        Value p;
        Value s = this.getBinding(pattern.getSubject());
        if (s instanceof Variable) {
            s = Reasoner.createBlankNode();
        }
        if ((p = this.getBinding(pattern.getPredicate())) instanceof Variable) {
            p = Reasoner.createBlankNode();
        }
        if ((o = this.getBinding(pattern.getObject())) instanceof Variable) {
            o = Reasoner.createBlankNode();
        }
        return new StatementImpl((Resource)s, (URI)p, o);
    }
}

