/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference;

import java.util.HashMap;
import java.util.Map;
import org.semanticdesktop.nepomuk.nrl.inference.model.Builtin;

public class BuiltinRegistry {
    public static BuiltinRegistry theRegistry = new BuiltinRegistry();
    protected Map<String, Builtin> builtins = new HashMap<String, Builtin>();
    protected Map<String, Builtin> builtinsByURI = new HashMap<String, Builtin>();

    public void register(String functor, Builtin impl) {
        this.builtins.put(functor, impl);
        this.builtinsByURI.put(impl.getURI(), impl);
    }

    public void register(Builtin impl) {
        this.builtins.put(impl.getName(), impl);
        this.builtinsByURI.put(impl.getURI(), impl);
    }

    public Builtin getImplementation(String functor) {
        return this.builtins.get(functor);
    }

    public Builtin getImplementationByURI(String uri) {
        return this.builtinsByURI.get(uri);
    }
}

