/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference;

import info.aduna.iteration.CloseableIteration;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.sail.SailException;
import org.semanticdesktop.nepomuk.nrl.inference.BFRuleContext;
import org.semanticdesktop.nepomuk.nrl.inference.BindingStack;
import org.semanticdesktop.nepomuk.nrl.inference.Rule;
import org.semanticdesktop.nepomuk.nrl.inference.exceptions.ReasonerException;
import org.semanticdesktop.nepomuk.nrl.inference.model.ClauseEntry;
import org.semanticdesktop.nepomuk.nrl.inference.model.Functor;
import org.semanticdesktop.nepomuk.nrl.inference.model.TriplePattern;
import org.semanticdesktop.nepomuk.nrl.inference.model.Variable;
import org.semanticdesktop.nepomuk.openrdf.InfSailConnection;
import org.semanticdesktop.nepomuk.openrdf.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reasoner {
    private static final boolean TRACE = false;
    Logger log = LoggerFactory.getLogger(Reasoner.class);

    public static boolean sameValueAs(Value a, Value b) {
        return a.equals(b);
    }

    public static Value createBlankNode() {
        return new BNodeImpl(UUID.randomUUID().toString());
    }

    public List<URI> applyRules(InfSailConnection connection, URI baseGraph, URI dataGraph, View inf) throws SailException {
        return this.applyRules(connection, baseGraph, dataGraph, inf, null);
    }

    public List<URI> applyRules(InfSailConnection connection, URI baseGraph, URI dataGraph, View inf, Set<Statement> newStatements) throws SailException {
        int res = 0;
        int this_strata = 0;
        int i = 0;
        Vector<URI> resStratas = new Vector<URI>();
        URI base = inf.name;
        do {
            this_strata = 0;
            URI strata = inf.getStrata(connection);
            BFRuleContext context = new BFRuleContext(connection, base, dataGraph, strata);
            Vector<Rule> rules = new Vector<Rule>();
            block1: for (Rule r : inf.rules) {
                if (r.isAxiom()) continue;
                ClauseEntry[] clauseEntryArray = r.getBody();
                int n = clauseEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClauseEntry clause = clauseEntryArray[n2];
                    if (this.sloppyMatch(connection, clause, dataGraph)) {
                        rules.add(r);
                        continue block1;
                    }
                    ++n2;
                }
            }
            for (Rule r : rules) {
                context.setRule(r);
                if (!this.matchClauseList(r.getBody(), context, newStatements)) continue;
                int added = context.flushPending();
                res += added;
                this_strata += added;
            }
            if (this_strata > 0) {
                dataGraph = strata;
                inf.addStrata(strata);
                resStratas.add(strata);
            }
            this.log.debug("Strata " + i++);
        } while (this_strata > 0);
        return resStratas;
    }

    private boolean sloppyMatch(InfSailConnection connection, ClauseEntry clause, URI dataGraph) throws SailException {
        if (clause instanceof TriplePattern) {
            TriplePattern triplepattern = (TriplePattern)clause;
            Value s = triplepattern.getSubjectMatch();
            Value p = triplepattern.getPredicateMatch();
            Value o = triplepattern.getObjectMatch();
            if (s == null && p == null && o == null) {
                return true;
            }
            CloseableIteration r = null;
            try {
                r = connection.getStatements((Resource)s, (URI)p, o, false, new Resource[]{dataGraph});
                boolean bl = r.hasNext();
                return bl;
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        throw new ReasonerException("Only triple-patterns are supported! Was: " + clause.getClass());
    }

    private boolean matchClauseList(ClauseEntry[] entries, BFRuleContext context, Set<Statement> newStatements) throws SailException {
        return this.matchClauseList(entries, context, false, entries.length - 1, newStatements);
    }

    private boolean matchClauseList(ClauseEntry[] entries, BFRuleContext context, boolean foundInNewData, int index, Set<Statement> newStatements) throws SailException {
        Statement t;
        Rule rule = context.getRule();
        BindingStack env = (BindingStack)context.getEnv();
        if (index == -1) {
            if (!foundInNewData && rule.getBody().length > 0) {
                return false;
            }
            this.log.debug("Fired rule: " + rule.toShortString() + " = " + rule.instantiate(env));
            int i = 0;
            while (i < rule.headLength()) {
                ClauseEntry hClause = rule.getHeadElement(i);
                if (hClause instanceof TriplePattern) {
                    Statement t2;
                    if (!(env.getBinding(((TriplePattern)hClause).getSubject()) instanceof Literal) && !context.contains(t2 = env.instantiate((TriplePattern)hClause))) {
                        if (newStatements != null) {
                            newStatements.add(t2);
                        }
                        context.add(t2);
                    }
                } else {
                    throw new ReasonerException("Only triple-patterns are supported! Was: " + hClause.getClass());
                }
                ++i;
            }
            return true;
        }
        TriplePattern clause = (TriplePattern)entries[index];
        Value objPattern = env.getBinding(clause.getObject());
        if (Functor.isFunctor(objPattern)) {
            objPattern = null;
        }
        Value subjPattern = env.getBinding(clause.getSubject());
        Value predPattern = env.getBinding(clause.getPredicate());
        CloseableIteration<? extends Statement, SailException> i = context.findBaseStatements(subjPattern, predPattern, objPattern);
        boolean foundMatch = false;
        while (i.hasNext()) {
            t = (Statement)i.next();
            env.push();
            if (this.matchNode(clause.getPredicate(), (Value)t.getPredicate(), env) && this.matchNode(clause.getObject(), t.getObject(), env) && this.matchNode(clause.getSubject(), (Value)t.getSubject(), env)) {
                foundMatch |= this.matchClauseList(entries, context, foundInNewData, index - 1, newStatements);
            }
            env.unwind();
        }
        i.close();
        i = context.findUpdateStatements(subjPattern, predPattern, objPattern);
        while (i.hasNext()) {
            t = (Statement)i.next();
            env.push();
            if (this.matchNode(clause.getPredicate(), (Value)t.getPredicate(), env) && this.matchNode(clause.getObject(), t.getObject(), env) && this.matchNode(clause.getSubject(), (Value)t.getSubject(), env)) {
                foundMatch |= this.matchClauseList(entries, context, true, index - 1, newStatements);
            }
            env.unwind();
        }
        i.close();
        return foundMatch;
    }

    private boolean matchNode(Value pattern, Value node, BindingStack env) {
        if (pattern instanceof Variable) {
            int index = ((Variable)pattern).getIndex();
            return env.bind(index, node);
        }
        if (pattern instanceof Variable) {
            return true;
        }
        if (pattern instanceof Resource || pattern instanceof Literal) {
            return pattern.equals(node);
        }
        throw new ReasonerException("Unknown node type " + node.getClass());
    }

    public void applyAxioms(InfSailConnection connection, URI base, View inf) throws SailException {
        URI strata = null;
        for (Rule r : inf.rules) {
            if (!r.isAxiom()) continue;
            ClauseEntry[] clauseEntryArray = r.getHead();
            int n = clauseEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClauseEntry c = clauseEntryArray[n2];
                if (c instanceof TriplePattern) {
                    TriplePattern t = (TriplePattern)c;
                    if (!(t.getSubject() instanceof Resource)) {
                        throw new ReasonerException("Axiom with non-resource subject in head: " + c + " in " + r.toShortString());
                    }
                    if (!(t.getPredicate() instanceof URI)) {
                        throw new ReasonerException("Axiom with non-uri predicate in head: " + c + " in " + r.toShortString());
                    }
                    if (!(t.getObject() instanceof Literal) && !(t.getObject() instanceof Resource)) {
                        throw new ReasonerException("Axiom with invalid RDF object in head: " + c + " in " + r.toShortString());
                    }
                    StatementImpl s = new StatementImpl((Resource)t.getSubject(), (URI)t.getPredicate(), t.getObject());
                    if (!this.contains(connection, (Statement)s, base)) {
                        this.log.debug("Adding axiom " + r.toShortString());
                        if (strata == null) {
                            strata = inf.getStrata(connection);
                            inf.addStrata(strata);
                        }
                        connection.addBase(strata, (Statement)s);
                    }
                } else {
                    if (c instanceof Functor) {
                        throw new ReasonerException("Only triple-patterns are supported!");
                    }
                    if (c instanceof Rule) {
                        throw new ReasonerException("Only triple-patterns are supported!");
                    }
                }
                ++n2;
            }
        }
        connection.commit();
    }

    private boolean contains(InfSailConnection connection, Statement s, URI context) throws SailException {
        CloseableIteration r = connection.getStatements(s.getSubject(), s.getPredicate(), s.getObject(), false, new Resource[]{context});
        try {
            boolean bl = r.hasNext();
            return bl;
        }
        finally {
            r.close();
        }
    }
}

