/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.semanticdesktop.nepomuk.nrl.inference.BindingEnvironment;
import org.semanticdesktop.nepomuk.nrl.inference.BuiltinRegistry;
import org.semanticdesktop.nepomuk.nrl.inference.exceptions.ReasonerException;
import org.semanticdesktop.nepomuk.nrl.inference.exceptions.RulesetNotFoundException;
import org.semanticdesktop.nepomuk.nrl.inference.exceptions.WrappedIOException;
import org.semanticdesktop.nepomuk.nrl.inference.model.Builtin;
import org.semanticdesktop.nepomuk.nrl.inference.model.ClauseEntry;
import org.semanticdesktop.nepomuk.nrl.inference.model.Functor;
import org.semanticdesktop.nepomuk.nrl.inference.model.TriplePattern;
import org.semanticdesktop.nepomuk.nrl.inference.model.Variable;
import org.semanticdesktop.nepomuk.nrl.inference.utils.PrefixMapping;
import org.semanticdesktop.nepomuk.nrl.inference.utils.Tokenizer;
import org.semanticdesktop.nepomuk.nrl.inference.utils.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
implements ClauseEntry {
    private static final String RDFS_RULES = null;
    protected ClauseEntry[] body;
    protected ClauseEntry[] head;
    protected String name;
    protected int numVars = -1;
    protected boolean isBackward = false;
    protected boolean isMonotonic = true;
    static Logger logger = Logger.getLogger(Rule.class.getName());
    private static List<Rule> rdfsrules;

    public Rule(List<ClauseEntry> head, List<ClauseEntry> body) {
        this(null, head, body);
    }

    public Rule(String name, List<ClauseEntry> head, List<ClauseEntry> body) {
        this(name, head.toArray(new ClauseEntry[head.size()]), body.toArray(new ClauseEntry[body.size()]));
    }

    public Rule(String name, ClauseEntry[] head, ClauseEntry[] body) {
        this.name = name;
        this.head = head;
        this.body = body;
        this.isMonotonic = this.allMonotonic(head);
    }

    private boolean allMonotonic(ClauseEntry[] elts) {
        int i = 0;
        while (i < elts.length) {
            ClauseEntry elt = elts[i];
            if (elt instanceof Functor) {
                Builtin b = ((Functor)elt).getImplementor();
                if (b != null) {
                    if (!b.isMonotonic()) {
                        return false;
                    }
                } else {
                    throw new ReasonerException("Undefined Functor " + ((Functor)elt).getName() + " in " + this.toShortString());
                }
            }
            ++i;
        }
        return true;
    }

    public int bodyLength() {
        return this.body.length;
    }

    public ClauseEntry getBodyElement(int n) {
        return this.body[n];
    }

    public ClauseEntry[] getBody() {
        return this.body;
    }

    public int headLength() {
        return this.head.length;
    }

    public ClauseEntry getHeadElement(int n) {
        return this.head[n];
    }

    public ClauseEntry[] getHead() {
        return this.head;
    }

    public boolean isBackward() {
        return this.isBackward;
    }

    public void setBackward(boolean flag) {
        this.isBackward = flag;
    }

    public String getName() {
        return this.name;
    }

    public void setNumVars(int n) {
        this.numVars = n;
    }

    public int getNumVars() {
        if (this.numVars == -1) {
            int max = this.findVars(this.body, -1);
            max = this.findVars(this.head, max);
            this.numVars = max + 1;
        }
        return this.numVars;
    }

    private int findVars(Object[] nodes, int maxIn) {
        int max = maxIn;
        int i = 0;
        while (i < nodes.length) {
            Object node = nodes[i];
            max = node instanceof TriplePattern ? this.findVars((TriplePattern)node, max) : this.findVars((Functor)node, max);
            ++i;
        }
        return max;
    }

    private int findVars(TriplePattern t, int maxIn) {
        int max = maxIn;
        max = this.maxVarIndex(t.getSubject(), max);
        max = this.maxVarIndex(t.getPredicate(), max);
        Value obj = t.getObject();
        if (obj instanceof Variable) {
            max = this.maxVarIndex(obj, max);
        } else if (Functor.isFunctor(obj)) {
            max = this.findVars((Functor)obj, max);
        }
        return max;
    }

    private int findVars(Functor f, int maxIn) {
        int max = maxIn;
        Value[] args = f.getArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof Variable) {
                max = this.maxVarIndex(args[i], max);
            }
            ++i;
        }
        return max;
    }

    private int maxVarIndex(Value var, int max) {
        int index;
        if (var instanceof Variable && (index = ((Variable)var).index) > max) {
            return index;
        }
        return max;
    }

    public Rule instantiate(BindingEnvironment env) {
        HashMap<Variable, Value> vmap = new HashMap<Variable, Value>();
        return new Rule(this.name, this.cloneClauseArray(this.head, vmap, env), this.cloneClauseArray(this.body, vmap, env));
    }

    public Rule cloneRule() {
        if (this.getNumVars() > 0) {
            HashMap<Variable, Value> vmap = new HashMap<Variable, Value>();
            return new Rule(this.name, this.cloneClauseArray(this.head, vmap, null), this.cloneClauseArray(this.body, vmap, null));
        }
        return this;
    }

    private ClauseEntry[] cloneClauseArray(ClauseEntry[] clauses, Map<Variable, Value> vmap, BindingEnvironment env) {
        ClauseEntry[] cClauses = new ClauseEntry[clauses.length];
        int i = 0;
        while (i < clauses.length) {
            cClauses[i] = this.cloneClause(clauses[i], vmap, env);
            ++i;
        }
        return cClauses;
    }

    private ClauseEntry cloneClause(ClauseEntry clause, Map<Variable, Value> vmap, BindingEnvironment env) {
        if (clause instanceof TriplePattern) {
            TriplePattern tp = (TriplePattern)clause;
            return new TriplePattern(this.cloneValue(tp.getSubject(), vmap, env), this.cloneValue(tp.getPredicate(), vmap, env), this.cloneValue(tp.getObject(), vmap, env));
        }
        return this.cloneFunctor((Functor)clause, vmap, env);
    }

    private Functor cloneFunctor(Functor f, Map<Variable, Value> vmap, BindingEnvironment env) {
        Value[] args = f.getArgs();
        Value[] cargs = new Value[args.length];
        int i = 0;
        while (i < args.length) {
            cargs[i] = this.cloneValue(args[i], vmap, env);
            ++i;
        }
        Functor fn = new Functor(f.getName(), cargs);
        fn.setImplementor(f.getImplementor());
        return fn;
    }

    private Value cloneValue(Value nIn, Map<Variable, Value> vmap, BindingEnvironment env) {
        Value n;
        Value value = n = env == null ? nIn : env.getBinding(nIn);
        if (n instanceof Variable) {
            Variable nv = (Variable)n;
            Object c = vmap.get(nv);
            if (c == null) {
                c = ((Variable)n).cloneValue();
                vmap.put(nv, (Value)c);
            }
            return c;
        }
        if (Functor.isFunctor(n)) {
            Functor f = (Functor)n;
            return Functor.makeFunctorValue(this.cloneFunctor(f, vmap, env));
        }
        return n;
    }

    public boolean isMonotonic() {
        return this.isMonotonic;
    }

    public boolean isAxiom() {
        return this.body.length == 0;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[ ");
        if (this.name != null) {
            buff.append(this.name);
            buff.append(": ");
        }
        if (this.isBackward) {
            int i = 0;
            while (i < this.head.length) {
                buff.append(this.head[i]);
                buff.append(" ");
                ++i;
            }
            buff.append("<- ");
            i = 0;
            while (i < this.body.length) {
                buff.append(this.body[i]);
                buff.append(" ");
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.body.length) {
                buff.append(this.body[i]);
                buff.append(" ");
                ++i;
            }
            buff.append("-> ");
            i = 0;
            while (i < this.head.length) {
                buff.append(this.head[i]);
                buff.append(" ");
                ++i;
            }
        }
        buff.append("]");
        return buff.toString();
    }

    public String toShortString() {
        if (this.name != null) {
            return this.name;
        }
        return this.toString();
    }

    public static Rule parseRule(String source) throws ParserException {
        Parser parser = new Parser(source);
        return parser.parseRule();
    }

    public static List<Rule> rulesFromURL(String uri) {
        try {
            BufferedReader br = Util.readerFromURL(uri);
            return Rule.parseRules(Rule.rulesParserFromReader(br));
        }
        catch (WrappedIOException e) {
            throw new RulesetNotFoundException(uri);
        }
    }

    public static String rulesStringFromReader(BufferedReader src) {
        try {
            String line;
            StringBuffer result = new StringBuffer();
            while ((line = src.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("//")) continue;
                result.append(line);
                result.append("\n");
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    public static Parser rulesParserFromReader(BufferedReader src) {
        try {
            String line;
            StringBuffer result = new StringBuffer();
            HashMap<String, String> prefixes = new HashMap<String, String>();
            ArrayList<Rule> preloadedRules = new ArrayList<Rule>();
            while ((line = src.readLine()) != null) {
                if (line.startsWith("#") || (line = line.trim()).startsWith("//")) continue;
                if (line.startsWith("@prefix")) {
                    line = line.substring("@prefix".length());
                    String prefix = Rule.nextArg(line);
                    String rest = Rule.nextAfterArg(line);
                    if (prefix.endsWith(":")) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    String url = Rule.extractURI(rest);
                    prefixes.put(prefix, url);
                    continue;
                }
                if (line.startsWith("@include")) {
                    String url = Rule.extractURI(line = line.substring("@include".length()));
                    if (url.equalsIgnoreCase("rdfs")) {
                        preloadedRules.addAll(Rule.loadRDFSRules());
                        continue;
                    }
                    preloadedRules.addAll(Rule.rulesFromURL(url));
                    continue;
                }
                result.append(line);
                result.append("\n");
            }
            Parser parser = new Parser(result.toString());
            parser.registerPrefixMap(prefixes);
            parser.addRulesPreload(preloadedRules);
            return parser;
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    private static Collection<Rule> loadRDFSRules() {
        if (rdfsrules == null) {
            BufferedReader br;
            InputStream is = Rule.class.getResourceAsStream(RDFS_RULES);
            try {
                br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new WrappedIOException(e);
            }
            rdfsrules = Rule.parseRules(Rule.rulesParserFromReader(br));
        }
        return rdfsrules;
    }

    private static String extractURI(String lineSoFar) {
        String token = lineSoFar.trim();
        if (token.startsWith("<")) {
            int split = token.indexOf(62);
            token = token.substring(1, split);
        }
        return token;
    }

    private static String nextArg(String token) {
        int start = Rule.nextSplit(0, false, token);
        int stop = Rule.nextSplit(start, true, token);
        return token.substring(start, stop);
    }

    private static String nextAfterArg(String token) {
        int start = Rule.nextSplit(0, false, token);
        int stop = Rule.nextSplit(start, true, token);
        int rest = Rule.nextSplit(stop, false, token);
        return token.substring(rest);
    }

    private static int nextSplit(int start, boolean white, String line) {
        int i = start;
        while (i < line.length()) {
            boolean isWhite = Character.isWhitespace(line.charAt(i));
            if (white & isWhite || !white & !isWhite) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static void main(String[] args) {
        String test = " <http://myuri/fool>.";
        String arg = Rule.nextArg(test);
        String rest = Rule.nextAfterArg(test);
        String uri = Rule.extractURI(rest);
        System.out.println("ARG = [" + arg + "], URI = [" + uri + "]");
    }

    public static List<Rule> parseRules(Parser parser) throws ParserException {
        boolean finished = false;
        ArrayList<Rule> ruleset = new ArrayList<Rule>();
        ruleset.addAll(parser.getRulesPreload());
        while (!finished) {
            try {
                parser.peekToken();
            }
            catch (NoSuchElementException e) {
                finished = true;
                break;
            }
            Rule rule = parser.parseRule();
            ruleset.add(rule);
        }
        return ruleset;
    }

    public static List<Rule> parseRules(String source) throws ParserException {
        return Rule.parseRules(new Parser(source));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        if (other.head.length != this.head.length) {
            return false;
        }
        if (other.body.length != this.body.length) {
            return false;
        }
        int i = 0;
        while (i < this.body.length) {
            if (!this.body[i].sameAs(other.body[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.head.length) {
            if (!this.head[i].sameAs(other.head[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.body.length) {
            hash = hash << 1 ^ this.body[i].hashCode();
            ++i;
        }
        i = 0;
        while (i < this.head.length) {
            hash = hash << 1 ^ this.head[i].hashCode();
            ++i;
        }
        return hash;
    }

    @Override
    public boolean sameAs(Object o) {
        return this.equals(o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parser {
        private Tokenizer stream;
        private String lookahead;
        private static final int NORMAL = 0;
        private static final int STARTED_LITERAL = 1;
        private int literalState = 0;
        protected List<String> priorTokens = new ArrayList<String>();
        private static final int maxPriors = 20;
        private Map<String, Variable> varMap;
        private PrefixMapping prefixMapping = PrefixMapping.Factory.create();
        private List<Rule> preloadedRules = new ArrayList<Rule>();

        Parser(String source) {
            this.stream = new Tokenizer(source, "()[], \t\n\r", "'\"", true);
            this.lookahead = null;
        }

        public void registerPrefix(String prefix, String namespace) {
            this.prefixMapping.setNsPrefix(prefix, namespace);
        }

        public void registerPrefixMap(Map<String, String> map) {
            this.prefixMapping.setNsPrefixes(map);
        }

        public Map getPrefixMap() {
            return this.prefixMapping.getNsPrefixMap();
        }

        void addRulesPreload(List<Rule> rules) {
            this.preloadedRules.addAll(rules);
        }

        public List<Rule> getRulesPreload() {
            return this.preloadedRules;
        }

        String nextToken() {
            if (this.lookahead != null) {
                String temp = this.lookahead;
                this.lookahead = null;
                return temp;
            }
            String token = this.stream.nextToken();
            if (this.literalState == 0) {
                while (this.isSeparator(token)) {
                    token = this.stream.nextToken();
                }
            }
            if (token.equals("'")) {
                this.literalState = this.literalState == 0 ? 1 : 0;
            }
            this.priorTokens.add(0, token);
            if (this.priorTokens.size() > 20) {
                this.priorTokens.remove(this.priorTokens.size() - 1);
            }
            return token;
        }

        public String recentTokens() {
            StringBuffer trace = new StringBuffer();
            int i = this.priorTokens.size() - 1;
            while (i >= 0) {
                trace.append(this.priorTokens.get(i));
                trace.append(" ");
                --i;
            }
            return trace.toString();
        }

        String peekToken() {
            if (this.lookahead == null) {
                this.lookahead = this.nextToken();
            }
            return this.lookahead;
        }

        void pushback(String token) {
            this.lookahead = token;
        }

        boolean isSeparator(String token) {
            if (token.length() == 1) {
                char c = token.charAt(0);
                return c == ',' || Character.isWhitespace(c);
            }
            return false;
        }

        boolean isSyntax(String token) {
            if (token.length() == 1) {
                char c = token.charAt(0);
                return c == '(' || c == ')' || c == '[' || c == ']';
            }
            return false;
        }

        Variable getValueVar(String name) {
            Variable Value2 = this.varMap.get(name);
            if (Value2 == null) {
                Value2 = new Variable(name, this.varMap.size());
                this.varMap.put(name, Value2);
            }
            return Value2;
        }

        Value parseValue(String token) {
            if (token.startsWith("?")) {
                return this.getValueVar(token);
            }
            if (token.equals("*") || token.equals("_")) {
                throw new ParserException("Wildcard variables no longer supported", this);
            }
            if (token.indexOf(58) != -1) {
                String prefix;
                String exp = this.prefixMapping.expandPrefix(token);
                if (!(exp != token || (prefix = token.substring(0, token.indexOf(58))).equals("http") || prefix.equals("urn") || prefix.equals("ftp") || prefix.equals("mailto"))) {
                    throw new ParserException("Unrecognized qname prefix (" + prefix + ") in rule", this);
                }
                return new URIImpl(exp);
            }
            if (this.peekToken().equals("(")) {
                Functor f = new Functor(token, this.parseValueList(), BuiltinRegistry.theRegistry);
                return Functor.makeFunctorValue(f);
            }
            if (token.equals("'") || token.equals("\"")) {
                String lit = this.nextToken();
                this.nextToken();
                if (this.peekToken().startsWith("^^")) {
                    String dtURI = this.nextToken().substring(2);
                    if (dtURI.startsWith("XMLSchema:")) {
                        dtURI = "http://www.w3.org/2001/XMLSchema##" + dtURI.substring(4);
                    }
                    URIImpl dt = new URIImpl(dtURI);
                    return new LiteralImpl(lit, (URI)dt);
                }
                return new LiteralImpl(lit);
            }
            if (Character.isDigit(token.charAt(0)) || token.charAt(0) == '-' && token.length() > 1 && Character.isDigit(token.charAt(1))) {
                return this.parseNumber(token);
            }
            return new URIImpl(token);
        }

        Value parseNumber(String lit) {
            if (Character.isDigit(lit.charAt(0)) || lit.charAt(0) == '-' && lit.length() > 1 && Character.isDigit(lit.charAt(1))) {
                if (lit.indexOf(".") != -1) {
                    try {
                        Float.parseFloat(lit);
                        return new LiteralImpl(lit, XMLSchema.FLOAT);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    try {
                        Integer.parseInt(lit);
                        return new LiteralImpl(lit, XMLSchema.INT);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return new LiteralImpl(lit);
        }

        List<Value> parseValueList() {
            String token = this.nextToken();
            if (!token.equals("(")) {
                throw new ParserException("Expected '(' at start of clause, found " + token, this);
            }
            token = this.nextToken();
            ArrayList<Value> ValueList = new ArrayList<Value>();
            while (!this.isSyntax(token)) {
                ValueList.add(this.parseValue(token));
                token = this.nextToken();
            }
            if (!token.equals(")")) {
                throw new ParserException("Expected ')' at end of clause, found " + token, this);
            }
            return ValueList;
        }

        ClauseEntry parseClause() {
            List<Value> args;
            String token = this.peekToken();
            if (token.equals("(")) {
                List<Value> Values = this.parseValueList();
                if (Values.size() != 3) {
                    throw new ParserException("Triple with " + Values.size() + " Values!", this);
                }
                if (Functor.isFunctor(Values.get(0))) {
                    throw new ParserException("Functors not allowed in subject position of pattern", this);
                }
                if (Functor.isFunctor(Values.get(1))) {
                    throw new ParserException("Functors not allowed in predicate position of pattern", this);
                }
                return new TriplePattern(Values.get(0), Values.get(1), Values.get(2));
            }
            if (token.equals("[")) {
                this.nextToken();
                return this.doParseRule(true);
            }
            String name = this.nextToken();
            Functor clause = new Functor(name, args = this.parseValueList(), BuiltinRegistry.theRegistry);
            if (clause.getImplementor() == null) {
                logger.warning("Rule references unimplemented functor: " + name);
            }
            return clause;
        }

        public Rule parseRule() {
            return this.doParseRule(false);
        }

        private Rule doParseRule(boolean retainVarMap) {
            try {
                if (this.peekToken().equals("[")) {
                    this.nextToken();
                }
                String name = null;
                String token = this.peekToken();
                if (token.endsWith(":")) {
                    name = token.substring(0, token.length() - 1);
                    this.nextToken();
                }
                if (!retainVarMap) {
                    this.varMap = new HashMap<String, Variable>();
                }
                ArrayList<ClauseEntry> body = new ArrayList<ClauseEntry>();
                token = this.peekToken();
                while (!token.equals("->") && !token.equals("<-")) {
                    body.add(this.parseClause());
                    token = this.peekToken();
                }
                boolean backwardRule = token.equals("<-");
                ArrayList<ClauseEntry> head = new ArrayList<ClauseEntry>();
                token = this.nextToken();
                token = this.peekToken();
                while (!token.equals(".") && !token.equals("]")) {
                    head.add(this.parseClause());
                    token = this.peekToken();
                }
                this.nextToken();
                Rule r = null;
                r = backwardRule ? new Rule(name, body, head) : new Rule(name, head, body);
                r.numVars = this.varMap.keySet().size();
                r.isBackward = backwardRule;
                return r;
            }
            catch (NoSuchElementException e) {
                throw new ParserException("Malformed rule", this);
            }
        }
    }

    public static class ParserException
    extends RuntimeException {
        public ParserException(String message, Parser parser) {
            super(ParserException.constructMessage(message, parser));
        }

        private static String constructMessage(String baseMessage, Parser parser) {
            StringBuffer message = new StringBuffer();
            message.append(baseMessage);
            message.append("\nAt '");
            message.append(parser.recentTokens());
            message.append("'");
            return message.toString();
        }
    }
}

