/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference.model;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.semanticdesktop.nepomuk.nrl.inference.model.ClauseEntry;
import org.semanticdesktop.nepomuk.nrl.inference.model.Functor;
import org.semanticdesktop.nepomuk.nrl.inference.model.Variable;

public class TriplePattern
implements ClauseEntry {
    protected Value subject;
    protected Value predicate;
    protected Value object;

    public TriplePattern(Value subject, Value predicate, Value object) {
        this.subject = TriplePattern.normalize(subject);
        this.predicate = TriplePattern.normalize(predicate);
        this.object = TriplePattern.normalize(object);
    }

    public TriplePattern(Statement match) {
        this.subject = TriplePattern.normalize((Value)match.getSubject());
        this.predicate = TriplePattern.normalize((Value)match.getPredicate());
        this.object = TriplePattern.normalize(match.getObject());
    }

    public Value getObject() {
        return this.object;
    }

    public Value getPredicate() {
        return this.predicate;
    }

    public Value getSubject() {
        return this.subject;
    }

    public Value getSubjectMatch() {
        return TriplePattern.toMatch(this.subject);
    }

    public Value getPredicateMatch() {
        return TriplePattern.toMatch(this.predicate);
    }

    public Value getObjectMatch() {
        return TriplePattern.toMatch(this.object);
    }

    public boolean compatibleWith(TriplePattern pattern) {
        boolean ok;
        boolean bl = ok = this.subject instanceof Variable || pattern.subject instanceof Variable || this.subject.equals(pattern.subject);
        if (!ok) {
            return false;
        }
        boolean bl2 = ok = this.predicate instanceof Variable || pattern.predicate instanceof Variable || this.predicate.equals(pattern.predicate);
        if (!ok) {
            return false;
        }
        if (this.object instanceof Variable || pattern.object instanceof Variable) {
            return true;
        }
        return this.object.equals(pattern.object);
    }

    public boolean variantOf(TriplePattern pattern) {
        HashMap vmap = new HashMap();
        if (!this.variantOf(this.subject, pattern.subject, vmap)) {
            return false;
        }
        if (!this.variantOf(this.predicate, pattern.predicate, vmap)) {
            return false;
        }
        return this.variantOf(this.object, pattern.object, vmap);
    }

    private boolean variantOf(Value n, Value p, Map vmap) {
        if (n instanceof Variable) {
            if (p instanceof Variable) {
                Object nMatch = vmap.get(n);
                if (nMatch == null) {
                    vmap.put(n, p);
                    return true;
                }
                return nMatch == p;
            }
            return false;
        }
        return n.equals(p);
    }

    public boolean isLegal() {
        if (this.subject instanceof Literal || this.predicate instanceof Literal) {
            return false;
        }
        if (Functor.isFunctor(this.subject)) {
            return false;
        }
        if (Functor.isFunctor(this.object)) {
            Value[] args = ((Functor)this.object).getArgs();
            int i = 0;
            while (i < args.length) {
                if (Functor.isFunctor(args[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean subsumes(TriplePattern arg) {
        return !(!(this.subject instanceof Variable) && !this.subject.equals(arg.subject) || !(this.predicate instanceof Variable) && !this.predicate.equals(arg.predicate) || !(this.object instanceof Variable) && !this.object.equals(arg.object));
    }

    public boolean isGround() {
        if (this.subject instanceof Variable || this.predicate instanceof Variable || this.object instanceof Variable) {
            return false;
        }
        if (Functor.isFunctor(this.object)) {
            return ((Functor)this.object).isGround();
        }
        return true;
    }

    public String toString() {
        return String.valueOf(TriplePattern.simplePrintString(this.subject)) + " @" + TriplePattern.simplePrintString(this.predicate) + " " + TriplePattern.simplePrintString(this.object);
    }

    public static String simplePrintString(Statement t) {
        return String.valueOf(TriplePattern.simplePrintString((Value)t.getSubject())) + " @" + TriplePattern.simplePrintString((Value)t.getPredicate()) + " " + TriplePattern.simplePrintString(t.getObject());
    }

    public static String simplePrintString(Value n) {
        if (n instanceof URI) {
            String uri = n.toString();
            int split = uri.lastIndexOf(35);
            if (split == -1 && (split = uri.lastIndexOf(47)) == -1) {
                split = -1;
            }
            String ns = uri.substring(0, split + 1);
            String prefix = "";
            if (ns.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                prefix = "rdf:";
            } else if (ns.equals("http://www.w3.org/2000/01/rdf-schema#")) {
                prefix = "rdfs:";
            }
            return String.valueOf(prefix) + uri.substring(split + 1);
        }
        return n.toString();
    }

    private static Value normalize(Value Value2) {
        if (Value2 == null) {
            return Variable.WILD;
        }
        return Value2;
    }

    private static Value toMatch(Value Value2) {
        return Value2 instanceof Variable ? null : Value2;
    }

    public boolean equals(Object o) {
        return o instanceof TriplePattern && this.ValueEqual(this.subject, ((TriplePattern)o).subject) && this.ValueEqual(this.predicate, ((TriplePattern)o).predicate) && this.ValueEqual(this.object, ((TriplePattern)o).object);
    }

    private boolean ValueEqual(Value n1, Value n2) {
        if (n1 instanceof Variable && n2 instanceof Variable) {
            return true;
        }
        return n1.equals(n2);
    }

    public int hashCode() {
        int hash = 0;
        if (!(this.subject instanceof Variable)) {
            hash ^= this.subject.hashCode() >> 1;
        }
        if (!(this.predicate instanceof Variable)) {
            hash ^= this.predicate.hashCode();
        }
        if (!(this.object instanceof Variable)) {
            hash ^= this.object.hashCode() << 1;
        }
        return hash;
    }

    public boolean sameAs(Object o) {
        if (!(o instanceof TriplePattern)) {
            return false;
        }
        TriplePattern other = (TriplePattern)o;
        return Variable.sameNodeAs(this.subject, other.subject) && Variable.sameNodeAs(this.predicate, other.predicate) && Variable.sameNodeAs(this.object, other.object);
    }
}

