/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtils {
    private static SimpleDateFormat dateFormat;

    public static <I, O> List<O> map(Collection<I> in, Mapper<O, I> m) {
        Vector<O> res = new Vector<O>(in.size());
        for (I i : in) {
            res.add(m.map(i));
        }
        return res;
    }

    public static <I, O> List<O> map(Iterator<I> in, Mapper<O, I> m) {
        Vector<O> res = new Vector<O>();
        while (in.hasNext()) {
            res.add(m.map(in.next()));
        }
        return res;
    }

    public static <I> List<I> filter(Collection<I> in, Filter<I> f) {
        Vector<I> res = new Vector<I>(in.size());
        for (I i : in) {
            if (!f.filter(i)) continue;
            res.add(i);
        }
        return res;
    }

    public static <C> List<String> listToStrings(Collection<C> list) {
        return JavaUtils.map(list, new Mapper<String, C>(){

            @Override
            public String map(C object) {
                return object.toString();
            }
        });
    }

    public static <K, C> Map<K, String> valuesToStrings(Map<K, C> list) {
        return JavaUtils.mapValues(list, new Mapper<String, C>(){

            @Override
            public String map(C object) {
                return object.toString();
            }
        });
    }

    public static <I, O, K> Map<K, O> mapValues(Map<K, I> in, Mapper<O, I> m) {
        HashMap<K, O> res = new HashMap<K, O>();
        for (Map.Entry<K, I> e : in.entrySet()) {
            res.put(e.getKey(), m.map(e.getValue()));
        }
        return res;
    }

    public static <C> List<C> stringsToList(List<String> list, Constructor cons) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Vector res = new Vector(list.size());
        for (String i : list) {
            res.add(cons.newInstance(i));
        }
        return res;
    }

    public static <C> List<C> stringsToList(List<String> list, Method cons) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Vector<Object> res = new Vector<Object>(list.size());
        for (String i : list) {
            res.add(cons.invoke(null, i));
        }
        return res;
    }

    public static String dateTime2String(Date date) {
        return JavaUtils.getDateFormat().format(date);
    }

    private static SimpleDateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
        }
        return dateFormat;
    }

    public static <C> String join(List<C> list, String delim) {
        StringBuffer buffer = new StringBuffer();
        Iterator<C> i = list.iterator();
        while (i.hasNext()) {
            buffer.append(i.next().toString());
            if (!i.hasNext()) continue;
            buffer.append(delim);
        }
        return buffer.toString();
    }

    public static <A, B> Map<A, List<B>> groupBy(List<B> list, Mapper<A, B> mapper) {
        HashMap res = new HashMap();
        for (B object : list) {
            A key = mapper.map(object);
            if (!res.containsKey(key)) {
                res.put(key, new Vector());
            }
            ((List)res.get(key)).add(object);
        }
        return res;
    }

    public static <A, B> Map<A, List<B>> groupBy(B[] list, Mapper<A, B> mapper) {
        HashMap res = new HashMap();
        B[] BArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            B object = BArray[n2];
            A key = mapper.map(object);
            if (!res.containsKey(key)) {
                res.put(key, new Vector());
            }
            ((List)res.get(key)).add(object);
            ++n2;
        }
        return res;
    }

    public static String trim(String target, String c) {
        return target.replaceAll("^(" + c + ")*|(" + c + ")*$", "");
    }

    public static String repeat(String s, int n) {
        StringBuffer res = new StringBuffer();
        while (n > 0) {
            res.append(s);
            --n;
        }
        return res.toString();
    }

    public static String titlecase(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1).toLowerCase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Counter<K, I>
    extends HashMap<K, Integer> {
        public void inc(K key, int i) {
            this.put(key, this.get(key, 0) + i);
        }

        public void inc(K key) {
            this.inc(key, 1);
        }

        public Integer get(K key, Integer def) {
            Integer r = (Integer)this.get(key);
            if (r == null) {
                return def;
            }
            return r;
        }

        public List<Map.Entry<K, Integer>> topN(int n) {
            Vector res = new Vector();
            res.addAll(this.entrySet());
            Collections.sort(res, new Comparator<Map.Entry<K, Integer>>(){

                @Override
                public int compare(Map.Entry<K, Integer> o1, Map.Entry<K, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            return res.subList(Math.max(res.size() - n, 0), res.size());
        }

        public int max() {
            return (Integer)Collections.max(this.values());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<A> {
        public boolean filter(A var1);
    }

    public static class FormatLogger
    extends Logger {
        public FormatLogger(String name) {
            super(name, null);
        }

        protected FormatLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
        }

        public void finef(String msg, Object ... args) {
            super.fine(String.format(msg, args));
        }

        public void finerf(String msg, Object ... args) {
            super.finer(String.format(msg, args));
        }

        public void finestf(String msg, Object ... args) {
            super.finest(String.format(msg, args));
        }

        public void infof(String msg, Object ... args) {
            super.info(String.format(msg, args));
        }

        public void severef(String msg, Object ... args) {
            super.severe(String.format(msg, args));
        }

        public void warningf(String msg, Object ... args) {
            super.warning(String.format(msg, args));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mapper<A, B> {
        public A map(B var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tree<C>
    implements Iterable<C> {
        C root;
        List<Tree<C>> children;

        public Tree(C root) {
            this.root = root;
            this.children = new Vector<Tree<C>>();
        }

        public Tree() {
            this.children = new Vector<Tree<C>>();
        }

        public C getRoot() {
            return this.root;
        }

        public void setRoot(C root) {
            this.root = root;
        }

        public Tree<C> addChild(C child) {
            Tree<C> t = new Tree<C>(child);
            this.children.add(t);
            return t;
        }

        public void addChildren(List<C> newchildren) {
            this.children.addAll(JavaUtils.map(newchildren, new Mapper<Tree<C>, C>(){

                @Override
                public Tree<C> map(C object) {
                    return new Tree(object);
                }
            }));
        }

        public void walk(Walker<C> m) {
            this.walk(m, 0);
        }

        private void walk(Walker<C> m, int depth) {
            m.visit(this.root, depth);
            for (Tree<C> t : this.children) {
                super.walk(m, depth + 1);
            }
        }

        public List<Tree<C>> getChildren() {
            return this.children;
        }

        public TreeIterator iterator() {
            return new TreeIterator(this);
        }

        public void addChild(Tree<C> tree) {
            this.children.add(tree);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeIterator<C>
    implements Iterator<C> {
        List<Tuple2<C, Integer>> nodes = new Vector<Tuple2<C, Integer>>();
        private Iterator<Tuple2<C, Integer>> it;
        private Tuple2<C, Integer> current;

        public TreeIterator(Tree<C> tree) {
            tree.walk(new Walker<C>(){

                @Override
                public void visit(C o, int d) {
                    TreeIterator.this.nodes.add(new Tuple2(o, d));
                }
            });
            this.it = this.nodes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public C next() {
            this.current = this.it.next();
            return (C)((Tuple2)this.current).one;
        }

        public int depth() {
            if (this.current == null) {
                return -1;
            }
            return (Integer)((Tuple2)this.current).two;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tuple2<C, T>
    extends AbstractList {
        private C one;
        private T two;

        public Tuple2(C one, T two) {
            this.one = one;
            this.two = two;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object get(int index) {
            if (index == 0) {
                return this.one;
            }
            if (index == 1) {
                return this.two;
            }
            throw new IndexOutOfBoundsException();
        }

        public C getOne() {
            return this.one;
        }

        public C one() {
            return this.one;
        }

        public T getTwo() {
            return this.two;
        }

        public T two() {
            return this.two;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Walker<B> {
        public void visit(B var1, int var2);
    }
}

