/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.nrl.inference.utils;

import com.sun.org.apache.xerces.internal.util.XMLChar;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.semanticdesktop.nepomuk.nrl.inference.exceptions.WrappedIOException;

public class Util {
    static Charset utf8 = null;

    static {
        try {
            utf8 = Charset.forName("utf-8");
        }
        catch (Throwable ex) {
            Logger.getLogger(Util.class.getName()).warning("Failed to get charset for UTF-8");
        }
    }

    public static int splitNamespace(String uri) {
        char ch;
        int lg = uri.length();
        if (lg == 0) {
            return 0;
        }
        int i = lg - 1;
        while (i >= 1) {
            ch = uri.charAt(i);
            if (Util.notNameChar(ch)) break;
            --i;
        }
        int j = i + 1;
        while (j < lg) {
            ch = uri.charAt(j);
            if (XMLChar.isNCNameStart(ch) && (uri.charAt(j - 1) != ':' || uri.lastIndexOf(58, j - 2) != -1)) break;
            ++j;
        }
        return j;
    }

    public static boolean notNameChar(char ch) {
        return !XMLChar.isNCName(ch);
    }

    public static BufferedReader readerFromURL(String urlStr) {
        try {
            return Util.asBufferedUTF8(new URL(urlStr).openStream());
        }
        catch (MalformedURLException e) {
            try {
                return Util.asBufferedUTF8(new FileInputStream(urlStr));
            }
            catch (FileNotFoundException f) {
                throw new WrappedIOException(f);
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    public static Reader asUTF8(InputStream in) {
        return new InputStreamReader(in, utf8.newDecoder());
    }

    public static BufferedReader asBufferedUTF8(InputStream in) {
        return new BufferedReader(Util.asUTF8(in));
    }
}

