/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailConnectionWrapper;
import org.semanticdesktop.nepomuk.nrl.inference.Reasoner;
import org.semanticdesktop.nepomuk.openrdf.InfSail;
import org.semanticdesktop.nepomuk.openrdf.UnionSailConnection;
import org.semanticdesktop.nepomuk.openrdf.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfSailConnection
extends SailConnectionWrapper {
    private HashMap<Resource, Set<Statement>> added;
    private HashMap<Resource, Set<Statement>> removed;
    private InfSail infsail;
    private UnionSailConnection unionconnection;

    public InfSailConnection(InfSail sail, SailConnection connection) throws SailException {
        super(connection);
        if (!(connection instanceof UnionSailConnection)) {
            throw new SailException("InfSailConnection must wrap a UnionSailConnection");
        }
        this.unionconnection = (UnionSailConnection)connection;
        this.infsail = sail;
        this.resetTxn();
    }

    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        super.addStatement(subj, pred, obj, contexts);
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource c = resourceArray[n2];
            this._add((Statement)new StatementImpl(subj, pred, obj), c);
            ++n2;
        }
    }

    private void _add(Statement s, Resource c) {
        if (this.added.containsKey(c)) {
            this.added.get(c).add(s);
        } else {
            HashSet<Statement> set = new HashSet<Statement>(1);
            set.add(s);
            this.added.put(c, set);
        }
    }

    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        super.removeStatements(subj, pred, obj, contexts);
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource c = resourceArray[n2];
            this._remove((Statement)new StatementImpl(subj, pred, obj), c);
            ++n2;
        }
    }

    private void _remove(Statement s, Resource c) {
        if (this.removed.containsKey(c)) {
            this.removed.get(c).add(s);
        } else {
            HashSet<Statement> set = new HashSet<Statement>(1);
            set.add(s);
            this.removed.put(c, set);
        }
    }

    public void clear(Resource ... contexts) throws SailException {
        super.clear(contexts);
    }

    public void commit() throws SailException {
        super.commit();
        HashMap nested = new HashMap();
        ConcurrentLinkedQueue<URI> todo = new ConcurrentLinkedQueue<URI>();
        todo.addAll((Collection)this.added.keySet());
        while (!todo.isEmpty()) {
            Resource context = (Resource)todo.poll();
            if (!this.infsail.hasView(context)) continue;
            URIImpl addedGraph = new URIImpl("temp://" + UUID.randomUUID());
            this.addBase((URI)addedGraph, (Collection<Statement>)this.added.get(context));
            super.commit();
            for (View view : this.infsail.getViews(context)) {
                HashSet<Statement> newStatements = new HashSet<Statement>();
                new Reasoner().applyRules(this, view.base, (URI)addedGraph, view, newStatements);
                if (!this.infsail.hasView((Resource)view.name)) continue;
                this.added.put((Resource)view.name, newStatements);
                todo.add(view.name);
            }
            super.clear(new Resource[]{addedGraph});
            super.commit();
        }
        for (Resource context : this.removed.keySet()) {
            if (!this.infsail.hasView(context)) continue;
            throw new SailException("Removing from inf-graphs is not supported :)");
        }
        this.resetTxn();
    }

    public void rollback() throws SailException {
        super.rollback();
        this.resetTxn();
    }

    private void resetTxn() {
        this.added = new HashMap();
        this.removed = new HashMap();
    }

    public void addBase(URI context, Collection<Statement> statements) throws SailException {
        for (Statement s : statements) {
            super.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{context});
        }
    }

    public void reinfer(URI baseGraph) throws SailException {
        if (this.infsail.hasView((Resource)baseGraph)) {
            for (View view : this.infsail.getViews((Resource)baseGraph)) {
                Reasoner r = new Reasoner();
                r.applyAxioms(this, view.base, view);
                r.applyRules(this, view.base, baseGraph, view);
            }
        }
    }

    public void baseCommit() throws SailException {
        super.commit();
    }

    public void addBase(URI context, Statement s) throws SailException {
        super.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{context});
    }

    public long realSize(Resource target) throws SailException {
        return this.unionconnection.realSize(target);
    }
}

