/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.SailException;
import org.semanticdesktop.nepomuk.nrl.inference.Rule;
import org.semanticdesktop.nepomuk.openrdf.InfSail;
import org.semanticdesktop.nepomuk.openrdf.InfSailConnection;
import org.semanticdesktop.nepomuk.openrdf.NrlGraphs;
import org.semanticdesktop.nepomuk.openrdf.SemanticViewSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View {
    private static final boolean DEBUG = false;
    URI base;
    public URI name;
    public List<Rule> rules;
    private Vector<URI> stratas;
    private SemanticViewSpecification viewSpec;
    private InfSail sail;

    public View(URI base, URI name, SemanticViewSpecification viewSpec, InfSail sail) {
        this.base = base;
        this.name = name;
        this.viewSpec = viewSpec;
        this.rules = viewSpec.getRules();
        this.sail = sail;
    }

    public List<URI> getStratas(InfSailConnection connection) throws SailException {
        if (this.stratas == null) {
            this.stratas = new Vector();
            CloseableIteration r = connection.getStatements((Resource)this.name, NrlGraphs.HAS_STRATA, null, false, new Resource[0]);
            while (r.hasNext()) {
                this.stratas.add((URI)((Statement)r.next()).getObject());
            }
            r.close();
        }
        return (List)this.stratas.clone();
    }

    public URI getStrata(InfSailConnection connection) throws SailException {
        if (this.stratas == null) {
            this.getStratas(connection);
        }
        URIImpl strata_name = new URIImpl(String.valueOf(this.name.toString()) + this.stratas.size());
        return strata_name;
    }

    public String toString() {
        return String.format("InfGraph(%s based on %s) [%s]", this.name, this.base, this.stratas);
    }

    public Collection<URI> getAllGraphs(InfSailConnection connection) throws SailException {
        List<URI> allStratas = this.getStratas(connection);
        allStratas.add(this.base);
        return allStratas;
    }

    public void addStrata(URI strata) throws SailException {
        this.stratas.add(strata);
        this.sail.addStrata(this.name, strata);
    }
}

