/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.cellreader;

import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.Setter;

public class DelayedCellSetterImpl<T, P>
implements DelayedCellSetter<T, P> {
    private P value;
    private final CellValueReader<? extends P> reader;
    private final Setter<? super T, ? super P> setter;

    public DelayedCellSetterImpl(Setter<? super T, ? super P> setter, CellValueReader<? extends P> reader) {
        this.setter = setter;
        this.reader = reader;
    }

    @Override
    public P consumeValue() {
        P val = this.value;
        this.value = null;
        return val;
    }

    @Override
    public P peekValue() {
        return this.value;
    }

    @Override
    public void set(T t) throws Exception {
        P val = this.consumeValue();
        this.setter.set(t, val);
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.value = this.reader.read(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "DelayedCellSetterImpl{reader=" + this.reader + ", setter=" + this.setter + '}';
    }
}

