/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.TextFormat;

public class UnescapeCellPreProcessor
extends CellPreProcessor {
    private final TextFormat textFormat;

    public UnescapeCellPreProcessor(TextFormat textFormat) {
        this.textFormat = textFormat;
    }

    @Override
    public final void newCell(char[] chars, int start, int end, CellConsumer cellConsumer, int state) {
        if ((state & 8) == 0) {
            cellConsumer.newCell(chars, start, end - start);
        } else {
            this.unescape(chars, start + 1, end, cellConsumer);
        }
    }

    private void unescape(char[] chars, int start, int end, CellConsumer cellConsumer) {
        char escapeChar = this.textFormat.escapeChar;
        for (int i = start; i < end - 1; ++i) {
            if (chars[i] != escapeChar) continue;
            int destIndex = i++;
            boolean escaped = true;
            while (i < end) {
                char c = chars[i];
                if (c != escapeChar || escaped) {
                    chars[destIndex++] = c;
                    escaped = false;
                } else {
                    escaped = true;
                }
                ++i;
            }
            cellConsumer.newCell(chars, start, destIndex - start);
            return;
        }
        int l = end - start;
        if (l > 0 && chars[end - 1] == escapeChar) {
            --l;
        }
        cellConsumer.newCell(chars, start, l);
    }

    @Override
    public final boolean ignoreLeadingSpace() {
        return false;
    }
}

