/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.simpleflatmapper.jdbc.impl.BatchQueryExecutor;
import org.simpleflatmapper.util.CheckedConsumer;

public class SizeAdjusterBatchQueryExecutor<T>
implements BatchQueryExecutor<T> {
    private final BatchQueryExecutor<T> delegate;
    private final AtomicInteger batchSize = new AtomicInteger(Integer.MAX_VALUE);

    public SizeAdjusterBatchQueryExecutor(BatchQueryExecutor<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void insert(Connection connection, Collection<T> values, CheckedConsumer<PreparedStatement> postExecute) throws SQLException {
        int lBatchSize = Math.min(this.batchSize.get(), values.size());
        try {
            if (values.size() <= lBatchSize) {
                this.delegate.insert(connection, values, postExecute);
            } else {
                this.splitBatches(connection, values, lBatchSize, postExecute);
            }
        }
        catch (SQLException e) {
            String name = e.getClass().getName();
            if (name.equals("com.mysql.jdbc.PacketTooBigException") || name.equals("com.mysql.cj.jdbc.exceptions.PacketTooBigException")) {
                if (lBatchSize <= 2) {
                    throw e;
                }
                this.resize(lBatchSize / 2);
                this.insert(connection, values, postExecute);
            }
            throw e;
        }
    }

    private void resize(int lBatchSize) {
        int currentSize;
        while (lBatchSize < (currentSize = this.batchSize.get()) && this.batchSize.compareAndSet(currentSize, lBatchSize)) {
        }
    }

    private void splitBatches(Connection connection, Collection<T> values, int lBatchSize, CheckedConsumer<PreparedStatement> postExecute) throws SQLException {
        int batchNumber = 0;
        Iterator<T> it = values.iterator();
        ArrayList list = new ArrayList(lBatchSize);
        do {
            this.fillList(lBatchSize, it, list);
            this.delegate.insert(connection, list, postExecute);
        } while (++batchNumber * lBatchSize < values.size());
    }

    private void fillList(int lBatchSize, Iterator<T> it, List<T> list) {
        list.clear();
        for (int i = 0; i < lBatchSize && it.hasNext(); ++i) {
            list.add(it.next());
        }
    }
}

