/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.sfm.csv.CellValueReader;
import org.sfm.csv.CellValueReaderFactory;
import org.sfm.csv.CsvColumnDefinition;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.CsvMapper;
import org.sfm.csv.ParsingContext;
import org.sfm.csv.ParsingContextFactory;
import org.sfm.csv.ParsingContextFactoryBuilder;
import org.sfm.csv.column.CustomReaderProperty;
import org.sfm.csv.impl.CellSetterFactory;
import org.sfm.csv.impl.CellValueReaderFactoryImpl;
import org.sfm.csv.impl.CsvMapperImpl;
import org.sfm.csv.impl.DelayedGetter;
import org.sfm.csv.impl.DelegateMarkerDelayedCellSetterFactory;
import org.sfm.csv.impl.DelegateMarkerSetter;
import org.sfm.csv.impl.IdentityCsvColumnDefinitionProvider;
import org.sfm.csv.mapper.CellSetter;
import org.sfm.csv.mapper.CsvMapperCellHandler;
import org.sfm.csv.mapper.CsvMapperCellHandlerFactory;
import org.sfm.csv.mapper.DelayedCellSetterFactory;
import org.sfm.map.GetterFactory;
import org.sfm.map.MapperBuildingException;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.DefaultDateFormatProperty;
import org.sfm.map.column.DefaultValueProperty;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.map.mapper.ColumnDefinitionProvider;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.map.mapper.PropertyMappingsBuilder;
import org.sfm.map.mapper.PropertyWithSetter;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorFactory;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.ConstructorPropertyMeta;
import org.sfm.reflect.meta.DirectClassMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.SubPropertyMeta;
import org.sfm.tuples.Tuple3;
import org.sfm.utils.BiConsumer;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.ForEachCallBack;
import org.sfm.utils.Named;
import org.sfm.utils.Predicate;

public class CsvMapperBuilder<T> {
    public static final CustomReaderProperty NONE_READER_PROPERTY = new CustomReaderProperty(new CellValueReader(){

        public Object read(char[] chars, int offset, int length, ParsingContext parsingContext) {
            throw new UnsupportedOperationException("Default value should not try to read");
        }
    });
    private final Type target;
    private final ReflectionService reflectionService;
    private final MapperConfig<CsvColumnKey, CsvColumnDefinition> mapperConfig;
    private final int minDelayedSetter;
    private final CellValueReaderFactory cellValueReaderFactory;
    private final PropertyMappingsBuilder<T, CsvColumnKey, CsvColumnDefinition> propertyMappingsBuilder;
    private String defaultDateFormat = "yyyy-MM-dd HH:mm:ss";

    public CsvMapperBuilder(Type target) {
        this(target, ReflectionService.newInstance());
    }

    public CsvMapperBuilder(Type target, ReflectionService reflectionService) {
        this(target, reflectionService.getClassMeta(target));
    }

    public CsvMapperBuilder(Type target, ClassMeta<T> classMeta) {
        this(target, classMeta, new IdentityCsvColumnDefinitionProvider());
    }

    public CsvMapperBuilder(Type target, ClassMeta<T> classMeta, ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey> columnDefinitionProvider) {
        this(target, classMeta, 0, new CellValueReaderFactoryImpl(), MapperConfig.config(columnDefinitionProvider));
    }

    public CsvMapperBuilder(Type target, ClassMeta<T> classMeta, int minDelayedSetter, CellValueReaderFactory cellValueReaderFactory, MapperConfig<CsvColumnKey, CsvColumnDefinition> mapperConfig) throws MapperBuildingException {
        this.target = target;
        this.minDelayedSetter = minDelayedSetter;
        this.reflectionService = classMeta.getReflectionService();
        this.propertyMappingsBuilder = new PropertyMappingsBuilder(classMeta, mapperConfig.propertyNameMatcherFactory(), mapperConfig.mapperBuilderErrorHandler(), new PropertyWithSetter());
        this.cellValueReaderFactory = cellValueReaderFactory;
        this.mapperConfig = mapperConfig;
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey) {
        return this.addMapping(columnKey, this.propertyMappingsBuilder.size());
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, int columnIndex) {
        return this.addMapping(new CsvColumnKey(columnKey, columnIndex), CsvColumnDefinition.identity());
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, CsvColumnDefinition columnDefinition) {
        return this.addMapping(columnKey, this.propertyMappingsBuilder.size(), columnDefinition);
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, int columnIndex, CsvColumnDefinition columnDefinition) {
        return this.addMapping(new CsvColumnKey(columnKey, columnIndex), columnDefinition);
    }

    public final CsvMapperBuilder<T> addMapping(CsvColumnKey key, CsvColumnDefinition columnDefinition) {
        CsvColumnDefinition composedDefinition = CsvColumnDefinition.compose(this.getColumnDefinition(key), columnDefinition);
        CsvColumnKey mappedColumnKey = composedDefinition.rename(key);
        this.propertyMappingsBuilder.addProperty(mappedColumnKey, composedDefinition);
        return this;
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, ColumnProperty ... properties) {
        return this.addMapping(columnKey, this.propertyMappingsBuilder.size(), properties);
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, int columnIndex, ColumnProperty ... properties) {
        return this.addMapping(new CsvColumnKey(columnKey, columnIndex), properties);
    }

    public final CsvMapperBuilder<T> addMapping(CsvColumnKey key, ColumnProperty ... properties) {
        return this.addMapping(key, CsvColumnDefinition.of(properties));
    }

    private <P> void addMapping(PropertyMeta<T, P> propertyMeta, CsvColumnKey key, CsvColumnDefinition columnDefinition) {
        this.propertyMappingsBuilder.addProperty(key, columnDefinition, propertyMeta);
    }

    private CsvColumnDefinition getColumnDefinition(CsvColumnKey key) {
        CsvColumnDefinition columnDefinition = this.mapperConfig.columnDefinitions().getColumnDefinition(key);
        return CsvColumnDefinition.compose(CsvColumnDefinition.of(new DefaultDateFormatProperty(this.defaultDateFormat)), columnDefinition);
    }

    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    public final CsvMapper<T> mapper() {
        this.mapperConfig.columnDefinitions().forEach(DefaultValueProperty.class, new BiConsumer<Predicate<? super CsvColumnKey>, DefaultValueProperty>(){

            @Override
            public void accept(Predicate<? super CsvColumnKey> predicate, DefaultValueProperty columnProperty) {
                if (CsvMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    return;
                }
                if (predicate instanceof Named) {
                    String name = ((Named)((Object)predicate)).getName();
                    CsvColumnDefinition columnDefinition = (CsvColumnDefinition)CsvColumnDefinition.identity().add(columnProperty, NONE_READER_PROPERTY);
                    CsvColumnKey key = new CsvColumnKey(name, CsvMapperBuilder.this.propertyMappingsBuilder.size());
                    CsvMapperBuilder.this.propertyMappingsBuilder.addPropertyIfPresent(key, columnDefinition);
                }
            }
        });
        ParsingContextFactoryBuilder parsingContextFactoryBuilder = new ParsingContextFactoryBuilder(this.propertyMappingsBuilder.maxIndex() + 1);
        Tuple3<Map<Parameter, Getter<CsvMapperCellHandler<T>, ?>>, Integer, Boolean> constructorParams = this.buildConstructorParametersDelayedCellSetter();
        Instantiator<CsvMapperCellHandler<T>, T> instantiator = this.getInstantiator((Map)constructorParams.first());
        CsvColumnKey[] keys = this.getKeys();
        CellSetter<T>[] setters = this.getSetters(parsingContextFactoryBuilder, (Integer)constructorParams.second());
        DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories = this.buildDelayedSetters(parsingContextFactoryBuilder, (Integer)constructorParams.second(), constructorParams.third());
        CsvMapperCellHandlerFactory<T> csvMapperCellHandlerFactory = this.newCsvMapperCellHandlerFactory(parsingContextFactoryBuilder, instantiator, keys, delayedCellSetterFactories, setters);
        return new CsvMapperImpl<T>(csvMapperCellHandlerFactory, delayedCellSetterFactories, setters, this.getJoinKeys(), this.mapperConfig.rowHandlerErrorHandler());
    }

    private CsvMapperCellHandlerFactory<T> newCsvMapperCellHandlerFactory(ParsingContextFactoryBuilder parsingContextFactoryBuilder, Instantiator<CsvMapperCellHandler<T>, T> instantiator, CsvColumnKey[] keys, DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories, CellSetter<T>[] setters) {
        ParsingContextFactory parsingContextFactory = parsingContextFactoryBuilder.newFactory();
        if (this.isEligibleForAsmHandler()) {
            try {
                return this.reflectionService.getAsmFactory().createCsvMapperCellHandler(this.target, delayedCellSetterFactories, setters, instantiator, keys, parsingContextFactory, this.mapperConfig.fieldMapperErrorHandler(), this.mapperConfig.maxMethodSize());
            }
            catch (Exception e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (CsvMapperCellHandlerFactory)ErrorHelper.rethrow(e);
                }
                return new CsvMapperCellHandlerFactory<T>(instantiator, keys, parsingContextFactory, this.mapperConfig.fieldMapperErrorHandler());
            }
        }
        return new CsvMapperCellHandlerFactory<T>(instantiator, keys, parsingContextFactory, this.mapperConfig.fieldMapperErrorHandler());
    }

    private boolean isEligibleForAsmHandler() {
        return this.reflectionService.hasAsmFactory() && this.propertyMappingsBuilder.size() < this.mapperConfig.asmMapperNbFieldsLimit();
    }

    private CsvColumnKey[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(new CsvColumnKey[0]);
    }

    private CsvColumnKey[] getJoinKeys() {
        final ArrayList keys = new ArrayList();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){

            @Override
            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> pm) {
                if (pm.getColumnDefinition().isKey() && pm.getColumnDefinition().keyAppliesTo().test(pm.getPropertyMeta())) {
                    keys.add(pm.getColumnKey());
                }
            }
        });
        return keys.toArray(new CsvColumnKey[0]);
    }

    private Instantiator<CsvMapperCellHandler<T>, T> getInstantiator(Map<Parameter, Getter<? super CsvMapperCellHandler<T>, ?>> params) throws MapperBuildingException {
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        try {
            return instantiatorFactory.getInstantiator(new TypeReference<CsvMapperCellHandler<T>>(){}.getType(), this.target, this.propertyMappingsBuilder, params, new GetterFactory<CsvMapperCellHandler<T>, CsvColumnKey>(){

                @Override
                public <P> Getter<CsvMapperCellHandler<T>, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                    return CsvMapperBuilder.this.newDelayedGetter(key, target, columnDefinition);
                }
            });
        }
        catch (Exception e) {
            return (Instantiator)ErrorHelper.rethrow(e);
        }
    }

    private Tuple3<Map<Parameter, Getter<? super CsvMapperCellHandler<T>, ?>>, Integer, Boolean> buildConstructorParametersDelayedCellSetter() {
        BuildConstructorInjections buildConstructorInjections = new BuildConstructorInjections();
        this.propertyMappingsBuilder.forEachProperties(buildConstructorInjections);
        return new Tuple3(buildConstructorInjections.constructorInjections, buildConstructorInjections.delayedSetterEnd, buildConstructorInjections.hasKeys);
    }

    private DelayedCellSetterFactory<T, ?>[] buildDelayedSetters(final ParsingContextFactoryBuilder parsingContextFactoryBuilder, int delayedSetterEnd, boolean hasKeys) {
        final HashMap delegateMapperBuilders = new HashMap();
        final HashMap propertyToMapperIndex = new HashMap();
        final DelayedCellSetterFactory[] delayedSetters = new DelayedCellSetterFactory[delayedSetterEnd];
        final int newMinDelayedSetter = this.minDelayedSetter != 0 ? this.minDelayedSetter : (hasKeys ? delayedSetterEnd : 0);
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){
            final CellSetterFactory cellSetterFactory;
            {
                this.cellSetterFactory = new CellSetterFactory(CsvMapperBuilder.this.cellValueReaderFactory, CsvMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler());
            }

            @Override
            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
                if (propMapping != null) {
                    PropertyMeta prop = propMapping.getPropertyMeta();
                    CsvColumnKey key = propMapping.getColumnKey();
                    if (prop != null) {
                        if (prop.isSubProperty()) {
                            this.addSubProperty(delegateMapperBuilders, prop, key, propMapping.getColumnDefinition());
                        } else {
                            delayedSetters[propMapping.getColumnKey().getIndex()] = this.cellSetterFactory.getDelayedCellSetter(prop, key.getIndex(), propMapping.getColumnDefinition(), parsingContextFactoryBuilder);
                        }
                    }
                }
            }

            private <I, P> void addSubProperty(Map<String, CsvMapperBuilder<?>> delegateMapperBuilders2, PropertyMeta<T, P> prop, CsvColumnKey key, CsvColumnDefinition columnDefinition) {
                Integer currentIndex;
                SubPropertyMeta subPropertyMeta = (SubPropertyMeta)prop;
                PropertyMeta propOwner = subPropertyMeta.getOwnerProperty();
                CsvMapperBuilder<Object> delegateMapperBuilder = delegateMapperBuilders2.get(propOwner.getName());
                if (delegateMapperBuilder == null) {
                    delegateMapperBuilder = new CsvMapperBuilder(propOwner.getPropertyType(), propOwner.getPropertyClassMeta(), newMinDelayedSetter, CsvMapperBuilder.this.cellValueReaderFactory, CsvMapperBuilder.this.mapperConfig);
                    delegateMapperBuilders2.put(propOwner.getName(), delegateMapperBuilder);
                }
                if ((currentIndex = (Integer)propertyToMapperIndex.get(propOwner.getName())) == null || currentIndex < key.getIndex()) {
                    propertyToMapperIndex.put(propOwner.getName(), key.getIndex());
                }
                ((CsvMapperBuilder)delegateMapperBuilder).addMapping(subPropertyMeta.getSubProperty(), key, columnDefinition);
            }
        }, 0, delayedSetterEnd);
        final HashMap mappers = new HashMap();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){

            @Override
            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
                if (propMapping == null) {
                    return;
                }
                PropertyMeta prop = propMapping.getPropertyMeta();
                if (prop.isSubProperty()) {
                    this.addSubPropertyDelayedSetter(delegateMapperBuilders, delayedSetters, propMapping.getColumnKey().getIndex(), prop);
                }
            }

            private <I, P> void addSubPropertyDelayedSetter(Map<String, CsvMapperBuilder<?>> delegateMapperBuilders2, DelayedCellSetterFactory<T, ?>[] delayedSetters2, int setterIndex, PropertyMeta<T, P> prop) {
                PropertyMeta subProp = ((SubPropertyMeta)prop).getOwnerProperty();
                String propName = subProp.getName();
                CsvMapper<?> mapper = (CsvMapper<?>)mappers.get(propName);
                if (mapper == null) {
                    CsvMapperBuilder<?> delegateMapperBuilder = delegateMapperBuilders2.get(propName);
                    mapper = delegateMapperBuilder.mapper();
                    mappers.put(propName, mapper);
                }
                int indexOfMapper = (Integer)propertyToMapperIndex.get(propName);
                Setter setter = null;
                if (!subProp.isConstructorProperty()) {
                    setter = subProp.getSetter();
                }
                delayedSetters2[setterIndex] = new DelegateMarkerDelayedCellSetterFactory(mapper, setter, setterIndex, indexOfMapper);
            }
        }, 0, delayedSetterEnd);
        return delayedSetters;
    }

    private CellSetter<T>[] getSetters(final ParsingContextFactoryBuilder parsingContextFactoryBuilder, final int delayedSetterEnd) {
        final HashMap delegateMapperBuilders = new HashMap();
        final HashMap propertyToMapperIndex = new HashMap();
        int maxIndex = this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){
            int maxIndex;
            {
                this.maxIndex = delayedSetterEnd;
            }

            @Override
            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
                if (propMapping != null) {
                    this.maxIndex = Math.max(propMapping.getColumnKey().getIndex(), this.maxIndex);
                    PropertyMeta prop = propMapping.getPropertyMeta();
                    if (prop != null) {
                        CsvColumnKey key = propMapping.getColumnKey();
                        if (prop.isConstructorProperty()) {
                            throw new IllegalStateException("Unexpected ConstructorPropertyMeta at " + key.getIndex());
                        }
                        if (prop.isSubProperty()) {
                            Integer currentIndex;
                            PropertyMeta propOwner = ((SubPropertyMeta)prop).getOwnerProperty();
                            CsvMapperBuilder delegateMapperBuilder = (CsvMapperBuilder)delegateMapperBuilders.get(propOwner.getName());
                            if (delegateMapperBuilder == null) {
                                delegateMapperBuilder = new CsvMapperBuilder(propOwner.getPropertyType(), propOwner.getPropertyClassMeta(), CsvMapperBuilder.this.minDelayedSetter, CsvMapperBuilder.this.cellValueReaderFactory, CsvMapperBuilder.this.mapperConfig);
                                delegateMapperBuilders.put(propOwner.getName(), delegateMapperBuilder);
                            }
                            if ((currentIndex = (Integer)propertyToMapperIndex.get(propOwner.getName())) == null || currentIndex < key.getIndex()) {
                                propertyToMapperIndex.put(propOwner.getName(), key.getIndex());
                            }
                            delegateMapperBuilder.addMapping(((SubPropertyMeta)prop).getSubProperty(), key, propMapping.getColumnDefinition());
                        }
                    }
                }
            }
        }, (int)delayedSetterEnd).maxIndex;
        final CellSetter[] setters = new CellSetter[maxIndex + 1 - delayedSetterEnd];
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){
            final Map<String, CsvMapperImpl<?>> mappers = new HashMap();
            final CellSetterFactory cellSetterFactory = new CellSetterFactory(CsvMapperBuilder.access$300(CsvMapperBuilder.this), CsvMapperBuilder.access$400(CsvMapperBuilder.this).mapperBuilderErrorHandler());

            @Override
            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
                DelegateMarkerSetter delegateMarkerSetter;
                if (propMapping == null) {
                    return;
                }
                PropertyMeta prop = propMapping.getPropertyMeta();
                if (prop == null || prop instanceof DirectClassMeta.DirectPropertyMeta) {
                    return;
                }
                setters[propMapping.getColumnKey().getIndex() - delayedSetterEnd] = prop instanceof SubPropertyMeta ? (delegateMarkerSetter = this.getDelegateMarkerSetter((SubPropertyMeta)prop)) : this.cellSetterFactory.getCellSetter(prop, propMapping.getColumnKey().getIndex(), propMapping.getColumnDefinition(), parsingContextFactoryBuilder);
            }

            private <I, P> DelegateMarkerSetter<T, I> getDelegateMarkerSetter(SubPropertyMeta<T, I, P> prop) {
                String propName = prop.getOwnerProperty().getName();
                CsvMapperImpl mapper = this.mappers.get(propName);
                if (mapper == null) {
                    CsvMapperBuilder delegateMapperBuilder = (CsvMapperBuilder)delegateMapperBuilders.get(propName);
                    mapper = (CsvMapperImpl)delegateMapperBuilder.mapper();
                    this.mappers.put(propName, mapper);
                }
                int indexOfMapper = (Integer)propertyToMapperIndex.get(propName);
                return new DelegateMarkerSetter(mapper, prop.getOwnerProperty().getSetter(), indexOfMapper);
            }
        }, delayedSetterEnd);
        return setters;
    }

    private <P> Getter<CsvMapperCellHandler<T>, P> newDelayedGetter(CsvColumnKey key, Type propertyType, ColumnDefinition<?, ?> columnDefinition) {
        CellSetterFactory cellSetterFactory = new CellSetterFactory(this.cellValueReaderFactory, this.mapperConfig.mapperBuilderErrorHandler());
        if (columnDefinition.has(DefaultValueProperty.class)) {
            return new DelayedGetter(key.getIndex());
        }
        return cellSetterFactory.newDelayedGetter(key, propertyType);
    }

    private class BuildConstructorInjections
    implements ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>> {
        final CellSetterFactory cellSetterFactory;
        private final Map<Parameter, Getter<? super CsvMapperCellHandler<T>, ?>> constructorInjections = new HashMap();
        int delayedSetterEnd;
        boolean hasKeys;

        public BuildConstructorInjections() {
            this.cellSetterFactory = new CellSetterFactory(CsvMapperBuilder.this.cellValueReaderFactory, CsvMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler());
            this.delayedSetterEnd = CsvMapperBuilder.this.minDelayedSetter;
        }

        @Override
        public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
            if (propMapping == null) {
                return;
            }
            PropertyMeta meta = propMapping.getPropertyMeta();
            boolean bl = this.hasKeys = this.hasKeys || propMapping.getColumnDefinition().isKey();
            if (meta == null) {
                return;
            }
            CsvColumnKey key = propMapping.getColumnKey();
            if (meta.isConstructorProperty()) {
                this.delayedSetterEnd = Math.max(this.delayedSetterEnd, key.getIndex() + 1);
                Getter delayedGetter = CsvMapperBuilder.this.newDelayedGetter(key, meta.getPropertyType(), propMapping.getColumnDefinition());
                this.constructorInjections.put(((ConstructorPropertyMeta)meta).getParameter(), delayedGetter);
            } else if (meta instanceof DirectClassMeta.DirectPropertyMeta) {
                this.delayedSetterEnd = Math.max(this.delayedSetterEnd, key.getIndex() + 1);
            } else if (meta.isSubProperty()) {
                SubPropertyMeta subMeta = (SubPropertyMeta)meta;
                if (subMeta.getOwnerProperty().isConstructorProperty()) {
                    ConstructorPropertyMeta constPropMeta = (ConstructorPropertyMeta)subMeta.getOwnerProperty();
                    Getter delayedGetter = this.cellSetterFactory.newDelayedGetter(key, constPropMeta.getPropertyType());
                    this.constructorInjections.put(constPropMeta.getParameter(), delayedGetter);
                    this.delayedSetterEnd = Math.max(this.delayedSetterEnd, key.getIndex() + 1);
                } else if (propMapping.getColumnDefinition().isKey() && propMapping.getColumnDefinition().keyAppliesTo().test(propMapping.getPropertyMeta()) || subMeta.getSubProperty() instanceof DirectClassMeta.DirectPropertyMeta) {
                    this.delayedSetterEnd = Math.max(this.delayedSetterEnd, key.getIndex() + 1);
                }
            } else if (propMapping.getColumnDefinition().isKey() && propMapping.getColumnDefinition().keyAppliesTo().test(propMapping.getPropertyMeta()) || propMapping.getColumnDefinition().has(DefaultValueProperty.class)) {
                this.delayedSetterEnd = Math.max(this.delayedSetterEnd, key.getIndex() + 1);
            }
        }
    }
}

