/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.sfm.csv.CloseableCsvReader;
import org.sfm.csv.CsvColumnDefinition;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.CsvMapper;
import org.sfm.csv.CsvMapperBuilder;
import org.sfm.csv.CsvReader;
import org.sfm.csv.impl.CsvColumnDefinitionProviderImpl;
import org.sfm.csv.impl.DynamicCsvMapper;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.csv.parser.CharBuffer;
import org.sfm.csv.parser.CharSequenceCharBuffer;
import org.sfm.csv.parser.ConfigurableCsvCharConsumer;
import org.sfm.csv.parser.ConfigurableTrimCsvCharConsumer;
import org.sfm.csv.parser.CsvCharConsumer;
import org.sfm.csv.parser.ReaderCharBuffer;
import org.sfm.csv.parser.StandardCsvCharConsumer;
import org.sfm.map.impl.CaseInsensitiveFieldKeyNamePredicate;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.tuples.Tuple2;
import org.sfm.tuples.Tuple3;
import org.sfm.tuples.Tuple4;
import org.sfm.tuples.Tuple5;
import org.sfm.tuples.Tuple6;
import org.sfm.tuples.Tuple7;
import org.sfm.tuples.Tuple8;
import org.sfm.tuples.Tuples;
import org.sfm.utils.CloseableIterator;
import org.sfm.utils.IOFunction;
import org.sfm.utils.Predicate;
import org.sfm.utils.RowHandler;

public final class CsvParser {
    private static final IOFunction<Reader, CloseableCsvReader> CREATE_CLOSEABLE_CSV_READER = new IOFunction<Reader, CloseableCsvReader>(){

        @Override
        public CloseableCsvReader apply(Reader reader) throws IOException {
            return new CloseableCsvReader(CsvParser.reader(reader), reader);
        }
    };
    private static final IOFunction<Reader, CloseableIterator<String[]>> CREATE_CLOSEABLE_ITERATOR = new IOFunction<Reader, CloseableIterator<String[]>>(){

        @Override
        public CloseableIterator<String[]> apply(Reader reader) throws IOException {
            return new CloseableIterator<String[]>(CsvParser.iterator(reader), reader);
        }
    };

    public static DSL separator(char c) {
        return CsvParser.dsl().separator(c);
    }

    public static DSL bufferSize(int size) {
        return CsvParser.dsl().bufferSize(size);
    }

    public static DSL maxBufferSize(int size) {
        return CsvParser.dsl().maxBufferSize(size);
    }

    public static DSL quote(char c) {
        return CsvParser.dsl().quote(c);
    }

    public static DSL skip(int skip) {
        return CsvParser.dsl().skip(skip);
    }

    public static DSL dsl() {
        return new DSL();
    }

    public static DSL limit(int limit) {
        return CsvParser.dsl().limit(limit);
    }

    public static <T> MapToDSL<T> mapTo(Type type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T> MapToDSL<T> mapTo(Class<T> type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T> MapToDSL<T> mapTo(TypeReference<T> type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T1, T2> MapToDSL<Tuple2<T1, T2>> mapTo(Class<T1> class1, Class<T2> class2) {
        return CsvParser.dsl().mapTo(class1, class2);
    }

    public static <T1, T2, T3> MapToDSL<Tuple3<T1, T2, T3>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3) {
        return CsvParser.dsl().mapTo(class1, class2, class3);
    }

    public static <T1, T2, T3, T4> MapToDSL<Tuple4<T1, T2, T3, T4>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4);
    }

    public static <T1, T2, T3, T4, T5> MapToDSL<Tuple5<T1, T2, T3, T4, T5>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5);
    }

    public static <T1, T2, T3, T4, T5, T6> MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6, class7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7, Class<T8> class8) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6, class7, class8);
    }

    public static <T> MapWithDSL<T> mapWith(CsvMapper<T> mapper) {
        return CsvParser.dsl().mapWith(mapper);
    }

    public static CsvReader reader(Reader reader) throws IOException {
        return CsvParser.dsl().reader(reader);
    }

    public static Iterator<String[]> iterator(Reader reader) throws IOException {
        return CsvParser.dsl().iterator(reader);
    }

    public static <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(reader, cellConsumer);
    }

    public static CsvReader reader(CharSequence content) throws IOException {
        return CsvParser.dsl().reader(content);
    }

    public static CsvReader reader(String content) throws IOException {
        return CsvParser.dsl().reader(content);
    }

    public static Iterator<String[]> iterator(CharSequence content) throws IOException {
        return CsvParser.dsl().iterator(content);
    }

    public static <CC extends CellConsumer> CC parse(CharSequence content, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(content, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(String content, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(content, cellConsumer);
    }

    public static CloseableCsvReader reader(File file) throws IOException {
        return CsvParser.dsl().reader(file);
    }

    public static CloseableIterator<String[]> iterator(File file) throws IOException {
        return CsvParser.dsl().iterator(file);
    }

    public static <CC extends CellConsumer> CC parse(File file, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(file, cellConsumer);
    }

    public static Stream<String[]> stream(Reader r) throws IOException {
        return CsvParser.dsl().stream(r);
    }

    public static Stream<String[]> stream(File file) throws IOException {
        return CsvParser.dsl().stream(file);
    }

    public static Stream<String[]> stream(String content) throws IOException {
        return CsvParser.dsl().stream(content);
    }

    private static <R> R onReader(File file, IOFunction<Reader, R> IOFunction2) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            return IOFunction2.apply(reader);
        }
        catch (IOException ioe) {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
    }

    public static class MapWithDSL<T> {
        private final DSL dsl;
        private final CsvMapper<T> mapper;

        public MapWithDSL(DSL dsl, CsvMapper<T> mapper) {
            this.dsl = dsl;
            this.mapper = mapper;
        }

        protected final DSL getDsl() {
            return this.dsl;
        }

        protected final CsvMapper<T> getMapper() {
            return this.mapper;
        }

        public final Iterator<T> iterator(Reader reader) throws IOException {
            return this.mapper.iterator(this.dsl.reader(reader));
        }

        public final Iterator<T> iterator(CharSequence content) throws IOException {
            return this.mapper.iterator(this.dsl.reader(content));
        }

        public final Iterator<T> iterator(String content) throws IOException {
            return this.mapper.iterator(this.dsl.reader(content));
        }

        public final CloseableIterator<T> iterator(File file) throws IOException {
            return (CloseableIterator)CsvParser.onReader(file, new IOFunction<Reader, CloseableIterator<T>>(){

                @Override
                public CloseableIterator<T> apply(Reader reader) throws IOException {
                    return new CloseableIterator(this.iterator(reader), reader);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <H extends RowHandler<T>> H forEach(File file, H rowHandler) throws IOException {
            FileReader reader = new FileReader(file);
            H h = this.forEach(reader, rowHandler);
            return h;
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }

        public final <H extends RowHandler<T>> H forEach(Reader reader, H rowHandler) throws IOException {
            return this.forEach(rowHandler, this.dsl.reader(reader));
        }

        public final <H extends RowHandler<T>> H forEach(CharSequence content, H rowHandler) throws IOException {
            return this.forEach(rowHandler, this.dsl.reader(content));
        }

        public final <H extends RowHandler<T>> H forEach(String content, H rowHandler) throws IOException {
            return this.forEach(rowHandler, this.dsl.reader(content));
        }

        private <H extends RowHandler<T>> H forEach(H rowHandler, CsvReader csvReader) throws IOException {
            if (this.dsl.limit == -1) {
                this.mapper.forEach(csvReader, rowHandler);
            } else {
                this.mapper.forEach(csvReader, rowHandler, this.dsl.limit);
            }
            return rowHandler;
        }

        public final Stream<T> stream(Reader reader) throws IOException {
            return this.mapper.stream(this.dsl.reader(reader));
        }

        public final Stream<T> stream(CharSequence content) throws IOException {
            return this.mapper.stream(this.dsl.reader(content));
        }

        public final Stream<T> stream(String content) throws IOException {
            return this.mapper.stream(this.dsl.reader(content));
        }

        public final Stream<T> stream(File file) throws IOException {
            return (Stream)CsvParser.onReader(file, new IOFunction<Reader, Stream<T>>(){

                @Override
                public Stream<T> apply(Reader reader) throws IOException {
                    return (Stream)this.stream(reader).onClose(() -> {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
            });
        }
    }

    public static final class StaticMapToDSL<T>
    extends MapWithDSL<T> {
        private final ClassMeta<T> classMeta;
        private final Type mapToClass;
        private final CsvColumnDefinitionProviderImpl columnDefinitionProvider;
        private final List<Tuple2<String, CsvColumnDefinition>> columns;

        private StaticMapToDSL(DSL dsl, ClassMeta<T> classMeta, Type mapToClass, List<Tuple2<String, CsvColumnDefinition>> columns, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, StaticMapToDSL.newStaticMapper(mapToClass, classMeta, columns, columnDefinitionProvider));
            this.classMeta = classMeta;
            this.mapToClass = mapToClass;
            this.columns = columns;
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        private static <T> CsvMapper<T> newStaticMapper(Type mapToClass, ClassMeta<T> classMeta, List<Tuple2<String, CsvColumnDefinition>> columns, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(mapToClass, classMeta, columnDefinitionProvider);
            for (Tuple2<String, CsvColumnDefinition> col : columns) {
                builder.addMapping(col.first(), col.second());
            }
            return builder.mapper();
        }

        public StaticMapToDSL<T> addMapping(String column) {
            return this.addMapping(column, CsvColumnDefinition.identity());
        }

        public StaticMapToDSL<T> addMapping(String column, CsvColumnDefinition columnDefinition) {
            ArrayList<Tuple2<String, CsvColumnDefinition>> newColumns = new ArrayList<Tuple2<String, CsvColumnDefinition>>(this.columns);
            newColumns.add(new Tuple2<String, CsvColumnDefinition>(column, columnDefinition));
            return new StaticMapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, newColumns, this.columnDefinitionProvider);
        }

        public StaticMapToDSL<T> addKey(String key) {
            return this.addMapping(key, CsvColumnDefinition.key());
        }
    }

    public static final class MapToDSL<T>
    extends MapWithDSL<T> {
        private final ClassMeta<T> classMeta;
        private final Type mapToClass;
        private final CsvColumnDefinitionProviderImpl columnDefinitionProvider;

        public MapToDSL(DSL dsl, Type mapToClass) {
            this(dsl, ReflectionService.newInstance().getClassMeta(mapToClass), mapToClass, new CsvColumnDefinitionProviderImpl());
        }

        private MapToDSL(DSL dsl, ClassMeta<T> classMeta, Type mapToClass, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, new DynamicCsvMapper<T>(mapToClass, classMeta, columnDefinitionProvider));
            this.mapToClass = mapToClass;
            this.classMeta = classMeta;
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        public StaticMapToDSL<T> headers(String ... headers) {
            return new StaticMapToDSL(this.getDsl(), this.classMeta, this.mapToClass, this.getColumnDefinitions(headers), this.columnDefinitionProvider);
        }

        public StaticMapToDSL<T> defaultHeaders() {
            return this.headers(this.classMeta.generateHeaders());
        }

        public StaticMapToDSL<T> overrideHeaders(String ... headers) {
            List<Tuple2<String, CsvColumnDefinition>> columns = this.getColumnDefinitions(headers);
            return new StaticMapToDSL(this.getDsl().skip(1), this.classMeta, this.mapToClass, columns, this.columnDefinitionProvider);
        }

        private List<Tuple2<String, CsvColumnDefinition>> getColumnDefinitions(String[] headers) {
            ArrayList<Tuple2<String, CsvColumnDefinition>> columns = new ArrayList<Tuple2<String, CsvColumnDefinition>>();
            for (String header : headers) {
                columns.add(new Tuple2<String, CsvColumnDefinition>(header, CsvColumnDefinition.identity()));
            }
            return columns;
        }

        public MapToDSL<T> columnDefinition(String column, CsvColumnDefinition columnDefinition) {
            return this.columnDefinition(new CaseInsensitiveFieldKeyNamePredicate(column), columnDefinition);
        }

        public MapToDSL<T> columnDefinition(Predicate<? super CsvColumnKey> predicate, CsvColumnDefinition columnDefinition) {
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, this.newColumnDefinitionProvider(predicate, columnDefinition));
        }

        public MapWithDSL<T> addKeys(String ... keys) {
            List<Tuple2<Predicate<? super CsvColumnKey>, CsvColumnDefinition>> definitions = this.columnDefinitionProvider.getDefinitions();
            for (String key : keys) {
                definitions.add(new Tuple2<CaseInsensitiveFieldKeyNamePredicate, CsvColumnDefinition>(new CaseInsensitiveFieldKeyNamePredicate(key), CsvColumnDefinition.key()));
            }
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, new CsvColumnDefinitionProviderImpl(definitions, this.columnDefinitionProvider.getProperties()));
        }

        private CsvColumnDefinitionProviderImpl newColumnDefinitionProvider(Predicate<? super CsvColumnKey> predicate, CsvColumnDefinition columnDefinition) {
            List<Tuple2<Predicate<? super CsvColumnKey>, CsvColumnDefinition>> definitions = this.columnDefinitionProvider.getDefinitions();
            definitions.add(new Tuple2<Predicate<? super CsvColumnKey>, CsvColumnDefinition>(predicate, columnDefinition));
            return new CsvColumnDefinitionProviderImpl(definitions, this.columnDefinitionProvider.getProperties());
        }

        public StaticMapToDSL<T> overrideWithDefaultHeaders() {
            return this.overrideHeaders(this.classMeta.generateHeaders());
        }

        public StaticMapToDSL<T> addMapping(String column) {
            return this.staticMapper().addMapping(column);
        }

        public StaticMapToDSL<T> addKey(String key) {
            return this.staticMapper().addKey(key);
        }

        public StaticMapToDSL<T> addMapping(String column, CsvColumnDefinition columnDefinition) {
            return this.staticMapper().addMapping(column, columnDefinition);
        }

        private StaticMapToDSL<T> staticMapper() {
            return new StaticMapToDSL(this.getDsl().skip(1), this.classMeta, this.mapToClass, Collections.emptyList(), this.columnDefinitionProvider);
        }
    }

    public static final class DSL {
        public static final int DEFAULT_MAX_BUFFER_SIZE_8M = 0x800000;
        public static final int DEFAULT_BUFFER_SIZE_4K = 4096;
        private final char separatorChar;
        private final char quoteChar;
        private final int bufferSize;
        private final int skip;
        private final int limit;
        private final int maxBufferSize;
        private final boolean trimSpaces;
        private final IOFunction<Reader, Stream<String[]>> CREATE_CLOSEABLE_STREAM = reader -> (Stream)this.stream((Reader)reader).onClose(() -> {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });

        private DSL() {
            this.separatorChar = (char)44;
            this.quoteChar = (char)34;
            this.bufferSize = 4096;
            this.skip = 0;
            this.limit = -1;
            this.maxBufferSize = 0x800000;
            this.trimSpaces = false;
        }

        public DSL(char separatorChar, char quoteChar, int bufferSize, int skip, int limit, int maxBufferSize, boolean trimSpaces) {
            this.separatorChar = separatorChar;
            this.quoteChar = quoteChar;
            this.bufferSize = bufferSize;
            this.skip = skip;
            this.limit = limit;
            this.maxBufferSize = maxBufferSize;
            this.trimSpaces = trimSpaces;
        }

        public DSL separator(char c) {
            return new DSL(c, this.quoteChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.trimSpaces);
        }

        public DSL quote(char c) {
            return new DSL(this.separatorChar, c, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.trimSpaces);
        }

        public DSL bufferSize(int size) {
            return new DSL(this.separatorChar, this.quoteChar, size, this.skip, this.limit, this.maxBufferSize, this.trimSpaces);
        }

        public DSL skip(int skip) {
            return new DSL(this.separatorChar, this.quoteChar, this.bufferSize, skip, this.limit, this.maxBufferSize, this.trimSpaces);
        }

        public DSL limit(int limit) {
            return new DSL(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, limit, this.maxBufferSize, this.trimSpaces);
        }

        public DSL maxBufferSize(int maxBufferSize) {
            return new DSL(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, this.limit, maxBufferSize, this.trimSpaces);
        }

        public DSL trimSpaces() {
            return new DSL(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, true);
        }

        public <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(reader), cellConsumer);
        }

        public <CC extends CellConsumer> CC parse(String content, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(content), cellConsumer);
        }

        public <CC extends CellConsumer> CC parse(CharSequence content, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(content), cellConsumer);
        }

        private <CC extends CellConsumer> CC parse(CharBuffer charBuffer, CC cellConsumer) throws IOException {
            CsvReader csvreader = this.reader(charBuffer);
            if (this.limit == -1) {
                return csvreader.parseAll(cellConsumer);
            }
            return csvreader.parseRows(cellConsumer, this.limit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <CC extends CellConsumer> CC parse(File file, CC cellConsumer) throws IOException {
            FileReader reader = new FileReader(file);
            CC CC = this.parse(reader, cellConsumer);
            return CC;
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }

        public CsvReader reader(Reader reader) throws IOException {
            return this.reader(this.charBuffer(reader));
        }

        public CsvReader reader(CharSequence content) throws IOException {
            return this.reader(this.charBuffer(content));
        }

        public CsvReader reader(String content) throws IOException {
            return this.reader(this.charBuffer(content));
        }

        private CsvReader reader(CharBuffer charBuffer) throws IOException {
            CsvReader csvReader = new CsvReader(this.charConsumer(charBuffer));
            csvReader.skipRows(this.skip);
            return csvReader;
        }

        private CharBuffer charBuffer(Reader reader) throws IOException {
            return new ReaderCharBuffer(this.bufferSize, this.maxBufferSize, reader);
        }

        private CharBuffer charBuffer(CharSequence content) throws IOException {
            return new CharSequenceCharBuffer(content);
        }

        private CharBuffer charBuffer(String content) throws IOException {
            return new CharSequenceCharBuffer(content);
        }

        public CloseableCsvReader reader(File file) throws IOException {
            return (CloseableCsvReader)CsvParser.onReader(file, CREATE_CLOSEABLE_CSV_READER);
        }

        public Iterator<String[]> iterator(Reader reader) throws IOException {
            return this.reader(reader).iterator();
        }

        public Iterator<String[]> iterator(CharSequence content) throws IOException {
            return this.reader(content).iterator();
        }

        public Iterator<String[]> iterator(String content) throws IOException {
            return this.reader(content).iterator();
        }

        public CloseableIterator<String[]> iterator(File file) throws IOException {
            return (CloseableIterator)CsvParser.onReader(file, CREATE_CLOSEABLE_ITERATOR);
        }

        public <T> MapToDSL<T> mapTo(Type target) {
            return new MapToDSL(this, target);
        }

        public <T> MapToDSL<T> mapTo(Class<T> target) {
            return this.mapTo((Type)target);
        }

        public <T> MapToDSL<T> mapTo(TypeReference<T> target) {
            return this.mapTo(target.getType());
        }

        public <T1, T2> MapToDSL<Tuple2<T1, T2>> mapTo(Class<T1> class1, Class<T2> class2) {
            return new MapToDSL<Tuple2<T1, T2>>(this, Tuples.typeDef(class1, class2));
        }

        public <T1, T2, T3> MapToDSL<Tuple3<T1, T2, T3>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3) {
            return new MapToDSL<Tuple3<T1, T2, T3>>(this, Tuples.typeDef(class1, class2, class3));
        }

        public <T1, T2, T3, T4> MapToDSL<Tuple4<T1, T2, T3, T4>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4) {
            return new MapToDSL<Tuple4<T1, T2, T3, T4>>(this, Tuples.typeDef(class1, class2, class3, class4));
        }

        public <T1, T2, T3, T4, T5> MapToDSL<Tuple5<T1, T2, T3, T4, T5>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5) {
            return new MapToDSL<Tuple5<T1, T2, T3, T4, T5>>(this, Tuples.typeDef(class1, class2, class3, class4, class5));
        }

        public <T1, T2, T3, T4, T5, T6> MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6) {
            return new MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>>(this, Tuples.typeDef(class1, class2, class3, class4, class5, class6));
        }

        public <T1, T2, T3, T4, T5, T6, T7> MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7) {
            return new MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>>(this, Tuples.typeDef(class1, class2, class3, class4, class5, class6, class7));
        }

        public <T1, T2, T3, T4, T5, T6, T7, T8> MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7, Class<T8> class8) {
            return new MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>>(this, Tuples.typeDef(class1, class2, class3, class4, class5, class6, class7, class8));
        }

        public <T> MapWithDSL<T> mapWith(CsvMapper<T> mapper) {
            return new MapWithDSL<T>(this, mapper);
        }

        public Stream<String[]> stream(Reader reader) throws IOException {
            return this.reader(reader).stream();
        }

        public Stream<String[]> stream(CharSequence content) throws IOException {
            return this.reader(content).stream();
        }

        public Stream<String[]> stream(String content) throws IOException {
            return this.reader(content).stream();
        }

        public Stream<String[]> stream(File file) throws IOException {
            return (Stream)CsvParser.onReader(file, this.CREATE_CLOSEABLE_STREAM);
        }

        private CsvCharConsumer charConsumer(CharBuffer charBuffer) throws IOException {
            if (this.isStandardConsumer()) {
                return new StandardCsvCharConsumer(charBuffer);
            }
            if (!this.trimSpaces) {
                return new ConfigurableCsvCharConsumer(charBuffer, this.separatorChar, this.quoteChar);
            }
            return new ConfigurableTrimCsvCharConsumer(charBuffer, this.separatorChar, this.quoteChar);
        }

        private boolean isStandardConsumer() {
            return this.separatorChar == ',' && this.quoteChar == '\"' && !this.trimSpaces;
        }

        public int maxBufferSize() {
            return this.maxBufferSize;
        }

        public int bufferSize() {
            return this.bufferSize;
        }

        public int limit() {
            return this.limit;
        }

        public int skip() {
            return this.skip;
        }

        public char separator() {
            return this.separatorChar;
        }

        public char quote() {
            return this.quoteChar;
        }
    }
}

