/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.Format;
import java.util.Arrays;
import org.sfm.csv.CellWriter;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.CsvWriterBuilder;
import org.sfm.csv.impl.writer.CsvCellWriter;
import org.sfm.csv.mapper.FieldMapperToAppendableFactory;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.MappingContext;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.column.FormatProperty;
import org.sfm.map.mapper.ContextualMapper;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.tuples.Tuple2;
import org.sfm.utils.ErrorHelper;

public class CsvWriter<T> {
    private final Mapper<T, Appendable> mapper;
    private final Appendable appendable;
    private final MappingContext<T> mappingContext;

    private CsvWriter(Mapper<T, Appendable> mapper, Appendable appendable, MappingContext<T> mappingContext) {
        this.mapper = mapper;
        this.appendable = appendable;
        this.mappingContext = mappingContext;
    }

    public CsvWriter<T> append(T value) throws IOException {
        try {
            this.mapper.mapTo((Appendable)value, this.appendable, (MappingContext<Appendable>)this.mappingContext);
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
        }
        return this;
    }

    public static <T> CsvWriterDSL<T> from(Class<T> type) {
        return CsvWriter.from(type);
    }

    public static <T> CsvWriterDSL<T> from(TypeReference<T> typeReference) {
        return CsvWriter.from(typeReference.getType());
    }

    public static <T> CsvWriterDSL<T> from(Type type) {
        ClassMeta classMeta = ReflectionService.newInstance().getClassMeta(type);
        CsvCellWriter cellWriter = CsvCellWriter.DEFAULT_WRITER;
        CsvWriterBuilder builder = CsvWriterBuilder.newBuilder(classMeta, cellWriter);
        MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig = MapperConfig.fieldMapperConfig();
        try {
            builder.defaultHeaders();
            ContextualMapper mapper = (ContextualMapper)builder.mapper();
            return new DefaultCsvWriterDSL(CsvWriter.toColumnDefinitions(classMeta.generateHeaders()), cellWriter, mapper, classMeta, mapperConfig, false);
        }
        catch (UnsupportedOperationException e) {
            return new NoColumnCsvWriterDSL(cellWriter, classMeta, mapperConfig, false);
        }
    }

    private static <T> Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] toColumnDefinitions(String[] header) {
        Tuple2[] columnDefinitions = new Tuple2[header.length];
        int offset = 0;
        return CsvWriter.toColumnDefinitions(header, columnDefinitions, offset);
    }

    private static Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] toColumnDefinitions(String[] header, Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columnDefinitions, int offset) {
        FieldMapperColumnDefinition identity = FieldMapperColumnDefinition.identity();
        for (int i = 0; i < header.length; ++i) {
            columnDefinitions[i + offset] = new Tuple2(header[i], identity);
        }
        return columnDefinitions;
    }

    public static class DefaultCsvWriterDSL<T>
    extends CsvWriterDSL<T> {
        private DefaultCsvWriterDSL(Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            super(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }

        @Override
        public CsvWriterDSL<T> columns(String ... columnNames) {
            return this.newColumnMapDSL(this.classMeta, CsvWriter.toColumnDefinitions(columnNames), this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        @Override
        public CsvWriterDSL<T> column(String column, ColumnProperty ... property) {
            Tuple2[] newColumns = new Tuple2[1];
            FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(property);
            newColumns[0] = new Tuple2<String, FieldMapperColumnDefinition>(column, columnDefinition);
            return this.newColumnMapDSL(this.classMeta, newColumns, this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        @Override
        protected CsvWriterDSL<T> newCsvWriterDSL(Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            return new DefaultCsvWriterDSL<T>(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }
    }

    public static class NoColumnCsvWriterDSL<T>
    extends CsvWriterDSL<T> {
        public NoColumnCsvWriterDSL(CellWriter cellWriter, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            super(new Tuple2[0], cellWriter, null, classMeta, mapperConfig, skipHeaders);
        }

        @Override
        public CsvWriter<T> to(Appendable appendable) throws IOException {
            throw new IllegalStateException("No columned defined");
        }

        @Override
        protected NoColumnCsvWriterDSL<T> newCsvWriterDSL(Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            return new NoColumnCsvWriterDSL<T>(cellWriter, classMeta, mapperConfig, skipHeaders);
        }
    }

    public static class CsvWriterDSL<T> {
        protected final Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columns;
        protected final ContextualMapper<T, Appendable> mapper;
        protected final CellWriter cellWriter;
        protected final ClassMeta<T> classMeta;
        protected final MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig;
        protected final boolean skipHeaders;

        private CsvWriterDSL(Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            this.columns = columns;
            this.mapper = mapper;
            this.cellWriter = cellWriter;
            this.classMeta = classMeta;
            this.mapperConfig = mapperConfig;
            this.skipHeaders = skipHeaders;
        }

        public CsvWriter<T> to(Appendable appendable) throws IOException {
            if (!this.skipHeaders) {
                this.addHeaders(appendable);
            }
            return new CsvWriter(this.mapper, appendable, this.mapper.newMappingContext());
        }

        private void addHeaders(Appendable appendable) throws IOException {
            for (int i = 0; i < this.columns.length; ++i) {
                if (i != 0) {
                    this.cellWriter.nextCell(appendable);
                }
                this.cellWriter.writeValue(this.columns[i].first(), appendable);
            }
            this.cellWriter.endOfRow(appendable);
        }

        public CsvWriterDSL<T> columns(String ... columnNames) {
            Tuple2[] newColumns = Arrays.copyOf(this.columns, this.columns.length + columnNames.length);
            CsvWriter.toColumnDefinitions(columnNames, newColumns, this.columns.length);
            return this.newColumnMapDSL(this.classMeta, newColumns, this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> column(String column, ColumnProperty ... property) {
            Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] newColumns = Arrays.copyOf(this.columns, this.columns.length + 1);
            FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(property);
            newColumns[this.columns.length] = new Tuple2<String, FieldMapperColumnDefinition>(column, columnDefinition);
            return this.newColumnMapDSL(this.classMeta, newColumns, this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> column(String column, Format format) {
            return this.column(column, new FormatProperty(format));
        }

        public CsvWriterDSL<T> classMeta(ClassMeta<T> classMeta) {
            return this.newMapDSL(classMeta, this.columns, this.mapperConfig, this.cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> mapperConfig(MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig) {
            return this.newMapDSL(this.classMeta, this.columns, mapperConfig, this.cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> cellWriter(CellWriter cellWriter) {
            return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, cellWriter, this.skipHeaders);
        }

        public CsvWriterDSL<T> separator(char separator) {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).separator(separator), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> quote(char quote) {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).quote(quote), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> endOfLine(String endOfLine) {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).endOfLine(endOfLine), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> alwaysEscape() {
            if (this.cellWriter instanceof CsvCellWriter) {
                return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, ((CsvCellWriter)this.cellWriter).alwaysEscape(), this.skipHeaders);
            }
            throw new IllegalStateException("Custom cell writer set, cannot use schema to alter it");
        }

        public CsvWriterDSL<T> skipHeaders() {
            return this.newMapDSL(this.classMeta, this.columns, this.mapperConfig, this.cellWriter, true);
        }

        public MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig() {
            return this.mapperConfig;
        }

        protected CsvWriterDSL<T> newColumnMapDSL(ClassMeta<T> classMeta, Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columns, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, CellWriter cellWriter, boolean skipHeaders) {
            CsvWriterBuilder<T> builder = new CsvWriterBuilder<T>(classMeta, mapperConfig, new FieldMapperToAppendableFactory(cellWriter), cellWriter);
            for (Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>> col : columns) {
                builder.addColumn(col.first(), col.second());
            }
            ContextualMapper mapper = (ContextualMapper)builder.mapper();
            return new CsvWriterDSL<T>(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }

        protected CsvWriterDSL<T> newMapDSL(ClassMeta<T> classMeta, Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columns, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, CellWriter cellWriter, boolean skipHeaders) {
            CsvWriterBuilder<T> builder = new CsvWriterBuilder<T>(classMeta, mapperConfig, new FieldMapperToAppendableFactory(cellWriter), cellWriter);
            for (Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>> col : columns) {
                builder.addColumn(col.first(), col.second());
            }
            ContextualMapper mapper = (ContextualMapper)builder.mapper();
            return this.newCsvWriterDSL(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }

        protected CsvWriterDSL<T> newCsvWriterDSL(Tuple2<String, FieldMapperColumnDefinition<CsvColumnKey>>[] columns, CellWriter cellWriter, ContextualMapper<T, Appendable> mapper, ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, boolean skipHeaders) {
            return new CsvWriterDSL<T>(columns, cellWriter, mapper, classMeta, mapperConfig, skipHeaders);
        }
    }
}

