/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.util.List;
import org.sfm.csv.CellWriter;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.impl.writer.CellSeparatorAppender;
import org.sfm.csv.impl.writer.CsvCellWriter;
import org.sfm.csv.impl.writer.EndOfRowAppender;
import org.sfm.csv.mapper.FieldMapperToAppendableFactory;
import org.sfm.map.AbstractWriterBuilder;
import org.sfm.map.FieldMapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactory;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.meta.ClassMeta;

public class CsvWriterBuilder<T>
extends AbstractWriterBuilder<Appendable, T, CsvColumnKey, CsvWriterBuilder<T>> {
    private final CellWriter cellWriter;
    private final CellSeparatorAppender<T> cellSeparatorAppender;

    public CsvWriterBuilder(ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> mapperConfig, ConstantTargetFieldMapperFactory<Appendable, CsvColumnKey> fieldAppenderFactory, CellWriter cellWriter) {
        super(classMeta, Appendable.class, mapperConfig, fieldAppenderFactory);
        this.cellWriter = cellWriter;
        this.cellSeparatorAppender = new CellSeparatorAppender(cellWriter);
    }

    public CsvWriterBuilder<T> defaultHeaders() {
        for (String column : this.classMeta.generateHeaders()) {
            this.addColumn(column);
        }
        return this;
    }

    public static <T> CsvWriterBuilder<T> newBuilder(Class<T> clazz) {
        ClassMeta<T> classMeta = ReflectionService.newInstance().getClassMeta(clazz);
        return CsvWriterBuilder.newBuilder(classMeta);
    }

    public static <T> CsvWriterBuilder<T> newBuilder(ClassMeta<T> classMeta) {
        return CsvWriterBuilder.newBuilder(classMeta, CsvCellWriter.DEFAULT_WRITER);
    }

    public static <T> CsvWriterBuilder<T> newBuilder(ClassMeta<T> classMeta, CellWriter cellWriter) {
        MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> config = MapperConfig.fieldMapperConfig();
        FieldMapperToAppendableFactory appenderFactory = new FieldMapperToAppendableFactory(cellWriter);
        CsvWriterBuilder<T> builder = new CsvWriterBuilder<T>(classMeta, config, appenderFactory, cellWriter);
        return builder;
    }

    @Override
    protected Instantiator<T, Appendable> getInstantiator() {
        return new AppendableInstantiator();
    }

    @Override
    protected CsvColumnKey newKey(String column, int i, FieldMapperColumnDefinition<CsvColumnKey> columnDefinition) {
        return new CsvColumnKey(column, i);
    }

    @Override
    protected void preFieldProcess(List<FieldMapper<T, Appendable>> fieldMappers, PropertyMapping<T, ?, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> pm) {
        if (pm.getColumnKey().getIndex() > 0) {
            fieldMappers.add(this.cellSeparatorAppender);
        }
    }

    @Override
    protected void postMapperProcess(List<FieldMapper<T, Appendable>> fieldMappers) {
        fieldMappers.add(new EndOfRowAppender(this.cellWriter));
    }

    private static class AppendableInstantiator<T>
    implements Instantiator<T, Appendable> {
        private AppendableInstantiator() {
        }

        @Override
        public Appendable newInstance(T o) throws Exception {
            return new StringBuilder();
        }
    }
}

