/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl;

import java.lang.reflect.Type;
import java.util.Date;
import org.sfm.csv.CellValueReader;
import org.sfm.csv.CellValueReaderFactory;
import org.sfm.csv.CsvColumnDefinition;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.ParsingContextFactoryBuilder;
import org.sfm.csv.impl.DelayedGetter;
import org.sfm.csv.impl.InstantiatorOnReader;
import org.sfm.csv.impl.cellreader.BooleanCellValueReader;
import org.sfm.csv.impl.cellreader.BoxedBooleanCellValueReader;
import org.sfm.csv.impl.cellreader.BoxedByteCellValueReader;
import org.sfm.csv.impl.cellreader.BoxedCharCellValueReader;
import org.sfm.csv.impl.cellreader.BoxedDoubleCellValueReader;
import org.sfm.csv.impl.cellreader.BoxedFloatCellValueReader;
import org.sfm.csv.impl.cellreader.BoxedIntegerCellValueReader;
import org.sfm.csv.impl.cellreader.BoxedLongCellValueReader;
import org.sfm.csv.impl.cellreader.BoxedShortCellValueReader;
import org.sfm.csv.impl.cellreader.ByteCellValueReader;
import org.sfm.csv.impl.cellreader.CellSetterImpl;
import org.sfm.csv.impl.cellreader.CharCellValueReader;
import org.sfm.csv.impl.cellreader.DefaultValueDelayedCallSetterFactory;
import org.sfm.csv.impl.cellreader.DelayedCellSetterFactoryImpl;
import org.sfm.csv.impl.cellreader.DoubleCellValueReader;
import org.sfm.csv.impl.cellreader.FloatCellValueReader;
import org.sfm.csv.impl.cellreader.IntegerCellValueReader;
import org.sfm.csv.impl.cellreader.LongCellValueReader;
import org.sfm.csv.impl.cellreader.ShortCellValueReader;
import org.sfm.csv.impl.primitive.BooleanCellSetter;
import org.sfm.csv.impl.primitive.BooleanDelayedCellSetterFactory;
import org.sfm.csv.impl.primitive.BooleanDelayedGetter;
import org.sfm.csv.impl.primitive.ByteCellSetter;
import org.sfm.csv.impl.primitive.ByteDelayedCellSetterFactory;
import org.sfm.csv.impl.primitive.ByteDelayedGetter;
import org.sfm.csv.impl.primitive.CharCellSetter;
import org.sfm.csv.impl.primitive.CharDelayedCellSetterFactory;
import org.sfm.csv.impl.primitive.CharDelayedGetter;
import org.sfm.csv.impl.primitive.DoubleCellSetter;
import org.sfm.csv.impl.primitive.DoubleDelayedCellSetterFactory;
import org.sfm.csv.impl.primitive.DoubleDelayedGetter;
import org.sfm.csv.impl.primitive.FloatCellSetter;
import org.sfm.csv.impl.primitive.FloatDelayedCellSetterFactory;
import org.sfm.csv.impl.primitive.FloatDelayedGetter;
import org.sfm.csv.impl.primitive.IntCellSetter;
import org.sfm.csv.impl.primitive.IntDelayedCellSetterFactory;
import org.sfm.csv.impl.primitive.IntDelayedGetter;
import org.sfm.csv.impl.primitive.LongCellSetter;
import org.sfm.csv.impl.primitive.LongDelayedCellSetterFactory;
import org.sfm.csv.impl.primitive.LongDelayedGetter;
import org.sfm.csv.impl.primitive.ShortCellSetter;
import org.sfm.csv.impl.primitive.ShortDelayedCellSetterFactory;
import org.sfm.csv.impl.primitive.ShortDelayedGetter;
import org.sfm.csv.mapper.CellSetter;
import org.sfm.csv.mapper.CsvMapperCellHandler;
import org.sfm.csv.mapper.DelayedCellSetterFactory;
import org.sfm.map.MapperBuilderErrorHandler;
import org.sfm.map.column.DefaultValueProperty;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.InstantiatorDefinitions;
import org.sfm.reflect.ObjectSetterFactory;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.Setter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.impl.NullSetter;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.DefaultPropertyNameMatcher;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.utils.ErrorDoc;

public final class CellSetterFactory {
    public static final InstantiatorDefinitions.CompatibilityScorer COMPATIBILITY_SCORER = new InstantiatorDefinitions.CompatibilityScorer(){

        @Override
        public int score(InstantiatorDefinition id) {
            Class<?> type = TypeHelper.toBoxedClass(id.getParameters()[0].getType());
            if (type == String.class || type == CharSequence.class) {
                return 10;
            }
            if (Number.class.isAssignableFrom(type)) {
                return 9;
            }
            if (Date.class.isAssignableFrom(type)) {
                return 8;
            }
            return 0;
        }
    };
    private final CellValueReaderFactory cellValueReaderFactory;
    private final MapperBuilderErrorHandler mapperBuilderErrorHandler;

    public CellSetterFactory(CellValueReaderFactory cellValueReaderFactory, MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        this.cellValueReaderFactory = cellValueReaderFactory;
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
    }

    public <T, P> CellSetter<T> getPrimitiveCellSetter(Class<?> clazz, CellValueReader<? extends P> reader, Setter<T, ? super P> setter) {
        if (Boolean.TYPE.equals(clazz)) {
            return new BooleanCellSetter<T>(ObjectSetterFactory.toBooleanSetter(setter), this.booleanReader(reader));
        }
        if (Byte.TYPE.equals(clazz)) {
            return new ByteCellSetter<T>(ObjectSetterFactory.toByteSetter(setter), this.byteReader(reader));
        }
        if (Character.TYPE.equals(clazz)) {
            return new CharCellSetter<T>(ObjectSetterFactory.toCharacterSetter(setter), this.charReader(reader));
        }
        if (Short.TYPE.equals(clazz)) {
            return new ShortCellSetter<T>(ObjectSetterFactory.toShortSetter(setter), this.shortReader(reader));
        }
        if (Integer.TYPE.equals(clazz)) {
            return new IntCellSetter<T>(ObjectSetterFactory.toIntSetter(setter), this.intReader(reader));
        }
        if (Long.TYPE.equals(clazz)) {
            return new LongCellSetter<T>(ObjectSetterFactory.toLongSetter(setter), this.longReader(reader));
        }
        if (Float.TYPE.equals(clazz)) {
            return new FloatCellSetter<T>(ObjectSetterFactory.toFloatSetter(setter), this.floatReader(reader));
        }
        if (Double.TYPE.equals(clazz)) {
            return new DoubleCellSetter<T>(ObjectSetterFactory.toDoubleSetter(setter), this.doubleReader(reader));
        }
        throw new IllegalArgumentException("Invalid primitive type " + clazz);
    }

    private DoubleCellValueReader doubleReader(CellValueReader<?> reader) {
        if (reader instanceof DoubleCellValueReader) {
            return (DoubleCellValueReader)reader;
        }
        return new BoxedDoubleCellValueReader(reader);
    }

    private FloatCellValueReader floatReader(CellValueReader<?> reader) {
        if (reader instanceof FloatCellValueReader) {
            return (FloatCellValueReader)reader;
        }
        return new BoxedFloatCellValueReader(reader);
    }

    private LongCellValueReader longReader(CellValueReader<?> reader) {
        if (reader instanceof LongCellValueReader) {
            return (LongCellValueReader)reader;
        }
        return new BoxedLongCellValueReader(reader);
    }

    private IntegerCellValueReader intReader(CellValueReader<?> reader) {
        if (reader instanceof IntegerCellValueReader) {
            return (IntegerCellValueReader)reader;
        }
        return new BoxedIntegerCellValueReader(reader);
    }

    private ShortCellValueReader shortReader(CellValueReader<?> reader) {
        if (reader instanceof ShortCellValueReader) {
            return (ShortCellValueReader)reader;
        }
        return new BoxedShortCellValueReader(reader);
    }

    private CharCellValueReader charReader(CellValueReader<?> reader) {
        if (reader instanceof CharCellValueReader) {
            return (CharCellValueReader)reader;
        }
        return new BoxedCharCellValueReader(reader);
    }

    private ByteCellValueReader byteReader(CellValueReader<?> reader) {
        if (reader instanceof ByteCellValueReader) {
            return (ByteCellValueReader)reader;
        }
        return new BoxedByteCellValueReader(reader);
    }

    private BooleanCellValueReader booleanReader(CellValueReader<?> reader) {
        if (reader instanceof BooleanCellValueReader) {
            return (BooleanCellValueReader)reader;
        }
        return new BoxedBooleanCellValueReader(reader);
    }

    private <T, P> DelayedCellSetterFactory<T, P> getPrimitiveDelayedCellSetter(Class<?> clazz, CellValueReader<? extends P> reader, Setter<T, ? super P> setter) {
        if (Boolean.TYPE.equals(clazz)) {
            return new BooleanDelayedCellSetterFactory<T>(ObjectSetterFactory.toBooleanSetter(setter), this.booleanReader(reader));
        }
        if (Byte.TYPE.equals(clazz)) {
            return new ByteDelayedCellSetterFactory<T>(ObjectSetterFactory.toByteSetter(setter), this.byteReader(reader));
        }
        if (Character.TYPE.equals(clazz)) {
            return new CharDelayedCellSetterFactory<T>(ObjectSetterFactory.toCharacterSetter(setter), this.charReader(reader));
        }
        if (Short.TYPE.equals(clazz)) {
            return new ShortDelayedCellSetterFactory<T>(ObjectSetterFactory.toShortSetter(setter), this.shortReader(reader));
        }
        if (Integer.TYPE.equals(clazz)) {
            return new IntDelayedCellSetterFactory<T>(ObjectSetterFactory.toIntSetter(setter), this.intReader(reader));
        }
        if (Long.TYPE.equals(clazz)) {
            return new LongDelayedCellSetterFactory<T>(ObjectSetterFactory.toLongSetter(setter), this.longReader(reader));
        }
        if (Float.TYPE.equals(clazz)) {
            return new FloatDelayedCellSetterFactory<T>(ObjectSetterFactory.toFloatSetter(setter), this.floatReader(reader));
        }
        if (Double.TYPE.equals(clazz)) {
            return new DoubleDelayedCellSetterFactory<T>(ObjectSetterFactory.toDoubleSetter(setter), this.doubleReader(reader));
        }
        throw new IllegalArgumentException("Invalid primitive type " + clazz);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, P> Getter<CsvMapperCellHandler<T>, P> newDelayedGetter(CsvColumnKey key, Type type) {
        void var4_14;
        Class clazz = TypeHelper.toClass(type);
        int columnIndex = key.getIndex();
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE.equals(clazz)) {
                BooleanDelayedGetter booleanDelayedGetter = new BooleanDelayedGetter(columnIndex);
                return var4_14;
            } else if (Byte.TYPE.equals(clazz)) {
                ByteDelayedGetter byteDelayedGetter = new ByteDelayedGetter(columnIndex);
                return var4_14;
            } else if (Character.TYPE.equals(clazz)) {
                CharDelayedGetter charDelayedGetter = new CharDelayedGetter(columnIndex);
                return var4_14;
            } else if (Short.TYPE.equals(clazz)) {
                ShortDelayedGetter shortDelayedGetter = new ShortDelayedGetter(columnIndex);
                return var4_14;
            } else if (Integer.TYPE.equals(clazz)) {
                IntDelayedGetter intDelayedGetter = new IntDelayedGetter(columnIndex);
                return var4_14;
            } else if (Long.TYPE.equals(clazz)) {
                LongDelayedGetter longDelayedGetter = new LongDelayedGetter(columnIndex);
                return var4_14;
            } else if (Float.TYPE.equals(clazz)) {
                FloatDelayedGetter floatDelayedGetter = new FloatDelayedGetter(columnIndex);
                return var4_14;
            } else {
                if (!Double.TYPE.equals(clazz)) throw new IllegalArgumentException("Unexpected primitive " + clazz);
                DoubleDelayedGetter doubleDelayedGetter = new DoubleDelayedGetter(columnIndex);
            }
            return var4_14;
        } else {
            DelayedGetter delayedGetter = new DelayedGetter(columnIndex);
        }
        return var4_14;
    }

    private <P> CellValueReader<P> getReader(PropertyMeta<?, P> pm, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        CellValueReader<Object> reader = null;
        if (columnDefinition.hasCustomSource()) {
            reader = columnDefinition.getCustomReader();
        }
        if (reader == null) {
            reader = this.cellValueReaderFromFactory(pm, index, columnDefinition, parsingContextFactoryBuilder);
        }
        if (reader == null) {
            this.mapperBuilderErrorHandler.accessorNotFound("Could not find reader for " + pm + " See " + ErrorDoc.toUrl("CSFM_GETTER_NOT_FOUND"));
        }
        return reader;
    }

    private <P> CellValueReader<P> cellValueReaderFromFactory(PropertyMeta<?, ?> pm, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        ClassMeta<?> classMeta;
        InstantiatorDefinition id;
        Type propertyType = pm.getPropertyType();
        CellValueReader reader = null;
        if (columnDefinition.hasCustomReaderFactory()) {
            CellValueReaderFactory factory = columnDefinition.getCustomCellValueReaderFactory();
            reader = factory.getReader(propertyType, index, columnDefinition, parsingContextFactoryBuilder);
        }
        if (reader == null) {
            reader = this.cellValueReaderFactory.getReader(propertyType, index, columnDefinition, parsingContextFactoryBuilder);
        }
        if (reader == null && (id = InstantiatorDefinitions.lookForCompatibleOneArgument((classMeta = pm.getPropertyClassMeta()).getInstantiatorDefinitions(), COMPATIBILITY_SCORER)) != null) {
            Parameter parameter = id.getParameters()[0];
            PropertyMeta property = classMeta.newPropertyFinder().findProperty(DefaultPropertyNameMatcher.exact(parameter.getName()));
            reader = this.cellValueReaderFromFactory(property, index, columnDefinition, parsingContextFactoryBuilder);
            if (reader != null) {
                Instantiator instantiator = classMeta.getReflectionService().getInstantiatorFactory().getOneArgIdentityInstantiator(id);
                return new InstantiatorOnReader(instantiator, reader);
            }
        }
        return reader;
    }

    public <T, P> CellSetter<T> getCellSetter(PropertyMeta<T, P> prop, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        Class propertyClass = TypeHelper.toClass(prop.getPropertyType());
        CellValueReader<P> reader = this.getReader(prop, index, columnDefinition, parsingContextFactoryBuilder);
        if (propertyClass.isPrimitive()) {
            return this.getPrimitiveCellSetter(propertyClass, reader, this.getSetter(prop));
        }
        return new CellSetterImpl<T, P>(reader, this.getSetter(prop));
    }

    public <T, P> DelayedCellSetterFactory<T, P> getDelayedCellSetter(PropertyMeta<T, P> prop, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        Class propertyClass = TypeHelper.toClass(prop.getPropertyType());
        CellValueReader<P> reader = this.getReader(prop, index, columnDefinition, parsingContextFactoryBuilder);
        Setter<T, P> setter = this.getSetter(prop);
        DelayedCellSetterFactory<T, P> factory = propertyClass.isPrimitive() ? this.getPrimitiveDelayedCellSetter(propertyClass, reader, setter) : new DelayedCellSetterFactoryImpl<T, P>(reader, setter);
        DefaultValueProperty defaultValueProperty = columnDefinition.lookFor(DefaultValueProperty.class);
        if (defaultValueProperty != null) {
            factory = new DefaultValueDelayedCallSetterFactory<T, P>(factory, defaultValueProperty, setter);
        }
        return factory;
    }

    private <T, P> Setter<T, P> getSetter(PropertyMeta<T, P> prop) {
        Setter<T, P> setter = prop.getSetter();
        if (NullSetter.isNull(setter)) {
            return null;
        }
        return setter;
    }
}

