/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.sfm.csv.CellValueReader;
import org.sfm.csv.CellValueReaderFactory;
import org.sfm.csv.CsvColumnDefinition;
import org.sfm.csv.ParsingContextFactoryBuilder;
import org.sfm.csv.impl.cellreader.BooleanCellValueReaderImpl;
import org.sfm.csv.impl.cellreader.ByteCellValueReaderImpl;
import org.sfm.csv.impl.cellreader.CalendarCellValueReader;
import org.sfm.csv.impl.cellreader.CharCellValueReaderImpl;
import org.sfm.csv.impl.cellreader.DateCellValueReader;
import org.sfm.csv.impl.cellreader.DateMultiFormatCellValueReader;
import org.sfm.csv.impl.cellreader.DoubleCellValueReaderImpl;
import org.sfm.csv.impl.cellreader.EnumCellValueReader;
import org.sfm.csv.impl.cellreader.FloatCellValueReaderImpl;
import org.sfm.csv.impl.cellreader.IntegerCellValueReaderImpl;
import org.sfm.csv.impl.cellreader.LongCellValueReaderImpl;
import org.sfm.csv.impl.cellreader.ShortCellValueReaderImpl;
import org.sfm.csv.impl.cellreader.StringCellValueReader;
import org.sfm.csv.impl.cellreader.UUIDCellValueReader;
import org.sfm.csv.impl.cellreader.joda.JodaTimeCellValueReaderHelper;
import org.sfm.csv.impl.cellreader.time.JavaInstantCellValueReader;
import org.sfm.csv.impl.cellreader.time.JavaLocalDateCellValueReader;
import org.sfm.csv.impl.cellreader.time.JavaLocalDateTimeCellValueReader;
import org.sfm.csv.impl.cellreader.time.JavaLocalTimeCellValueReader;
import org.sfm.csv.impl.cellreader.time.JavaOffsetDateTimeCellValueReader;
import org.sfm.csv.impl.cellreader.time.JavaOffsetTimeCellValueReader;
import org.sfm.csv.impl.cellreader.time.JavaYearCellValueReader;
import org.sfm.csv.impl.cellreader.time.JavaYearMonthCellValueReader;
import org.sfm.csv.impl.cellreader.time.JavaZonedDateTimeCellValueReader;
import org.sfm.csv.impl.cellreader.time.MultiFormaterCellValueReader;
import org.sfm.map.column.time.JavaTimeHelper;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.reflect.TypeHelper;
import org.sfm.utils.UnaryFactory;

public final class CellValueReaderFactoryImpl
implements CellValueReaderFactory {
    private static final Map<Class<?>, CellValueReader<?>> READERS = new HashMap();

    @Override
    public <P> CellValueReader<P> getReader(Type propertyType, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        Class propertyClass = TypeHelper.toClass(propertyType);
        CellValueReader<Calendar> reader = null;
        if (propertyClass.equals(Date.class)) {
            String[] patterns = columnDefinition.dateFormats();
            if (patterns.length == 1) {
                DateCellValueReader dateCellValueReader = new DateCellValueReader(index, patterns[0], columnDefinition.getTimeZone());
                reader = dateCellValueReader;
                parsingContextFactoryBuilder.addParsingContextProvider(index, dateCellValueReader);
            } else {
                DateMultiFormatCellValueReader dateCellValueReader = new DateMultiFormatCellValueReader(index, patterns, columnDefinition.getTimeZone());
                reader = dateCellValueReader;
                parsingContextFactoryBuilder.addParsingContextProvider(index, dateCellValueReader);
            }
        } else if (Calendar.class.equals(propertyClass)) {
            reader = new CalendarCellValueReader(this.getReader((Type)((Object)Date.class), index, columnDefinition, parsingContextFactoryBuilder));
        } else if (propertyClass.equals(LocalDate.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<LocalDate>>(){

                @Override
                public CellValueReader<LocalDate> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaLocalDateCellValueReader(dateTimeFormatter);
                }
            });
        } else if (propertyClass.equals(LocalDateTime.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<LocalDateTime>>(){

                @Override
                public CellValueReader<LocalDateTime> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaLocalDateTimeCellValueReader(dateTimeFormatter);
                }
            });
        } else if (propertyClass.equals(LocalTime.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<LocalTime>>(){

                @Override
                public CellValueReader<LocalTime> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaLocalTimeCellValueReader(dateTimeFormatter);
                }
            });
        } else if (propertyClass.equals(ZonedDateTime.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<ZonedDateTime>>(){

                @Override
                public CellValueReader<ZonedDateTime> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaZonedDateTimeCellValueReader(dateTimeFormatter);
                }
            });
        } else if (propertyClass.equals(OffsetTime.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<OffsetTime>>(){

                @Override
                public CellValueReader<OffsetTime> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaOffsetTimeCellValueReader(dateTimeFormatter);
                }
            });
        } else if (propertyClass.equals(OffsetDateTime.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<OffsetDateTime>>(){

                @Override
                public CellValueReader<OffsetDateTime> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaOffsetDateTimeCellValueReader(dateTimeFormatter);
                }
            });
        } else if (propertyClass.equals(Instant.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<Instant>>(){

                @Override
                public CellValueReader<Instant> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaInstantCellValueReader(dateTimeFormatter);
                }
            });
        } else if (propertyClass.equals(Year.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<Year>>(){

                @Override
                public CellValueReader<Year> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaYearCellValueReader(dateTimeFormatter);
                }
            });
        } else if (propertyClass.equals(YearMonth.class)) {
            reader = this.newJavaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<YearMonth>>(){

                @Override
                public CellValueReader<YearMonth> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JavaYearMonthCellValueReader(dateTimeFormatter);
                }
            });
        } else if (Enum.class.isAssignableFrom(propertyClass)) {
            reader = new EnumCellValueReader(propertyClass);
        } else if (JodaTimeClasses.isJoda(propertyClass)) {
            reader = JodaTimeCellValueReaderHelper.getReader(propertyClass, columnDefinition);
        } else if (UUID.class.equals(propertyClass)) {
            reader = new UUIDCellValueReader();
        }
        if (reader == null) {
            reader = this.getCellValueTransformer(propertyClass);
        }
        return reader;
    }

    private <T> CellValueReader<T> newJavaTime(CsvColumnDefinition csvColumnDefinition, UnaryFactory<DateTimeFormatter, CellValueReader<T>> unaryFactory) {
        DateTimeFormatter[] dateTimeFormatters = JavaTimeHelper.getDateTimeFormatters(csvColumnDefinition);
        if (dateTimeFormatters.length == 1) {
            return unaryFactory.newInstance(dateTimeFormatters[0]);
        }
        CellValueReader[] readers = new CellValueReader[dateTimeFormatters.length];
        for (int i = 0; i < readers.length; ++i) {
            readers[i] = unaryFactory.newInstance(dateTimeFormatters[i]);
        }
        return new MultiFormaterCellValueReader(readers);
    }

    private <P> CellValueReader<P> getCellValueTransformer(Class<? extends P> propertyType) {
        return READERS.get(propertyType);
    }

    static {
        READERS.put(Boolean.TYPE, new BooleanCellValueReaderImpl());
        READERS.put(Byte.TYPE, new ByteCellValueReaderImpl());
        READERS.put(Character.TYPE, new CharCellValueReaderImpl());
        READERS.put(Short.TYPE, new ShortCellValueReaderImpl());
        READERS.put(Integer.TYPE, new IntegerCellValueReaderImpl());
        READERS.put(Long.TYPE, new LongCellValueReaderImpl());
        READERS.put(Float.TYPE, new FloatCellValueReaderImpl());
        READERS.put(Double.TYPE, new DoubleCellValueReaderImpl());
        READERS.put(Boolean.class, new BooleanCellValueReaderImpl());
        READERS.put(Byte.class, new ByteCellValueReaderImpl());
        READERS.put(Character.class, new CharCellValueReaderImpl());
        READERS.put(Short.class, new ShortCellValueReaderImpl());
        READERS.put(Integer.class, new IntegerCellValueReaderImpl());
        READERS.put(Long.class, new LongCellValueReaderImpl());
        READERS.put(Float.class, new FloatCellValueReaderImpl());
        READERS.put(Double.class, new DoubleCellValueReaderImpl());
        READERS.put(String.class, new StringCellValueReader());
        READERS.put(CharSequence.class, new StringCellValueReader());
        READERS.put(Object.class, new StringCellValueReader());
    }
}

