/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl;

import java.io.IOException;
import java.util.Iterator;
import org.sfm.csv.CsvReader;
import org.sfm.csv.impl.CsvMapperImpl;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.RowHandler;

public class CsvMapperIterator<T>
implements Iterator<T> {
    private T currentValue;
    private boolean isFetched;
    private final CsvReader reader;
    private final CellConsumer cellConsumer;

    public CsvMapperIterator(CsvReader reader, CsvMapperImpl<T> csvMapperImpl) {
        this.cellConsumer = csvMapperImpl.newCellConsumer(new RowHandler<T>(){

            @Override
            public void handle(T t) throws Exception {
                CsvMapperIterator.this.currentValue = t;
            }
        });
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        this.fetch();
        return this.currentValue != null;
    }

    private void fetch() {
        if (this.isFetched) {
            return;
        }
        try {
            this.currentValue = null;
            this.reader.parseRow(this.cellConsumer);
            this.isFetched = true;
        }
        catch (IOException e) {
            ErrorHelper.rethrow(e);
        }
    }

    @Override
    public T next() {
        this.fetch();
        this.isFetched = false;
        return this.currentValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

