/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl;

import org.sfm.csv.ParsingContext;
import org.sfm.csv.impl.DelegateMarkerSetter;
import org.sfm.csv.mapper.BreakDetector;
import org.sfm.csv.mapper.CellSetter;
import org.sfm.csv.mapper.CsvMapperCellConsumer;
import org.sfm.reflect.Setter;
import org.sfm.utils.Asserts;

public class DelegateCellSetter<T, P>
implements CellSetter<T> {
    private final DelegateMarkerSetter<T, P> marker;
    private final CsvMapperCellConsumer<P> handler;
    private final Setter<T, P> setter;
    private final int cellIndex;

    public DelegateCellSetter(DelegateMarkerSetter<T, P> marker, int cellIndex, BreakDetector parentBreakDetector) {
        this.marker = Asserts.requireNonNull("marker", marker);
        this.handler = marker.getMapper().newCellConsumer(null, parentBreakDetector);
        this.setter = marker.getSetter();
        this.cellIndex = cellIndex;
    }

    public DelegateCellSetter(DelegateMarkerSetter<T, P> marker, CsvMapperCellConsumer<P> handler, int cellIndex) {
        this.marker = Asserts.requireNonNull("marker", marker);
        this.handler = Asserts.requireNonNull("handler", handler);
        this.cellIndex = cellIndex;
        this.setter = null;
    }

    @Override
    public void set(T target, char[] chars, int offset, int length, ParsingContext context) throws Exception {
        this.handler.newCell(chars, offset, length, this.cellIndex);
        BreakDetector breakDetector = this.handler.getBreakDetector();
        if (this.setter != null && (breakDetector == null || breakDetector.broken() && breakDetector.isNotNull())) {
            this.setter.set(target, this.handler.getCurrentInstance());
        }
    }

    public CsvMapperCellConsumer getCellConsumer() {
        return this.handler;
    }

    public String toString() {
        return "DelegateCellSetter{marker=" + this.marker + ", handler=" + this.handler + ", cellIndex=" + this.cellIndex + '}';
    }
}

