/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl;

import org.sfm.csv.ParsingContext;
import org.sfm.csv.impl.CsvMapperImpl;
import org.sfm.csv.impl.DelegateMarkerDelayedCellSetterFactory;
import org.sfm.csv.mapper.BreakDetector;
import org.sfm.csv.mapper.CsvMapperCellConsumer;
import org.sfm.csv.mapper.DelayedCellSetter;
import org.sfm.reflect.Setter;

public class DelegateDelayedCellSetter<T, P>
implements DelayedCellSetter<T, P> {
    private final CsvMapperCellConsumer<P> cellConsumer;
    private final int cellIndex;
    private final BreakDetector breakDetector;
    private final Setter<T, P> setter;

    public DelegateDelayedCellSetter(DelegateMarkerDelayedCellSetterFactory<T, P> marker, int cellIndex, BreakDetector breakDetector) {
        this.cellConsumer = ((CsvMapperImpl)marker.getMapper()).newCellConsumer(null, breakDetector);
        this.cellIndex = cellIndex;
        this.setter = marker.getSetter();
        this.breakDetector = this.cellConsumer.getBreakDetector();
    }

    public DelegateDelayedCellSetter(CsvMapperCellConsumer<P> handler, int cellIndex) {
        this.cellConsumer = handler;
        this.cellIndex = cellIndex;
        this.setter = null;
        this.breakDetector = null;
    }

    public CsvMapperCellConsumer getCellHandler() {
        return this.cellConsumer;
    }

    public String toString() {
        return "DelegateDelayedCellSetterFactory{cellIndex=" + this.cellIndex + ", handler=" + this.cellConsumer + '}';
    }

    public P getValue() {
        return this.cellConsumer.getCurrentInstance();
    }

    @Override
    public void set(T t) throws Exception {
        if (this.breakDetector == null || this.breakDetector.broken() && this.breakDetector.isNotNull()) {
            this.setter.set(t, this.getValue());
        }
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.cellConsumer.newCell(chars, offset, length, this.cellIndex);
    }

    @Override
    public P consumeValue() {
        return this.getValue();
    }

    @Override
    public P peekValue() {
        return this.getValue();
    }
}

