/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sfm.csv.CellValueReaderFactory;
import org.sfm.csv.CsvColumnDefinition;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.CsvMapper;
import org.sfm.csv.CsvMapperBuilder;
import org.sfm.csv.CsvParser;
import org.sfm.csv.CsvReader;
import org.sfm.csv.impl.CellValueReaderFactoryImpl;
import org.sfm.csv.impl.ColumnsMapperKeyBuilderCellConsumer;
import org.sfm.csv.impl.CsvMapperImpl;
import org.sfm.csv.impl.CsvMapperIterator;
import org.sfm.csv.mapper.CsvMapperCellConsumer;
import org.sfm.map.MapperConfig;
import org.sfm.map.MappingException;
import org.sfm.map.mapper.ColumnDefinitionProvider;
import org.sfm.map.mapper.MapperCache;
import org.sfm.map.mapper.MapperKey;
import org.sfm.map.mapper.MapperKeyComparator;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.utils.Asserts;
import org.sfm.utils.RowHandler;

public final class DynamicCsvMapper<T>
implements CsvMapper<T> {
    private final ClassMeta<T> classMeta;
    private final Type target;
    private final String defaultDateFormat;
    private final CellValueReaderFactory cellValueReaderFactory;
    private final MapperConfig<CsvColumnKey, CsvColumnDefinition> mapperConfig;
    private final MapperCache<CsvColumnKey, CsvMapperImpl<T>> mapperCache = new MapperCache(MapperKeyComparator.csvColumnKeyComparator());

    public DynamicCsvMapper(Type target, ClassMeta<T> classMeta, String defaultDateFormat, CellValueReaderFactory cellValueReaderFactory, MapperConfig<CsvColumnKey, CsvColumnDefinition> mapperConfig) {
        this.classMeta = Asserts.requireNonNull("classMeta", classMeta);
        this.target = Asserts.requireNonNull("target", target);
        this.defaultDateFormat = defaultDateFormat;
        this.mapperConfig = mapperConfig;
        this.cellValueReaderFactory = cellValueReaderFactory;
    }

    public DynamicCsvMapper(Type target, ClassMeta<T> classMeta, ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey> columnDefinitionProvider) {
        this(target, classMeta, "yyyy-MM-dd HH:mm:ss", new CellValueReaderFactoryImpl(), MapperConfig.config(columnDefinitionProvider));
    }

    @Override
    public <H extends RowHandler<? super T>> H forEach(Reader reader, H handle) throws IOException, MappingException {
        return this.forEach(CsvParser.reader(reader), handle);
    }

    @Override
    public <H extends RowHandler<? super T>> H forEach(CsvReader csvReader, H handle) throws IOException {
        CsvMapperCellConsumer mapperCellConsumer = this.getDelegateMapper(csvReader).newCellConsumer(handle);
        csvReader.parseAll(mapperCellConsumer);
        return handle;
    }

    @Override
    public <H extends RowHandler<? super T>> H forEach(Reader reader, H handle, int skip) throws IOException, MappingException {
        return this.forEach(CsvParser.skip(skip).reader(reader), handle);
    }

    @Override
    public <H extends RowHandler<? super T>> H forEach(CsvReader csvReader, H handle, int limit) throws IOException {
        CsvMapperCellConsumer mapperCellConsumer = this.getDelegateMapper(csvReader).newCellConsumer(handle);
        csvReader.parseRows(mapperCellConsumer, limit);
        return handle;
    }

    @Override
    public <H extends RowHandler<? super T>> H forEach(Reader reader, H handle, int skip, int limit) throws IOException, MappingException {
        return this.forEach(CsvParser.skip(skip).reader(reader), handle, limit);
    }

    @Override
    public Iterator<T> iterator(Reader reader) throws IOException {
        CsvReader csvReader = CsvParser.reader(reader);
        return this.iterator(csvReader);
    }

    @Override
    public Iterator<T> iterator(CsvReader csvReader) throws IOException {
        CsvMapperImpl<T> mapper = this.getDelegateMapper(csvReader);
        return new CsvMapperIterator<T>(csvReader, mapper);
    }

    @Override
    public Iterator<T> iterator(Reader reader, int skip) throws IOException {
        return this.iterator(CsvParser.skip(skip).reader(reader));
    }

    private CsvMapperImpl<T> getDelegateMapper(CsvReader reader) throws IOException {
        ColumnsMapperKeyBuilderCellConsumer keyBuilderCellConsumer = new ColumnsMapperKeyBuilderCellConsumer();
        reader.parseRow(keyBuilderCellConsumer);
        return this.getCsvMapper(keyBuilderCellConsumer.getKey());
    }

    @Override
    public Stream<T> stream(Reader reader) throws IOException {
        CsvReader csvReader = CsvParser.reader(reader);
        return this.stream(csvReader);
    }

    @Override
    public Stream<T> stream(CsvReader csvReader) throws IOException {
        CsvMapperImpl<T> mapper;
        CsvMapperImpl<T> csvMapperImpl = mapper = this.getDelegateMapper(csvReader);
        csvMapperImpl.getClass();
        return StreamSupport.stream(csvMapperImpl.new CsvMapperImpl.CsvSpliterator(csvReader), false);
    }

    @Override
    public Stream<T> stream(Reader reader, int skip) throws IOException {
        return this.stream(CsvParser.skip(skip).reader(reader));
    }

    protected CsvMapperImpl<T> getCsvMapper(MapperKey<CsvColumnKey> key) {
        CsvMapperImpl<T> csvMapperImpl = this.mapperCache.get(key);
        if (csvMapperImpl == null) {
            csvMapperImpl = this.buildMapper(key);
            this.mapperCache.add(key, csvMapperImpl);
        }
        return csvMapperImpl;
    }

    private CsvMapperImpl<T> buildMapper(MapperKey<CsvColumnKey> key) {
        CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(this.target, this.classMeta, 0, this.cellValueReaderFactory, this.mapperConfig);
        builder.setDefaultDateFormat(this.defaultDateFormat);
        for (CsvColumnKey col : (CsvColumnKey[])key.getColumns()) {
            builder.addMapping(col, CsvColumnDefinition.identity());
        }
        return (CsvMapperImpl)builder.mapper();
    }

    public String toString() {
        return "DynamicCsvMapper{target=" + this.target + ", mapperCache=" + this.mapperCache + '}';
    }
}

