/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.cellreader;

import org.sfm.csv.ParsingContext;
import org.sfm.csv.impl.cellreader.BooleanCellValueReader;

public final class BooleanCellValueReaderImpl
implements BooleanCellValueReader {
    @Override
    public Boolean read(char[] chars, int offset, int length, ParsingContext parsingContext) {
        if (length == 0) {
            return null;
        }
        return this.readBoolean(chars, offset, length, parsingContext);
    }

    @Override
    public boolean readBoolean(char[] chars, int offset, int length, ParsingContext parsingContext) {
        return BooleanCellValueReaderImpl.parseBoolean(chars, offset, length);
    }

    public static boolean parseBoolean(char[] chars, int offset, int length) {
        switch (length) {
            case 0: {
                return false;
            }
            case 1: {
                switch (chars[offset]) {
                    case '\u0000': 
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return false;
                    }
                }
                return true;
            }
            case 2: {
                if (!(chars[offset] != 'N' && chars[offset] != 'n' || chars[offset + 1] != 'O' && chars[offset + 1] != 'o')) {
                    return false;
                }
            }
            case 5: {
                if (chars[offset] != 'F' && chars[offset] != 'f' || chars[offset + 1] != 'A' && chars[offset + 1] != 'a' || chars[offset + 2] != 'L' && chars[offset + 2] != 'l' || chars[offset + 3] != 'S' && chars[offset + 3] != 's' || chars[offset + 4] != 'E' && chars[offset + 4] != 'e') break;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "BooleanCellValueReaderImpl{}";
    }
}

