/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.cellreader;

import org.sfm.csv.ParsingContext;
import org.sfm.csv.mapper.DelayedCellSetter;
import org.sfm.map.column.DefaultValueProperty;
import org.sfm.reflect.Setter;

public class DefaultValueDelayedCellSetter<T, P>
implements DelayedCellSetter<T, P> {
    private final DelayedCellSetter<T, P> delegate;
    private final DefaultValueProperty defaultValueProperty;
    private final Setter<T, ? super P> setter;
    private boolean isSet = false;

    public DefaultValueDelayedCellSetter(DelayedCellSetter<T, P> delegate, DefaultValueProperty defaultValueProperty, Setter<T, ? super P> setter) {
        this.delegate = delegate;
        this.defaultValueProperty = defaultValueProperty;
        this.setter = setter;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isSet = true;
        this.delegate.set(chars, offset, length, parsingContext);
    }

    @Override
    public P consumeValue() {
        P p;
        if (this.isSet) {
            p = this.delegate.consumeValue();
            this.isSet = false;
        } else {
            p = this.defaultValue();
        }
        return p;
    }

    private P defaultValue() {
        return (P)this.defaultValueProperty.getValue();
    }

    @Override
    public P peekValue() {
        return this.isSet ? this.delegate.peekValue() : this.defaultValue();
    }

    @Override
    public void set(T t) throws Exception {
        P val = this.consumeValue();
        this.setter.set(t, val);
    }

    @Override
    public boolean isSettable() {
        return this.delegate.isSettable();
    }
}

