/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.cellreader;

import org.sfm.csv.ParsingContext;
import org.sfm.csv.impl.ParsingException;
import org.sfm.csv.impl.cellreader.LongCellValueReader;

public final class LongCellValueReaderImpl
implements LongCellValueReader {
    private static final char C_ZERO = '0';
    private static final char C_NINE = '9';
    private static final char C_NEG_SIGN = '-';

    @Override
    public Long read(char[] chars, int offset, int length, ParsingContext parsingContext) {
        if (length == 0) {
            return null;
        }
        return this.readLong(chars, offset, length, parsingContext);
    }

    @Override
    public long readLong(char[] chars, int offset, int length, ParsingContext parsingContext) {
        return LongCellValueReaderImpl.parseLong(chars, offset, length);
    }

    public static long parseLong(char[] chars, int offset, int length) {
        long n = 0L;
        boolean negative = false;
        for (int i = offset; i < offset + length; ++i) {
            char b = chars[i];
            if (b >= '0' && b <= '9') {
                n = n * 10L + (long)chars[i] - 48L;
                continue;
            }
            if (b == '-' && i == offset) {
                negative = true;
                continue;
            }
            if (b == ' ') continue;
            throw new ParsingException("Cannot parse " + new String(chars, offset, length) + " as a long");
        }
        if (negative) {
            n = 0L - n;
        }
        return n;
    }

    public String toString() {
        return "LongCellValueReaderImpl{}";
    }
}

