/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.cellreader.joda;

import java.lang.reflect.Type;
import org.joda.time.format.DateTimeFormatter;
import org.sfm.csv.CellValueReader;
import org.sfm.csv.CsvColumnDefinition;
import org.sfm.csv.impl.cellreader.joda.JodaDateTimeCellValueReader;
import org.sfm.csv.impl.cellreader.joda.JodaLocalDateCellValueReader;
import org.sfm.csv.impl.cellreader.joda.JodaLocalDateTimeCellValueReader;
import org.sfm.csv.impl.cellreader.joda.JodaLocalTimeCellValueReader;
import org.sfm.csv.impl.cellreader.joda.MultiFormaterCellValueReader;
import org.sfm.map.column.joda.JodaHelper;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.reflect.TypeHelper;
import org.sfm.utils.UnaryFactory;

public class JodaTimeCellValueReaderHelper {
    public static CellValueReader<?> getReader(Type type, CsvColumnDefinition columnDefinition) {
        Class clazz = TypeHelper.toClass(type);
        if (JodaTimeClasses.isJodaDateTime(clazz)) {
            return JodaTimeCellValueReaderHelper.newJodaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<?>>(){

                @Override
                public CellValueReader<?> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JodaDateTimeCellValueReader(dateTimeFormatter);
                }
            });
        }
        if (JodaTimeClasses.isJodaLocalDate(clazz)) {
            return JodaTimeCellValueReaderHelper.newJodaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<?>>(){

                @Override
                public CellValueReader<?> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JodaLocalDateCellValueReader(dateTimeFormatter);
                }
            });
        }
        if (JodaTimeClasses.isJodaLocalDateTime(clazz)) {
            return JodaTimeCellValueReaderHelper.newJodaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<?>>(){

                @Override
                public CellValueReader<?> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JodaLocalDateTimeCellValueReader(dateTimeFormatter);
                }
            });
        }
        if (JodaTimeClasses.isJodaLocalTime(clazz)) {
            return JodaTimeCellValueReaderHelper.newJodaTime(columnDefinition, new UnaryFactory<DateTimeFormatter, CellValueReader<?>>(){

                @Override
                public CellValueReader<?> newInstance(DateTimeFormatter dateTimeFormatter) {
                    return new JodaLocalTimeCellValueReader(dateTimeFormatter);
                }
            });
        }
        return null;
    }

    private static CellValueReader<?> newJodaTime(CsvColumnDefinition csvColumnDefinition, UnaryFactory<DateTimeFormatter, CellValueReader<?>> unaryFactory) {
        DateTimeFormatter[] dateTimeFormatters = JodaHelper.getDateTimeFormatters(csvColumnDefinition);
        if (dateTimeFormatters.length == 1) {
            return unaryFactory.newInstance(dateTimeFormatters[0]);
        }
        CellValueReader[] readers = new CellValueReader[dateTimeFormatters.length];
        for (int i = 0; i < readers.length; ++i) {
            readers[i] = unaryFactory.newInstance(dateTimeFormatters[i]);
        }
        return new MultiFormaterCellValueReader(readers);
    }
}

