/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.writer;

import java.text.Format;
import org.sfm.csv.CellWriter;
import org.sfm.map.FieldMapper;
import org.sfm.map.MappingContext;
import org.sfm.reflect.Getter;
import org.sfm.utils.Asserts;

public class FormattingAppender<S>
implements FieldMapper<S, Appendable> {
    private final Getter<S, ?> getter;
    private final Getter<MappingContext<? super S>, Format> formatAccessor;
    private final CellWriter cellWriter;

    public FormattingAppender(Getter<S, ?> getter, Getter<MappingContext<? super S>, Format> formatAccessor, CellWriter cellWriter) {
        this.getter = getter;
        this.formatAccessor = formatAccessor;
        this.cellWriter = cellWriter;
    }

    @Override
    public void mapTo(S source, Appendable target, MappingContext<? super S> context) throws Exception {
        Object o = this.getter.get(source);
        if (o != null) {
            Format format = this.formatAccessor.get(context);
            Asserts.requireNonNull("Format in mapping context", format);
            this.cellWriter.writeValue(format.format(o), target);
        }
    }
}

