/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.mapper;

import java.util.Collection;
import org.sfm.csv.mapper.BreakDetector;
import org.sfm.csv.mapper.CsvMapperCellHandler;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.utils.RowHandler;

public final class CsvMapperCellConsumer<T>
implements CellConsumer {
    private final CsvMapperCellHandler<T> mapperSetters;
    protected final RowHandlerErrorHandler rowHandlerErrorHandlers;
    protected final BreakDetector breakDetector;
    protected final RowHandler<? super T> handler;
    protected final CsvMapperCellConsumer[] children;
    protected int cellIndex = 0;

    public CsvMapperCellConsumer(CsvMapperCellHandler<T> csvMapperCellHandler, RowHandlerErrorHandler rowHandlerErrorHandlers, RowHandler<? super T> handler, BreakDetector breakDetector, Collection<CsvMapperCellConsumer<?>> children) {
        this.mapperSetters = csvMapperCellHandler;
        this.rowHandlerErrorHandlers = rowHandlerErrorHandlers;
        this.handler = handler;
        this.breakDetector = breakDetector;
        this.children = children.toArray(new CsvMapperCellConsumer[0]);
    }

    @Override
    public final void endOfRow() {
        this.composeInstance();
        this.resetConsumer();
    }

    public final T getCurrentInstance() {
        return this.mapperSetters.getCurrentInstance();
    }

    protected final boolean hasData() {
        return this.cellIndex > 0;
    }

    protected final void callHandler() {
        if (this.handler == null) {
            return;
        }
        try {
            this.handler.handle(this.getCurrentInstance());
        }
        catch (Exception e) {
            this.rowHandlerErrorHandlers.handlerError(e, this.getCurrentInstance());
        }
    }

    @Override
    public final void end() {
        this.endOfRow();
        this.afterEnd();
    }

    @Override
    public final void newCell(char[] chars, int offset, int length) {
        int index = this.cellIndex;
        this.newCell(chars, offset, length, index);
        this.afterNewCell(index);
    }

    public final void newCell(char[] chars, int offset, int length, int cellIndex) {
        if (this.mapperSetters.isDelayedSetter(cellIndex)) {
            this.mapperSetters.delayedCellValue(chars, offset, length, cellIndex);
        } else if (this.isNotNull()) {
            this.mapperSetters.cellValue(chars, offset, length, cellIndex);
        }
        this.cellIndex = cellIndex + 1;
    }

    private boolean isNotNull() {
        if (this.breakDetector == null) {
            this.mapperSetters.createInstanceIfNull();
            return true;
        }
        return this.breakDetector.isNotNull();
    }

    public final BreakDetector getBreakDetector() {
        return this.breakDetector;
    }

    private void resetConsumer() {
        for (CsvMapperCellConsumer child : this.children) {
            child.resetConsumer();
        }
        if (this.breakDetector != null) {
            this.breakDetector.reset();
        } else {
            this.mapperSetters.resetCurrentInstance();
        }
        this.cellIndex = 0;
    }

    private void composeInstance() {
        if (this.hasData() && (this.breakDetector == null || this.breakDetector.isNotNull())) {
            for (CsvMapperCellConsumer child : this.children) {
                child.composeInstance();
            }
            this.mapperSetters.createInstanceIfNull();
            this.mapperSetters.applyDelayedSetters();
            if (this.breakDetector == null) {
                this.callHandler();
            }
        }
    }

    protected void afterEnd() {
        if (this.breakDetector != null && this.mapperSetters.hasInstance()) {
            this.callHandler();
        }
    }

    protected void afterNewCell(int index) {
        if (this.breakDetector == null) {
            return;
        }
        this.updateBreakStatus(index);
    }

    private void updateBreakStatus(int cellIndex) {
        if (this.breakDetector.updateStatus(this.mapperSetters, cellIndex) && this.breakDetector.broken()) {
            if (this.mapperSetters.hasInstance()) {
                this.callHandler();
                this.mapperSetters.resetCurrentInstance();
            }
            this.updateChildrenStatus(cellIndex);
            if (this.breakDetector.isNotNull()) {
                this.mapperSetters.createInstance();
            }
            return;
        }
        this.updateChildrenStatus(cellIndex);
    }

    private void updateChildrenStatus(int cellIndex) {
        for (CsvMapperCellConsumer consumer : this.children) {
            consumer.updateBreakStatus(cellIndex);
        }
    }
}

