/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.mapper;

import java.lang.reflect.Type;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.csv.CellWriter;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.impl.writer.BooleanAppendableSetter;
import org.sfm.csv.impl.writer.ByteAppendableSetter;
import org.sfm.csv.impl.writer.CellWriterSetterWrapper;
import org.sfm.csv.impl.writer.CharacterAppendableSetter;
import org.sfm.csv.impl.writer.DoubleAppendableSetter;
import org.sfm.csv.impl.writer.EnumOrdinalAppendableSetter;
import org.sfm.csv.impl.writer.FloatAppendableSetter;
import org.sfm.csv.impl.writer.FormattingAppender;
import org.sfm.csv.impl.writer.IntegerAppendableSetter;
import org.sfm.csv.impl.writer.JodaTimeFormattingAppender;
import org.sfm.csv.impl.writer.LongAppendableSetter;
import org.sfm.csv.impl.writer.ObjectAppendableSetter;
import org.sfm.csv.impl.writer.ObjectToStringSetter;
import org.sfm.csv.impl.writer.ShortAppendableSetter;
import org.sfm.csv.impl.writer.time.JavaTimeFormattingAppender;
import org.sfm.map.FieldMapper;
import org.sfm.map.MapperBuilderErrorHandler;
import org.sfm.map.MappingContext;
import org.sfm.map.column.DateFormatProperty;
import org.sfm.map.column.EnumOrdinalFormatProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.column.FormatProperty;
import org.sfm.map.column.SetterFactoryProperty;
import org.sfm.map.column.SetterProperty;
import org.sfm.map.column.joda.JodaDateTimeFormatterProperty;
import org.sfm.map.column.time.JavaDateTimeFormatterProperty;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.impl.JodaTimeClasses;
import org.sfm.map.impl.fieldmapper.BooleanFieldMapper;
import org.sfm.map.impl.fieldmapper.ByteFieldMapper;
import org.sfm.map.impl.fieldmapper.CharacterFieldMapper;
import org.sfm.map.impl.fieldmapper.DoubleFieldMapper;
import org.sfm.map.impl.fieldmapper.FieldMapperImpl;
import org.sfm.map.impl.fieldmapper.FloatFieldMapper;
import org.sfm.map.impl.fieldmapper.IntFieldMapper;
import org.sfm.map.impl.fieldmapper.LongFieldMapper;
import org.sfm.map.impl.fieldmapper.ShortFieldMapper;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactory;
import org.sfm.map.mapper.PropertyMapping;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterFactory;
import org.sfm.reflect.SetterOnGetter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.ObjectClassMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.primitive.BooleanGetter;
import org.sfm.reflect.primitive.ByteGetter;
import org.sfm.reflect.primitive.CharacterGetter;
import org.sfm.reflect.primitive.DoubleGetter;
import org.sfm.reflect.primitive.FloatGetter;
import org.sfm.reflect.primitive.IntGetter;
import org.sfm.reflect.primitive.LongGetter;
import org.sfm.reflect.primitive.ShortGetter;
import org.sfm.utils.Supplier;

public class FieldMapperToAppendableFactory
implements ConstantTargetFieldMapperFactory<Appendable, CsvColumnKey> {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final CellWriter cellWriter;

    public FieldMapperToAppendableFactory(CellWriter cellWriter) {
        this.cellWriter = cellWriter;
    }

    @Override
    public <S, P> FieldMapper<S, Appendable> newFieldMapper(PropertyMapping<S, P, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> pm, MappingContextFactoryBuilder builder, MapperBuilderErrorHandler mappingErrorHandler) {
        if (pm == null) {
            throw new NullPointerException("pm is null");
        }
        Getter<?, ?> customGetter = pm.getColumnDefinition().getCustomGetter();
        Getter<Object, Object> getter = customGetter != null ? customGetter : pm.getPropertyMeta().getGetter();
        FieldMapperColumnDefinition<CsvColumnKey> columnDefinition = pm.getColumnDefinition();
        Type type = pm.getPropertyMeta().getPropertyType();
        if (TypeHelper.isPrimitive(type) && !columnDefinition.has(FormatProperty.class)) {
            if (getter instanceof BooleanGetter) {
                return new BooleanFieldMapper((BooleanGetter)((Object)getter), new BooleanAppendableSetter(this.cellWriter));
            }
            if (getter instanceof ByteGetter) {
                return new ByteFieldMapper((ByteGetter)((Object)getter), new ByteAppendableSetter(this.cellWriter));
            }
            if (getter instanceof CharacterGetter) {
                return new CharacterFieldMapper((CharacterGetter)((Object)getter), new CharacterAppendableSetter(this.cellWriter));
            }
            if (getter instanceof ShortGetter) {
                return new ShortFieldMapper((ShortGetter)((Object)getter), new ShortAppendableSetter(this.cellWriter));
            }
            if (getter instanceof IntGetter) {
                return new IntFieldMapper((IntGetter)((Object)getter), new IntegerAppendableSetter(this.cellWriter));
            }
            if (getter instanceof LongGetter) {
                return new LongFieldMapper((LongGetter)((Object)getter), new LongAppendableSetter(this.cellWriter));
            }
            if (getter instanceof FloatGetter) {
                return new FloatFieldMapper((FloatGetter)((Object)getter), new FloatAppendableSetter(this.cellWriter));
            }
            if (getter instanceof DoubleGetter) {
                return new DoubleFieldMapper((DoubleGetter)((Object)getter), new DoubleAppendableSetter(this.cellWriter));
            }
        }
        Setter<Appendable, Enum> setter = null;
        if (TypeHelper.isEnum(type) && columnDefinition.has(EnumOrdinalFormatProperty.class)) {
            setter = new EnumOrdinalAppendableSetter(this.cellWriter);
        }
        Format format = null;
        if (columnDefinition.has(FormatProperty.class)) {
            format = columnDefinition.lookFor(FormatProperty.class).format();
        } else if (TypeHelper.areEquals(type, Date.class)) {
            String df = DEFAULT_DATE_FORMAT;
            DateFormatProperty dfp = columnDefinition.lookFor(DateFormatProperty.class);
            if (dfp != null) {
                df = dfp.getPattern();
            }
            format = new SimpleDateFormat(df);
        } else {
            if (TypeHelper.isAssignable(TemporalAccessor.class, type) && columnDefinition.has(JavaDateTimeFormatterProperty.class)) {
                return new JavaTimeFormattingAppender(getter, columnDefinition.lookFor(JavaDateTimeFormatterProperty.class).getFormatter(), this.cellWriter);
            }
            if (JodaTimeClasses.isJoda(type)) {
                if (columnDefinition.has(JodaDateTimeFormatterProperty.class)) {
                    return new JodaTimeFormattingAppender(getter, columnDefinition.lookFor(JodaDateTimeFormatterProperty.class).getFormatter(), this.cellWriter);
                }
                if (columnDefinition.has(DateFormatProperty.class)) {
                    return new JodaTimeFormattingAppender(getter, columnDefinition.lookFor(DateFormatProperty.class).getPattern(), this.cellWriter);
                }
            }
        }
        if (format != null) {
            Format f = format;
            builder.addSupplier(pm.getColumnKey().getIndex(), new CloneFormatSupplier(f));
            return new FormattingAppender(getter, new MappingContextFormatGetter(pm.getColumnKey().getIndex()), this.cellWriter);
        }
        if (setter == null) {
            setter = this.getSetter(pm, this.cellWriter);
        }
        return new FieldMapperImpl(getter, setter);
    }

    private <S, P> Setter<Appendable, ? super P> getSetter(PropertyMapping<S, P, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> pm, CellWriter cellWriter) {
        SetterProperty setterProperty = pm.getColumnDefinition().lookFor(SetterProperty.class);
        if (setterProperty != null) {
            return new CellWriterSetterWrapper(cellWriter, setterProperty.getSetter());
        }
        Setter<Appendable, ?> setter = this.setterFromFactory(pm);
        if (setter != null) {
            return new CellWriterSetterWrapper(cellWriter, setter);
        }
        return new ObjectAppendableSetter(cellWriter);
    }

    private <S, P> Setter<Appendable, ?> setterFromFactory(PropertyMapping<S, P, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> pm) {
        ObjectClassMeta ocm;
        ClassMeta<P> classMeta;
        Setter setter = null;
        SetterFactoryProperty setterFactoryProperty = pm.getColumnDefinition().lookFor(SetterFactoryProperty.class);
        if (setterFactoryProperty != null) {
            SetterFactory<?, ?> setterFactory = setterFactoryProperty.getSetterFactory();
            setter = setterFactory.getSetter(pm);
        }
        if (setter == null && (classMeta = pm.getPropertyMeta().getPropertyClassMeta()) instanceof ObjectClassMeta && (ocm = (ObjectClassMeta)classMeta).getNumberOfProperties() == 1) {
            PropertyMeta subProp = ocm.getFirstProperty();
            Setter<Appendable, ?> subSetter = this.setterFromFactory(pm.propertyMeta(subProp));
            if (subSetter != null) {
                setter = new SetterOnGetter(subSetter, subProp.getGetter());
            } else {
                return new ObjectToStringSetter(subProp.getGetter());
            }
        }
        return setter;
    }

    private static class CloneFormatSupplier
    implements Supplier<Format> {
        private final Format f;

        public CloneFormatSupplier(Format f) {
            this.f = f;
        }

        @Override
        public Format get() {
            return (Format)this.f.clone();
        }
    }

    private static class MappingContextFormatGetter<S>
    implements Getter<MappingContext<? super S>, Format> {
        private final int index;

        public MappingContextFormatGetter(int index) {
            this.index = index;
        }

        @Override
        public Format get(MappingContext<? super S> target) throws Exception {
            return (Format)target.context(this.index);
        }
    }
}

