/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.parser;

import java.io.IOException;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.csv.parser.CharBuffer;
import org.sfm.csv.parser.CsvCharConsumer;

public final class ConfigurableTrimCsvCharConsumer
extends CsvCharConsumer {
    private static final int LAST_CHAR_WAS_SEPARATOR = 4;
    private static final int LAST_CHAR_WAS_CR = 2;
    private static final int ESCAPED = 1;
    private static final int NONE = 0;
    private static final int TURN_OFF_LAST_CHAR_MASK = -7;
    private final char separatorChar;
    private final char escapeChar;
    private final CharBuffer csvBuffer;
    private int _currentIndex;
    private int _currentState = 0;

    public ConfigurableTrimCsvCharConsumer(CharBuffer csvBuffer, char separatorChar, char escapeChar) {
        this.separatorChar = separatorChar;
        this.escapeChar = escapeChar;
        this.csvBuffer = csvBuffer;
    }

    @Override
    public final void consumeAllBuffer(CellConsumer cellConsumer) {
        int currentIndex;
        int bufferLength = this.csvBuffer.bufferSize;
        char[] chars = this.csvBuffer.buffer;
        int currentState = this._currentState;
        for (currentIndex = this._currentIndex; currentIndex < bufferLength; ++currentIndex) {
            char character = chars[currentIndex];
            if (character == this.escapeChar) {
                currentState ^= 1;
            } else if ((currentState & 1) == 0) {
                if (character == this.separatorChar) {
                    this.newCell(currentIndex, cellConsumer);
                    currentState = 4;
                    continue;
                }
                if (character == '\n') {
                    if ((currentState & 2) == 0) {
                        this.endOfRow(currentIndex, cellConsumer);
                        currentState = 0;
                        continue;
                    }
                    this.csvBuffer.mark = currentIndex + 1;
                } else if (character == '\r') {
                    this.endOfRow(currentIndex, cellConsumer);
                    currentState = 2;
                    continue;
                }
            }
            currentState &= 0xFFFFFFF9;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
    }

    @Override
    public boolean consumeToNextRow(CellConsumer cellConsumer) {
        int currentIndex;
        int bufferLength = this.csvBuffer.getBufferSize();
        char[] chars = this.csvBuffer.getCharBuffer();
        int currentState = this._currentState;
        for (currentIndex = this._currentIndex; currentIndex < bufferLength; ++currentIndex) {
            char character = chars[currentIndex];
            if (character == this.escapeChar) {
                currentState ^= 1;
            } else if ((currentState & 1) == 0) {
                if (character == this.separatorChar) {
                    this.newCell(currentIndex, cellConsumer);
                    currentState = 0;
                    continue;
                }
                if (character == '\n') {
                    if ((currentState & 2) == 0) {
                        this.endOfRow(currentIndex, cellConsumer);
                        this._currentState = 0;
                        this._currentIndex = currentIndex + 1;
                        return true;
                    }
                    this.csvBuffer.mark = currentIndex + 1;
                } else if (character == '\r') {
                    this.endOfRow(currentIndex, cellConsumer);
                    this._currentState = 2;
                    this._currentIndex = currentIndex + 1;
                    return true;
                }
            }
            currentState &= 0xFFFFFFF9;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
        return false;
    }

    private void endOfRow(int currentIndex, CellConsumer cellConsumer) {
        this.newCell(currentIndex, cellConsumer);
        cellConsumer.endOfRow();
    }

    private void newCell(int end, CellConsumer cellConsumer) {
        int strEnd;
        char[] charBuffer = this.csvBuffer.buffer;
        int strStart = this.csvBuffer.mark;
        for (strEnd = end; strStart < strEnd && charBuffer[strEnd - 1] == ' '; --strEnd) {
        }
        while (strStart < strEnd && charBuffer[strStart] == ' ') {
            ++strStart;
        }
        if (strStart < strEnd && charBuffer[strStart] == this.escapeChar) {
            strEnd = this.unescape(charBuffer, ++strStart, strEnd);
        }
        cellConsumer.newCell(charBuffer, strStart, strEnd - strStart);
        this.csvBuffer.mark = end + 1;
    }

    private int unescape(char[] chars, int offset, int end) {
        for (int i = offset; i < end - 1; ++i) {
            if (chars[i] != this.escapeChar) continue;
            return this.removeEscapeChars(chars, end, i);
        }
        if (offset < end && this.escapeChar == chars[end - 1]) {
            return end - 1;
        }
        return end;
    }

    private int removeEscapeChars(char[] chars, int end, int firstEscapeChar) {
        int j = firstEscapeChar;
        boolean escaped = true;
        for (int i = firstEscapeChar + 1; i < end; ++i) {
            boolean bl = escaped = chars[i] == this.escapeChar && !escaped;
            if (escaped) continue;
            chars[j++] = chars[i];
        }
        return j;
    }

    @Override
    public final void finish(CellConsumer cellConsumer) {
        if (this._currentIndex > this.csvBuffer.mark || (this._currentState & 4) != 0) {
            this.newCell(this._currentIndex, cellConsumer);
        }
        cellConsumer.end();
    }

    @Override
    public final boolean refillBuffer() throws IOException {
        this._currentIndex -= this.csvBuffer.shiftBufferToMark();
        return this.csvBuffer.fillBuffer();
    }
}

