/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.parser;

import java.util.Arrays;
import org.sfm.csv.impl.cellreader.StringCellValueReader;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.RowHandler;

public final class StringArrayConsumer<RH extends RowHandler<String[]>>
implements CellConsumer {
    private final RH handler;
    private String[] currentRow = new String[8];
    private int currentIndex;

    public StringArrayConsumer(RH handler) {
        this.handler = handler;
    }

    @Override
    public void newCell(char[] chars, int offset, int length) {
        if (this.currentIndex >= this.currentRow.length) {
            this.currentRow = Arrays.copyOf(this.currentRow, this.currentRow.length * 2);
        }
        this.currentRow[this.currentIndex++] = StringCellValueReader.readString(chars, offset, length);
    }

    @Override
    public void endOfRow() {
        try {
            String[] result = Arrays.copyOf(this.currentRow, this.currentIndex);
            this.handler.handle((String[])result);
            this.resetRow(this.currentRow, this.currentIndex);
            this.currentIndex = 0;
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
        }
    }

    private void resetRow(String[] row, int currentIndex) {
        for (int i = 0; i < currentIndex; ++i) {
            row[i] = null;
        }
    }

    public RH handler() {
        return this.handler;
    }

    @Override
    public void end() {
        if (!this.isEmpty()) {
            this.endOfRow();
        }
    }

    private boolean isEmpty() {
        return this.currentIndex == 0;
    }

    public static <RH extends RowHandler<String[]>> StringArrayConsumer<RH> newInstance(RH handler) {
        return new StringArrayConsumer<RH>(handler);
    }
}

