/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sfm.jdbc.Crud;
import org.sfm.jdbc.JdbcMapperFactory;
import org.sfm.jdbc.impl.CrudFactory;
import org.sfm.jdbc.impl.CrudMeta;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.AliasProviderFactory;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.DefaultPropertyNameMatcher;
import org.sfm.reflect.meta.Table;

public class CrudDSL<T, K> {
    private final ClassMeta<T> target;
    private final ClassMeta<K> keyTarget;
    private final JdbcMapperFactory jdbcMapperFactory;

    public CrudDSL(ClassMeta<T> target, ClassMeta<K> keyTarget, JdbcMapperFactory jdbcMapperFactory) {
        this.target = target;
        this.keyTarget = keyTarget;
        this.jdbcMapperFactory = jdbcMapperFactory;
    }

    public Crud<T, K> table(Connection connection, String table) throws SQLException {
        CrudMeta crudMeta = CrudMeta.of(connection, table, this.jdbcMapperFactory.columnDefinitions());
        return CrudFactory.newInstance(this.target, this.keyTarget, crudMeta, this.jdbcMapperFactory);
    }

    public Crud<T, K> to(Connection connection) throws SQLException {
        CrudMeta crudMeta = CrudMeta.of(connection, this.getTable(connection, this.target), this.jdbcMapperFactory.columnDefinitions());
        return CrudFactory.newInstance(this.target, this.keyTarget, crudMeta, this.jdbcMapperFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTable(Connection connection, ClassMeta<T> target) throws SQLException {
        Class targetClass = TypeHelper.toClass(target.getType());
        Table table = AliasProviderFactory.getAliasProvider().getTable(targetClass);
        StringBuilder sb = new StringBuilder();
        if (table.schema() != null && table.schema().length() > 0) {
            sb.append(table.schema()).append(".");
        }
        if (table.table() == null) {
            String className = TypeHelper.toClass(targetClass).getSimpleName();
            try (ResultSet tables = connection.getMetaData().getTables(connection.getCatalog(), null, null, null);){
                while (tables.next()) {
                    String tableName = tables.getString("TABLE_NAME");
                    if (!DefaultPropertyNameMatcher.of(tableName).matches(className)) continue;
                    sb.append(tableName);
                    String string = sb.toString();
                    return string;
                }
            }
            throw new IllegalArgumentException("Type " + target.getType() + " has no table mapping");
        }
        sb.append(table.table());
        return sb.toString();
    }
}

